/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.blocks;

import appeng.api.AEApi;
import appeng.block.AEBaseBlock;
import appeng.client.render.BaseBlockRender;
import appeng.client.texture.ExtraBlockTextures;
import appeng.client.texture.OffsetIcon;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;

public class RenderQuartzGlass
extends BaseBlockRender {
    static byte[][][] offsets;

    public RenderQuartzGlass() {
        super(false, 0.0);
        if (offsets == null) {
            Random r = new Random(924L);
            offsets = new byte[10][10][10];
            for (int x = 0; x < 10; ++x) {
                for (int y = 0; y < 10; ++y) {
                    r.nextBytes(offsets[x][y]);
                }
            }
        }
    }

    @Override
    public void renderInventory(AEBaseBlock block, ItemStack is, RenderBlocks renderer, IItemRenderer.ItemRenderType type, Object[] obj) {
        renderer.field_147840_d = ExtraBlockTextures.GlassFrame.getIcon();
        super.renderInventory(block, is, renderer, type, obj);
        renderer.field_147840_d = null;
        super.renderInventory(block, is, renderer, type, obj);
    }

    @Override
    public boolean renderInWorld(AEBaseBlock imb, IBlockAccess world, int x, int y, int z, RenderBlocks renderer) {
        renderer.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        int cx = Math.abs(x % 10);
        int cy = Math.abs(y % 10);
        int cz = Math.abs(z % 10);
        int u = offsets[cx][cy][cz] % 4;
        int v = offsets[9 - cx][9 - cy][9 - cz] % 4;
        switch (Math.abs((offsets[cx][cy][cz] + (x + y + z)) % 4)) {
            case 0: {
                renderer.field_147840_d = new OffsetIcon(imb.func_149691_a(0, 0), u / 2, v / 2);
                break;
            }
            case 1: {
                renderer.field_147840_d = new OffsetIcon(ExtraBlockTextures.BlockQuartzGlassB.getIcon(), u / 2, v / 2);
                break;
            }
            case 2: {
                renderer.field_147840_d = new OffsetIcon(ExtraBlockTextures.BlockQuartzGlassC.getIcon(), u, v);
                break;
            }
            case 3: {
                renderer.field_147840_d = new OffsetIcon(ExtraBlockTextures.BlockQuartzGlassD.getIcon(), u, v);
            }
        }
        boolean result = renderer.func_147784_q((Block)imb, x, y, z);
        renderer.field_147840_d = null;
        this.renderEdge(imb, world, x, y, z, renderer, ForgeDirection.UP, ForgeDirection.EAST);
        this.renderEdge(imb, world, x, y, z, renderer, ForgeDirection.UP, ForgeDirection.WEST);
        this.renderEdge(imb, world, x, y, z, renderer, ForgeDirection.UP, ForgeDirection.NORTH);
        this.renderEdge(imb, world, x, y, z, renderer, ForgeDirection.UP, ForgeDirection.SOUTH);
        this.renderEdge(imb, world, x, y, z, renderer, ForgeDirection.DOWN, ForgeDirection.EAST);
        this.renderEdge(imb, world, x, y, z, renderer, ForgeDirection.DOWN, ForgeDirection.WEST);
        this.renderEdge(imb, world, x, y, z, renderer, ForgeDirection.DOWN, ForgeDirection.NORTH);
        this.renderEdge(imb, world, x, y, z, renderer, ForgeDirection.DOWN, ForgeDirection.SOUTH);
        this.renderEdge(imb, world, x, y, z, renderer, ForgeDirection.EAST, ForgeDirection.UP);
        this.renderEdge(imb, world, x, y, z, renderer, ForgeDirection.EAST, ForgeDirection.DOWN);
        this.renderEdge(imb, world, x, y, z, renderer, ForgeDirection.EAST, ForgeDirection.NORTH);
        this.renderEdge(imb, world, x, y, z, renderer, ForgeDirection.EAST, ForgeDirection.SOUTH);
        this.renderEdge(imb, world, x, y, z, renderer, ForgeDirection.WEST, ForgeDirection.UP);
        this.renderEdge(imb, world, x, y, z, renderer, ForgeDirection.WEST, ForgeDirection.DOWN);
        this.renderEdge(imb, world, x, y, z, renderer, ForgeDirection.WEST, ForgeDirection.NORTH);
        this.renderEdge(imb, world, x, y, z, renderer, ForgeDirection.WEST, ForgeDirection.SOUTH);
        this.renderEdge(imb, world, x, y, z, renderer, ForgeDirection.NORTH, ForgeDirection.EAST);
        this.renderEdge(imb, world, x, y, z, renderer, ForgeDirection.NORTH, ForgeDirection.WEST);
        this.renderEdge(imb, world, x, y, z, renderer, ForgeDirection.NORTH, ForgeDirection.UP);
        this.renderEdge(imb, world, x, y, z, renderer, ForgeDirection.NORTH, ForgeDirection.DOWN);
        this.renderEdge(imb, world, x, y, z, renderer, ForgeDirection.SOUTH, ForgeDirection.EAST);
        this.renderEdge(imb, world, x, y, z, renderer, ForgeDirection.SOUTH, ForgeDirection.WEST);
        this.renderEdge(imb, world, x, y, z, renderer, ForgeDirection.SOUTH, ForgeDirection.UP);
        this.renderEdge(imb, world, x, y, z, renderer, ForgeDirection.SOUTH, ForgeDirection.DOWN);
        return result;
    }

    void renderEdge(AEBaseBlock imb, IBlockAccess world, int x, int y, int z, RenderBlocks renderer, ForgeDirection side, ForgeDirection direction) {
        if (!this.isFlush(imb, world, x + side.offsetX, y + side.offsetY, z + side.offsetZ) && !this.isFlush(imb, world, x + direction.offsetX, y + direction.offsetY, z + direction.offsetZ)) {
            float minX = 0.5f + (float)(side.offsetX + direction.offsetX) / 2.0f;
            float minY = 0.5f + (float)(side.offsetY + direction.offsetY) / 2.0f;
            float minZ = 0.5f + (float)(side.offsetZ + direction.offsetZ) / 2.0f;
            float maxX = 0.5f + (float)(side.offsetX + direction.offsetX) / 2.0f;
            float maxY = 0.5f + (float)(side.offsetY + direction.offsetY) / 2.0f;
            float maxZ = 0.5f + (float)(side.offsetZ + direction.offsetZ) / 2.0f;
            if (0 == side.offsetX && 0 == direction.offsetX) {
                minX = 0.0f;
                maxX = 1.0f;
            }
            if (0 == side.offsetY && 0 == direction.offsetY) {
                minY = 0.0f;
                maxY = 1.0f;
            }
            if (0 == side.offsetZ && 0 == direction.offsetZ) {
                minZ = 0.0f;
                maxZ = 1.0f;
            }
            if (maxX <= 0.001f) {
                maxX += 0.05625f;
            }
            if (maxY <= 0.001f) {
                maxY += 0.05625f;
            }
            if (maxZ <= 0.001f) {
                maxZ += 0.05625f;
            }
            if (minX >= 0.999f) {
                minX -= 0.05625f;
            }
            if (minY >= 0.999f) {
                minY -= 0.05625f;
            }
            if (minZ >= 0.999f) {
                minZ -= 0.05625f;
            }
            renderer.func_147782_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
            switch (side) {
                case WEST: {
                    renderer.func_147798_e((Block)imb, (double)x, (double)y, (double)z, ExtraBlockTextures.GlassFrame.getIcon());
                    break;
                }
                case EAST: {
                    renderer.func_147764_f((Block)imb, (double)x, (double)y, (double)z, ExtraBlockTextures.GlassFrame.getIcon());
                    break;
                }
                case NORTH: {
                    renderer.func_147761_c((Block)imb, (double)x, (double)y, (double)z, ExtraBlockTextures.GlassFrame.getIcon());
                    break;
                }
                case SOUTH: {
                    renderer.func_147734_d((Block)imb, (double)x, (double)y, (double)z, ExtraBlockTextures.GlassFrame.getIcon());
                    break;
                }
                case DOWN: {
                    renderer.func_147768_a((Block)imb, (double)x, (double)y, (double)z, ExtraBlockTextures.GlassFrame.getIcon());
                    break;
                }
                case UP: {
                    renderer.func_147806_b((Block)imb, (double)x, (double)y, (double)z, ExtraBlockTextures.GlassFrame.getIcon());
                    break;
                }
            }
        }
    }

    boolean isFlush(AEBaseBlock imb, IBlockAccess world, int x, int y, int z) {
        return this.isGlass(imb, world, x, y, z);
    }

    boolean isGlass(AEBaseBlock imb, IBlockAccess world, int x, int y, int z) {
        return this.isQuartzGlass(world, x, y, z) || this.isVibrantQuartzGlass(world, x, y, z);
    }

    private boolean isQuartzGlass(IBlockAccess world, int x, int y, int z) {
        return AEApi.instance().definitions().blocks().quartzGlass().isSameAs(world, x, y, z);
    }

    private boolean isVibrantQuartzGlass(IBlockAccess world, int x, int y, int z) {
        return AEApi.instance().definitions().blocks().quartzVibrantGlass().isSameAs(world, x, y, z);
    }
}

