/*
 * Decompiled with CFR 0.152.
 */
package solarexpansion.items.baseclasses;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import solarexpansion.SolarExpansion;
import solarexpansion.init.SECreativeTabs;
import solarexpansion.references.Refs;
import solarexpansion.utilities.helpers.NBTHelper;

public class RFArmorItemBase
extends ItemArmor
implements IEnergyContainerItem {
    private int maxReceive = 0;
    private int maxExtract = 0;
    private int capacity = 0;

    public RFArmorItemBase(String name) {
        super(ItemArmor.ArmorMaterial.IRON, SolarExpansion.proxy.addArmor("solarHelmet"), 0);
        this.func_77655_b(name);
        this.func_77637_a(SECreativeTabs.SE_TAB);
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public void setMaxReceive(int maxReceive) {
        this.maxReceive = maxReceive;
    }

    public void setMaxExtract(int maxExtract) {
        this.maxExtract = maxExtract;
    }

    public int getCapacity(ItemStack itemStack) {
        return this.capacity;
    }

    public int getMaxExtract(ItemStack itemStack) {
        return this.maxExtract;
    }

    public int getMaxReceive(ItemStack itemStack) {
        return this.maxReceive;
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        int energy = NBTHelper.getInteger(container, "Energy", 0);
        int energyReceived = Math.min(this.getCapacity(container) - energy, Math.min(this.getMaxReceive(container), maxReceive));
        if (!simulate) {
            NBTHelper.setInteger(container, "Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        int energy = NBTHelper.getInteger(container, "Energy", 0);
        int energyExtracted = Math.min(energy, Math.min(this.getMaxExtract(container), maxExtract));
        if (!simulate) {
            NBTHelper.setInteger(container, "Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        return NBTHelper.getInteger(container, "Energy", 0);
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return this.getCapacity(container);
    }

    public boolean showDurabilityBar(ItemStack itemStack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack itemStack) {
        return 1.0 - (double)this.getEnergyStored(itemStack) / (double)this.getMaxEnergyStored(itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.add(NBTHelper.setInteger(new ItemStack(item, 1, 0), "Energy", 0));
        if (this.capacity > 0) {
            list.add(NBTHelper.setInteger(new ItemStack(item, 1, 0), "Energy", this.capacity));
        }
    }

    public String func_77658_a() {
        return String.format("item.%s%s", Refs.RESOURCE_LOCATION, this.getUnwrappedUnlocalizedName(super.func_77658_a()));
    }

    public String func_77667_c(ItemStack itemStack) {
        return String.format("item.%s%s", Refs.RESOURCE_LOCATION, this.getUnwrappedUnlocalizedName(super.func_77658_a()));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a(this.func_77658_a().substring(this.func_77658_a().indexOf(".") + 1));
    }

    protected String getUnwrappedUnlocalizedName(String unlocalizedName) {
        return unlocalizedName.substring(unlocalizedName.indexOf(".") + 1);
    }
}

