/*
 * Decompiled with CFR 0.152.
 */
package solarexpansion.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import solarexpansion.init.SEAchievements;
import solarexpansion.init.SECreativeTabs;
import solarexpansion.references.Refs;
import solarexpansion.tile.TileEntitySolarPanel;
import solarexpansion.utilities.Utils;

public class SolarPanel
extends BlockContainer {
    public final int energyGeneration;
    public final int energyTransfer;
    public final int energyCapacity;

    public SolarPanel(String name, int energyGeneration) {
        super(Material.field_151573_f);
        this.func_149663_c(name);
        this.func_149752_b(100.0f);
        this.func_149711_c(8.0f);
        this.func_149647_a(SECreativeTabs.SE_TAB);
        this.energyGeneration = energyGeneration;
        this.energyTransfer = energyGeneration * 2;
        this.energyCapacity = energyGeneration * 1000;
        this.func_149672_a(field_149769_e);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.75f, 1.0f);
        this.func_149713_g(255);
        this.field_149783_u = true;
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int getEnergyGeneration() {
        return this.energyGeneration;
    }

    public int getEnergyTransfer() {
        return this.energyTransfer;
    }

    public int getEnergyCapacity() {
        return this.energyCapacity;
    }

    public int getEnergyStored(ItemStack itemStack) {
        if (itemStack.field_77990_d != null) {
            return itemStack.field_77990_d.func_74762_e("Energy");
        }
        return 0;
    }

    public int getMaxEnergyStored(ItemStack itemStack) {
        return this.energyCapacity;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntitySolarPanel(this.energyGeneration, this.energyTransfer, this.energyCapacity);
    }

    public boolean func_149696_a(World world, int x, int y, int z, int eventNumber, int eventArgument) {
        super.func_149696_a(world, x, y, z, eventNumber, eventArgument);
        TileEntity tileentity = world.func_147438_o(x, y, z);
        if (tileentity != null) {
            return tileentity.func_145842_c(eventNumber, eventArgument);
        }
        return false;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float f1, float f2, float f3) {
        if (player.func_71045_bC() != null && Utils.hasUsableWrench(player, x, y, z)) {
            if (!world.field_72995_K && player.func_70093_af()) {
                this.dismantleBlock(world, x, y, z);
                return true;
            }
            world.func_147459_d(x, y, z, (Block)this);
            return false;
        }
        return false;
    }

    public void dismantleBlock(World world, int x, int y, int z) {
        ItemStack itemStack = new ItemStack((Block)this);
        float motion = 0.7f;
        double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
        double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
        double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
        EntityItem entityItem = new EntityItem(world, (double)x + motionX, (double)y + motionY, (double)z + motionZ, itemStack);
        TileEntitySolarPanel tileEntity = (TileEntitySolarPanel)world.func_147438_o(x, y, z);
        int energyStored = tileEntity.getEnergyStored();
        if (energyStored >= 1) {
            if (itemStack.func_77978_p() == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            itemStack.func_77978_p().func_74768_a("Energy", energyStored);
        }
        world.func_147468_f(x, y, z);
        world.func_72838_d((Entity)entityItem);
    }

    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        return true;
    }

    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        return true;
    }

    public String func_149739_a() {
        return String.format("tile.%s%s", Refs.RESOURCE_LOCATION, this.unwrapUnlocalizedName(super.func_149739_a()));
    }

    protected String func_149641_N() {
        return this.unwrapUnlocalizedName(this.func_149739_a());
    }

    protected String unwrapUnlocalizedName(String pUnlocalizedName) {
        return pUnlocalizedName.substring(pUnlocalizedName.indexOf(".") + 1);
    }

    public static class Ultimate
    extends SolarPanel {
        public Ultimate(String name, int energyGeneration) {
            super(name, energyGeneration);
        }

        @Override
        public TileEntity func_149915_a(World world, int meta) {
            return new TileEntitySolarPanel.Ultimate(this.energyGeneration, this.energyTransfer, this.energyCapacity);
        }

        public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemStack) {
            if (itemStack.field_77990_d != null) {
                TileEntitySolarPanel tileEntity = (TileEntitySolarPanel)world.func_147438_o(x, y, z);
                tileEntity.setEnergyStored(itemStack.field_77990_d.func_74762_e("Energy"));
            }
            EntityPlayer player = (EntityPlayer)entity;
            player.func_71064_a((StatBase)SEAchievements.SolarPanelUltimateAch, 1);
        }
    }

    public static class Advanced
    extends SolarPanel {
        public Advanced(String name, int energyGeneration) {
            super(name, energyGeneration);
        }

        @Override
        public TileEntity func_149915_a(World world, int meta) {
            return new TileEntitySolarPanel.Advanced(this.energyGeneration, this.energyTransfer, this.energyCapacity);
        }

        public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemStack) {
            if (itemStack.field_77990_d != null) {
                TileEntitySolarPanel tileEntity = (TileEntitySolarPanel)world.func_147438_o(x, y, z);
                tileEntity.setEnergyStored(itemStack.field_77990_d.func_74762_e("Energy"));
            }
            EntityPlayer player = (EntityPlayer)entity;
            player.func_71064_a((StatBase)SEAchievements.SolarPanelAdvancedAch, 1);
        }
    }

    public static class Resonant
    extends SolarPanel {
        public Resonant(String name, int energyGeneration) {
            super(name, energyGeneration);
        }

        @Override
        public TileEntity func_149915_a(World world, int meta) {
            return new TileEntitySolarPanel.Resonant(this.energyGeneration, this.energyTransfer, this.energyCapacity);
        }

        public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemStack) {
            if (itemStack.field_77990_d != null) {
                TileEntitySolarPanel tileEntity = (TileEntitySolarPanel)world.func_147438_o(x, y, z);
                tileEntity.setEnergyStored(itemStack.field_77990_d.func_74762_e("Energy"));
            }
            EntityPlayer player = (EntityPlayer)entity;
            player.func_71064_a((StatBase)SEAchievements.SolarPanelResonantAch, 1);
        }
    }

    public static class Redstone
    extends SolarPanel {
        public Redstone(String name, int energyGeneration) {
            super(name, energyGeneration);
        }

        @Override
        public TileEntity func_149915_a(World world, int meta) {
            return new TileEntitySolarPanel.Redstone(this.energyGeneration, this.energyTransfer, this.energyCapacity);
        }

        public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemStack) {
            if (itemStack.field_77990_d != null) {
                TileEntitySolarPanel tileEntity = (TileEntitySolarPanel)world.func_147438_o(x, y, z);
                tileEntity.setEnergyStored(itemStack.field_77990_d.func_74762_e("Energy"));
            }
            EntityPlayer player = (EntityPlayer)entity;
            player.func_71064_a((StatBase)SEAchievements.SolarPanelRedstoneAch, 1);
        }
    }

    public static class Hardened
    extends SolarPanel {
        public Hardened(String name, int energyGeneration) {
            super(name, energyGeneration);
        }

        @Override
        public TileEntity func_149915_a(World world, int meta) {
            return new TileEntitySolarPanel.Hardened(this.energyGeneration, this.energyTransfer, this.energyCapacity);
        }

        public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemStack) {
            if (itemStack.field_77990_d != null) {
                TileEntitySolarPanel tileEntity = (TileEntitySolarPanel)world.func_147438_o(x, y, z);
                tileEntity.setEnergyStored(itemStack.field_77990_d.func_74762_e("Energy"));
            }
            EntityPlayer player = (EntityPlayer)entity;
            player.func_71064_a((StatBase)SEAchievements.SolarPanelHardenedAch, 1);
        }
    }

    public static class Leadstone
    extends SolarPanel {
        public Leadstone(String name, int energyGeneration) {
            super(name, energyGeneration);
        }

        @Override
        public TileEntity func_149915_a(World world, int meta) {
            return new TileEntitySolarPanel.Leadstone(this.energyGeneration, this.energyTransfer, this.energyCapacity);
        }

        public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemStack) {
            if (itemStack.field_77990_d != null) {
                TileEntitySolarPanel tileEntity = (TileEntitySolarPanel)world.func_147438_o(x, y, z);
                tileEntity.setEnergyStored(itemStack.field_77990_d.func_74762_e("Energy"));
            }
            EntityPlayer player = (EntityPlayer)entity;
            player.func_71064_a((StatBase)SEAchievements.SolarPanelLeadstoneAch, 1);
        }
    }
}

