/*
 * Decompiled with CFR 0.152.
 */
package myrathi.obsidiplates.block;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import myrathi.obsidiplates.ObsidiPlates;
import myrathi.obsidiplates.item.ItemMultiPressurePlate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockMultiPressurePlate
extends Block {
    public BlockMultiPressurePlate() {
        super(Material.field_151576_e);
        this.func_149672_a(Block.field_149769_e);
        this.func_149647_a(CreativeTabs.field_78028_d);
        this.func_149675_a(true);
        this.setBlockBoundsBasedOnState(this.getActiveStateFromWeight(15));
        GameRegistry.registerBlock((Block)this, ItemMultiPressurePlate.class, (String)"ObsidianPressurePlate");
        EnumPlates.registerNames(this);
    }

    public float func_149712_f(World world, int x, int y, int z) {
        EnumPlates type = EnumPlates.typeFromMeta(world.func_72805_g(x, y, z));
        return type.block.func_149712_f(world, x, y, z) * type.getHardnessModifier();
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double expX, double expY, double expZ) {
        EnumPlates type = EnumPlates.typeFromMeta(world.func_72805_g(x, y, z));
        return type.block.getExplosionResistance(entity, world, x, y, z, expX, expY, expZ);
    }

    protected int getPowerSupply(int metadata) {
        return (metadata & 1) > 0 ? 15 : 0;
    }

    protected int getPlateState(World world, int x, int y, int z) {
        boolean players = EnumPlates.isPlayerDetector(world.func_72805_g(x, y, z));
        List list = world.func_72872_a(players ? EntityPlayer.class : EntityLiving.class, this.getSensitiveAABB(x, y, z));
        for (Object le : list) {
            Entity e;
            if (!(le instanceof Entity) || (e = (Entity)le) == null || e.func_145773_az() || !(players ^ !(e instanceof EntityPlayer))) continue;
            return 15;
        }
        return 0;
    }

    public void func_149719_a(IBlockAccess blk, int x, int y, int z) {
        this.setBlockBoundsBasedOnState(blk.func_72805_g(x, y, z));
    }

    protected void setBlockBoundsBasedOnState(int metadata) {
        float f = 0.0625f;
        boolean active = this.getPowerSupply(metadata) > 0;
        this.func_149676_a(f, 0.0f, f, 1.0f - f, active ? 0.03125f : 0.0625f, 1.0f - f);
    }

    protected int getActiveStateFromWeight(int weight) {
        return weight > 0 ? 1 : 0;
    }

    public int func_149738_a(World world) {
        return 20;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return ObsidiPlates.proxy.renderId_MultiPressurePlate;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return 1;
    }

    public boolean func_149655_b(IBlockAccess blk, int x, int y, int z) {
        return true;
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z) || BlockFence.func_149825_a((Block)world.func_147439_a(x, y - 1, z));
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z) && !BlockFence.func_149825_a((Block)world.func_147439_a(x, y - 1, z))) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random rnd) {
        int lvl;
        if (!world.field_72995_K && (lvl = this.getPowerSupply(world.func_72805_g(x, y, z))) > 0) {
            this.setStateIfMobInteractsWithPlate(world, x, y, z, lvl);
        }
    }

    public void func_149670_a(World world, int x, int y, int z, Entity ent) {
        int lvl;
        if (!world.field_72995_K && (lvl = this.getPowerSupply(world.func_72805_g(x, y, z))) == 0) {
            this.setStateIfMobInteractsWithPlate(world, x, y, z, lvl);
        }
    }

    protected void setStateIfMobInteractsWithPlate(World world, int x, int y, int z, int stateNew) {
        int stateCur = this.getPlateState(world, x, y, z);
        boolean activeNew = stateNew > 0;
        boolean activeCur = stateCur > 0;
        int meta = world.func_72805_g(x, y, z);
        if (stateNew != stateCur) {
            int activeBit = this.getActiveStateFromWeight(stateCur);
            meta = meta & 0xFFFFFFFE | activeBit;
            world.func_72921_c(x, y, z, meta, 2);
            this.notifyNeighbourOfChange(world, x, y, z);
            world.func_147458_c(x, y, z, x, y, z);
        }
        if (!EnumPlates.isPlateSilent(meta) && activeCur ^ activeNew) {
            world.func_72908_a((double)x + 0.5, (double)y + 0.1, (double)z + 0.5, "random.click", 0.3f, activeNew ? 0.5f : 0.6f);
        }
        if (activeCur) {
            world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
        }
    }

    protected AxisAlignedBB getSensitiveAABB(int x, int y, int z) {
        float f = 0.125f;
        return AxisAlignedBB.func_72330_a((double)((float)x + f), (double)y, (double)((float)z + f), (double)((float)(x + 1) - f), (double)((double)y + 0.25), (double)((float)(z + 1) - f));
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int metadata) {
        if (this.getPowerSupply(metadata) > 0) {
            this.notifyNeighbourOfChange(world, x, y, z);
        }
        super.func_149749_a(world, x, y, z, block, metadata);
    }

    protected void notifyNeighbourOfChange(World world, int x, int y, int z) {
        world.func_147459_d(x, y, z, (Block)this);
        world.func_147459_d(x, y - 1, z, (Block)this);
    }

    public int func_149709_b(IBlockAccess blk, int x, int y, int z, int side) {
        return this.getPowerSupply(blk.func_72805_g(x, y, z));
    }

    public int func_149748_c(IBlockAccess blk, int x, int y, int z, int side) {
        return ForgeDirection.getOrientation((int)side).equals((Object)ForgeDirection.UP) ? this.getPowerSupply(blk.func_72805_g(x, y, z)) : 0;
    }

    public boolean func_149744_f() {
        return true;
    }

    public void func_149683_g() {
        float f = 0.5f;
        float f1 = 0.125f;
        float f2 = 0.5f;
        this.func_149676_a(0.5f - f, 0.5f - f1, 0.5f - f2, 0.5f + f, 0.5f + f1, 0.5f + f2);
    }

    public int func_149656_h() {
        return 1;
    }

    protected boolean isPlateActive(int metadata) {
        return (metadata & 1) > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        if (!ForgeDirection.getOrientation((int)side).equals((Object)ForgeDirection.UP) && EnumPlates.isPlateSilent(metadata)) {
            return Blocks.field_150325_L.func_149691_a(side, 0);
        }
        return EnumPlates.typeFromMeta((int)metadata).block.func_149733_h(side);
    }

    public int func_149692_a(int metadata) {
        return metadata & 0xFFFFFFFE;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (EnumPlates plate : EnumPlates.values()) {
            if (plate.equals((Object)EnumPlates.UNKNOWN)) continue;
            list.add(new ItemStack(item, 1, plate.getMeta(false, false)));
            list.add(new ItemStack(item, 1, plate.getMeta(false, true)));
            list.add(new ItemStack(item, 1, plate.getMeta(true, false)));
            list.add(new ItemStack(item, 1, plate.getMeta(true, true)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconReg) {
    }

    public static enum EnumPlates {
        OBSIDIAN(Blocks.field_150343_Z, "Players", true, 0.25f),
        MOSSY(Blocks.field_150341_Y, "NPCs", false, 1.0f),
        UNKNOWN(null, "UNKNOWN", false, 0.0f);

        public final Block block;
        public final String unlocalizedPrefix;
        public final String localizedInsert;
        public final boolean forPlayers;
        public final float hardnessMod;

        private EnumPlates(Block block, String name, boolean player, float hardnessMod) {
            this.block = block;
            this.unlocalizedPrefix = Blocks.field_150452_aw.func_149739_a() + "." + this.name();
            this.localizedInsert = name;
            this.forPlayers = player;
            this.hardnessMod = hardnessMod;
        }

        public int getMeta(boolean silent, boolean hidden) {
            return (this.ordinal() & 1) << 2 | (silent ? 2 : 0) | (hidden ? 8 : 0);
        }

        public float getHardnessModifier() {
            return this.hardnessMod;
        }

        public ItemStack getIS(boolean silent, boolean hidden) {
            return new ItemStack((Block)ObsidiPlates.blockObsidiPlate, 1, this.getMeta(silent, hidden));
        }

        public static EnumPlates typeFromMeta(int metadata) {
            int plate = metadata >>> 2 & 1;
            if (plate >= UNKNOWN.ordinal()) {
                return UNKNOWN;
            }
            return EnumPlates.values()[plate];
        }

        public static String getUnlocalizedNameFromDamage(int damage) {
            boolean hidden = EnumPlates.isPlateHidden(damage);
            boolean silent = EnumPlates.isPlateSilent(damage);
            String suffix = hidden && silent ? ".both" : (hidden ? ".hidden" : (silent ? ".silent" : ""));
            return EnumPlates.typeFromMeta((int)damage).unlocalizedPrefix.concat(suffix);
        }

        public static boolean isPlayerDetector(int metadata) {
            return EnumPlates.typeFromMeta((int)metadata).forPlayers;
        }

        public static boolean isPlateHidden(int metadata) {
            return (metadata & 8) > 0;
        }

        public static boolean isPlateSilent(int metadata) {
            return (metadata & 2) > 0;
        }

        public static void registerNames(BlockMultiPressurePlate block) {
            String name = Blocks.field_150452_aw.func_149732_F();
            for (EnumPlates plate : EnumPlates.values()) {
                if (plate.equals((Object)UNKNOWN)) continue;
                LanguageRegistry.instance().addStringLocalization(plate.unlocalizedPrefix + ".name", name);
                LanguageRegistry.instance().addStringLocalization(plate.unlocalizedPrefix + ".hidden.name", name.concat(" (Shrouded)"));
                LanguageRegistry.instance().addStringLocalization(plate.unlocalizedPrefix + ".silent.name", name.concat(" (Silent)"));
                LanguageRegistry.instance().addStringLocalization(plate.unlocalizedPrefix + ".both.name", name.concat(" (Shrouded, Silent)"));
            }
        }
    }
}

