/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.network.IGuiHandler;
import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.CircuitSocketType;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.recipes.RecipeManagers;
import forestry.core.blocks.BlockBase;
import forestry.core.circuits.Circuit;
import forestry.core.circuits.CircuitLayout;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.config.GameMode;
import forestry.core.fluids.Fluids;
import forestry.core.items.ItemBlockForestry;
import forestry.core.items.ItemBlockNBT;
import forestry.core.network.PacketIdClient;
import forestry.core.network.PacketIdServer;
import forestry.core.proxy.Proxies;
import forestry.core.recipes.RecipeUtil;
import forestry.core.recipes.ShapedRecipeCustom;
import forestry.core.recipes.craftguide.CraftGuideIntegration;
import forestry.core.recipes.nei.PacketWorktableNEISelect;
import forestry.core.tiles.MachineDefinition;
import forestry.core.utils.Log;
import forestry.core.utils.ModUtil;
import forestry.factory.DummyManagers;
import forestry.factory.GuiHandlerFactory;
import forestry.factory.circuits.CircuitSpeedUpgrade;
import forestry.factory.network.PacketWorktableMemoryUpdate;
import forestry.factory.recipes.CarpenterRecipeManager;
import forestry.factory.recipes.CentrifugeRecipeManager;
import forestry.factory.recipes.FabricatorRecipeManager;
import forestry.factory.recipes.FabricatorSmeltingRecipeManager;
import forestry.factory.recipes.FermenterRecipeManager;
import forestry.factory.recipes.MoistenerRecipeManager;
import forestry.factory.recipes.SqueezerRecipeManager;
import forestry.factory.recipes.StillRecipeManager;
import forestry.factory.tiles.TileBottler;
import forestry.factory.tiles.TileCarpenter;
import forestry.factory.tiles.TileCentrifuge;
import forestry.factory.tiles.TileFabricator;
import forestry.factory.tiles.TileFermenter;
import forestry.factory.tiles.TileMillRainmaker;
import forestry.factory.tiles.TileMoistener;
import forestry.factory.tiles.TileRaintank;
import forestry.factory.tiles.TileSqueezer;
import forestry.factory.tiles.TileStill;
import forestry.factory.tiles.TileWorktable;
import forestry.factory.triggers.FactoryTriggers;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import forestry.plugins.PluginManager;
import forestry.plugins.PluginStorage;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

@Plugin(pluginID="Factory", name="Factory", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.factory.description")
public class PluginFactory
extends ForestryPlugin {
    private static MachineDefinition definitionBottler;
    private static MachineDefinition definitionCarpenter;
    private static MachineDefinition definitionCentrifuge;
    private static MachineDefinition definitionFermenter;
    private static MachineDefinition definitionMoistener;
    private static MachineDefinition definitionSqueezer;
    private static MachineDefinition definitionStill;
    private static MachineDefinition definitionRainmaker;
    private static MachineDefinition definitionFabricator;
    private static MachineDefinition definitionRaintank;
    private static MachineDefinition definitionWorktable;

    @Override
    protected void setupAPI() {
        super.setupAPI();
        RecipeManagers.carpenterManager = new CarpenterRecipeManager();
        RecipeManagers.centrifugeManager = new CentrifugeRecipeManager();
        RecipeManagers.fabricatorManager = new FabricatorRecipeManager();
        RecipeManagers.fabricatorSmeltingManager = new FabricatorSmeltingRecipeManager();
        RecipeManagers.fermenterManager = new FermenterRecipeManager();
        RecipeManagers.moistenerManager = new MoistenerRecipeManager();
        RecipeManagers.squeezerManager = new SqueezerRecipeManager();
        RecipeManagers.stillManager = new StillRecipeManager();
        RecipeManagers.craftingProviders = ImmutableList.of((Object)RecipeManagers.carpenterManager, (Object)RecipeManagers.centrifugeManager, (Object)RecipeManagers.fabricatorManager, (Object)RecipeManagers.fabricatorSmeltingManager, (Object)RecipeManagers.fermenterManager, (Object)RecipeManagers.moistenerManager, (Object)RecipeManagers.squeezerManager, (Object)RecipeManagers.stillManager);
    }

    @Override
    public void registerPacketHandlers() {
        PacketIdServer.WORKTABLE_NEI_SELECT.setPacketHandler(new PacketWorktableNEISelect());
        PacketIdClient.WORKTABLE_MEMORY_UPDATE.setPacketHandler(new PacketWorktableMemoryUpdate());
    }

    @Override
    protected void disabledSetupAPI() {
        super.disabledSetupAPI();
        RecipeManagers.carpenterManager = new DummyManagers.DummyCarpenterManager();
        RecipeManagers.centrifugeManager = new DummyManagers.DummyCentrifugeManager();
        RecipeManagers.fabricatorManager = new DummyManagers.DummyFabricatorManager();
        RecipeManagers.fabricatorSmeltingManager = new DummyManagers.DummyFabricatorSmeltingManager();
        RecipeManagers.fermenterManager = new DummyManagers.DummyFermenterManager();
        RecipeManagers.moistenerManager = new DummyManagers.DummyMoistenerManager();
        RecipeManagers.squeezerManager = new DummyManagers.DummySqueezerManager();
        RecipeManagers.stillManager = new DummyManagers.DummyStillManager();
        RecipeManagers.craftingProviders = ImmutableList.of((Object)RecipeManagers.carpenterManager, (Object)RecipeManagers.centrifugeManager, (Object)RecipeManagers.fabricatorManager, (Object)RecipeManagers.fabricatorSmeltingManager, (Object)RecipeManagers.fermenterManager, (Object)RecipeManagers.moistenerManager, (Object)RecipeManagers.squeezerManager, (Object)RecipeManagers.stillManager);
    }

    @Override
    public void preInit() {
        super.preInit();
        ForestryBlock.factoryTESR.registerBlock((Block)new BlockBase(Material.field_151573_f, true), ItemBlockForestry.class, "factory");
        BlockBase factoryTESR = (BlockBase)ForestryBlock.factoryTESR.block();
        definitionBottler = factoryTESR.addDefinition(new MachineDefinition(0, "forestry.Bottler", TileBottler.class, Proxies.render.getRenderDefaultMachine("textures/blocks/bottler_"), ShapedRecipeCustom.createShapedRecipe(ForestryBlock.factoryTESR.getItemStack(1, 0), new Object[]{"X#X", "#Y#", "X#X", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), ForestryItem.canEmpty, Character.valueOf('Y'), ForestryItem.sturdyCasing})));
        definitionCarpenter = factoryTESR.addDefinition(new MachineDefinition(1, "forestry.Carpenter", TileCarpenter.class, Proxies.render.getRenderDefaultMachine("textures/blocks/carpenter_"), ShapedRecipeCustom.createShapedRecipe(ForestryBlock.factoryTESR.getItemStack(1, 1), new Object[]{"X#X", "XYX", "X#X", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "ingotBronze", Character.valueOf('Y'), ForestryItem.sturdyCasing})));
        definitionCentrifuge = factoryTESR.addDefinition(new MachineDefinition(2, "forestry.Centrifuge", TileCentrifuge.class, Proxies.render.getRenderDefaultMachine("textures/blocks/centrifuge_"), ShapedRecipeCustom.createShapedRecipe(ForestryBlock.factoryTESR.getItemStack(1, 2), "X#X", "XYX", "X#X", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "ingotCopper", Character.valueOf('Y'), ForestryItem.sturdyCasing.getItemStack())));
        definitionFermenter = factoryTESR.addDefinition(new MachineDefinition(3, "forestry.Fermenter", TileFermenter.class, Proxies.render.getRenderDefaultMachine("textures/blocks/fermenter_"), ShapedRecipeCustom.createShapedRecipe(ForestryBlock.factoryTESR.getItemStack(1, 3), new Object[]{"X#X", "#Y#", "X#X", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "gearBronze", Character.valueOf('Y'), ForestryItem.sturdyCasing})));
        definitionMoistener = factoryTESR.addDefinition(new MachineDefinition(4, "forestry.Moistener", TileMoistener.class, Proxies.render.getRenderDefaultMachine("textures/blocks/moistener_"), ShapedRecipeCustom.createShapedRecipe(ForestryBlock.factoryTESR.getItemStack(1, 4), new Object[]{"X#X", "#Y#", "X#X", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "gearCopper", Character.valueOf('Y'), ForestryItem.sturdyCasing})));
        definitionSqueezer = factoryTESR.addDefinition(new MachineDefinition(5, "forestry.Squeezer", TileSqueezer.class, Proxies.render.getRenderDefaultMachine("textures/blocks/squeezer_"), ShapedRecipeCustom.createShapedRecipe(ForestryBlock.factoryTESR.getItemStack(1, 5), "X#X", "XYX", "X#X", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "ingotTin", Character.valueOf('Y'), ForestryItem.sturdyCasing.getItemStack())));
        definitionStill = factoryTESR.addDefinition(new MachineDefinition(6, "forestry.Still", TileStill.class, Proxies.render.getRenderDefaultMachine("textures/blocks/still_"), ShapedRecipeCustom.createShapedRecipe(ForestryBlock.factoryTESR.getItemStack(1, 6), new Object[]{"X#X", "#Y#", "X#X", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "dustRedstone", Character.valueOf('Y'), ForestryItem.sturdyCasing})));
        definitionRainmaker = factoryTESR.addDefinition(new MachineDefinition(7, "forestry.Rainmaker", TileMillRainmaker.class, Proxies.render.getRenderMill("textures/blocks/rainmaker_"), ShapedRecipeCustom.createShapedRecipe(ForestryBlock.factoryTESR.getItemStack(1, 7), new Object[]{"X#X", "#Y#", "X#X", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "gearTin", Character.valueOf('Y'), ForestryItem.hardenedCasing})));
        ForestryBlock.factoryPlain.registerBlock((Block)new BlockBase(Material.field_151573_f), ItemBlockNBT.class, "factory2");
        BlockBase factoryPlain = (BlockBase)ForestryBlock.factoryPlain.block();
        definitionFabricator = factoryPlain.addDefinition(new MachineDefinition(0, "forestry.Fabricator", TileFabricator.class, ShapedRecipeCustom.createShapedRecipe(ForestryBlock.factoryPlain.getItemStack(1, 0), new Object[]{"X#X", "#Y#", "XZX", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "ingotGold", Character.valueOf('Y'), ForestryItem.sturdyCasing, Character.valueOf('Z'), "chestWood"})).setFaces(0, 1, 2, 3, 4, 4));
        definitionRaintank = factoryPlain.addDefinition(new MachineDefinition(1, "forestry.Raintank", TileRaintank.class, ShapedRecipeCustom.createShapedRecipe(ForestryBlock.factoryPlain.getItemStack(1, 1), new Object[]{"X#X", "XYX", "X#X", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "ingotIron", Character.valueOf('Y'), ForestryItem.sturdyCasing})).setFaces(0, 1, 0, 0, 0, 0));
        definitionWorktable = factoryPlain.addDefinition(new MachineDefinition(2, "forestry.Worktable", TileWorktable.class, ShapedRecipeCustom.createShapedRecipe(ForestryBlock.factoryPlain.getItemStack(1, 2), "B", "W", "C", Character.valueOf('B'), Items.field_151122_aG, Character.valueOf('W'), "craftingTableWood", Character.valueOf('C'), "chestWood")).setFaces(0, 1, 2, 3, 4, 4));
        CircuitLayout layoutMachineUpgrade = new CircuitLayout("machine.upgrade", CircuitSocketType.MACHINE);
        ChipsetManager.circuitRegistry.registerLayout(layoutMachineUpgrade);
    }

    @Override
    protected void registerTriggers() {
        FactoryTriggers.initialize();
    }

    @Override
    public void doInit() {
        super.doInit();
        definitionBottler.register();
        definitionCarpenter.register();
        definitionCentrifuge.register();
        definitionFabricator.register();
        definitionFermenter.register();
        definitionMoistener.register();
        definitionRaintank.register();
        definitionSqueezer.register();
        definitionStill.register();
        definitionRainmaker.register();
        definitionWorktable.register();
        Circuit.machineSpeedUpgrade1 = new CircuitSpeedUpgrade("machine.speed.boost.1", 0.125, 0.05f, 4);
        Circuit.machineSpeedUpgrade2 = new CircuitSpeedUpgrade("machine.speed.boost.2", 0.25, 0.1f, 4);
        Circuit.machineEfficiencyUpgrade1 = new CircuitSpeedUpgrade("machine.efficiency.1", 0.0, -0.1f, 2);
    }

    @Override
    public void postInit() {
        super.postInit();
        if (ModUtil.isModLoaded("craftguide")) {
            CraftGuideIntegration.register();
        } else {
            Log.info("Skipping CraftGuide integration.");
        }
    }

    @Override
    protected void registerRecipes() {
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), ForestryItem.tubes.getItemStack(4, 0), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), "ingotCopper"});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), ForestryItem.tubes.getItemStack(4, 1), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), "ingotTin"});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), ForestryItem.tubes.getItemStack(4, 2), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), "ingotBronze"});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), ForestryItem.tubes.getItemStack(4, 3), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), "ingotIron"});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), ForestryItem.tubes.getItemStack(4, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), "ingotGold"});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), ForestryItem.tubes.getItemStack(4, 5), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), "gemDiamond"});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), ForestryItem.tubes.getItemStack(4, 6), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), Blocks.field_150343_Z});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), ForestryItem.tubes.getItemStack(4, 7), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), Items.field_151065_br});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), ForestryItem.tubes.getItemStack(4, 9), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), "gemEmerald"});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), ForestryItem.tubes.getItemStack(4, 10), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), "gemApatite"});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), ForestryItem.tubes.getItemStack(4, 11), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), new ItemStack(Items.field_151100_aR, 1, 4)});
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), ForestryItem.tubes.getItemStack(4, 12), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), new ItemStack(Items.field_151061_bv, 1, 0), Character.valueOf('X'), new ItemStack(Blocks.field_150377_bs, 1, 0)});
        String[] dyes = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
        if (PluginManager.Module.APICULTURE.isEnabled()) {
            FluidStack liquidGlass = Fluids.GLASS.getFluid(1000);
            for (int i = 0; i < 16; ++i) {
                RecipeManagers.fabricatorManager.addRecipe(ForestryItem.waxCast.getItemStack(1, Short.MAX_VALUE), liquidGlass, new ItemStack((Block)Blocks.field_150399_cn, 4, 15 - i), new Object[]{"#", "X", Character.valueOf('#'), dyes[i], Character.valueOf('X'), ForestryItem.propolis.getItemStack(1, Short.MAX_VALUE)});
            }
        }
        int appleMulchAmount = GameMode.getGameMode().getIntegerSetting("squeezer.mulch.apple");
        int appleJuiceAmount = GameMode.getGameMode().getIntegerSetting("squeezer.liquid.apple");
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(Items.field_151034_e)}, Fluids.JUICE.getFluid(appleJuiceAmount), ForestryItem.mulch.getItemStack(), appleMulchAmount);
        int seedOilAmount = GameMode.getGameMode().getIntegerSetting("squeezer.liquid.seed");
        FluidStack seedOil = Fluids.SEEDOIL.getFluid(seedOilAmount);
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(Items.field_151014_N)}, seedOil);
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(Items.field_151080_bb)}, seedOil);
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(Items.field_151081_bc)}, seedOil);
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{ForestryItem.phosphor.getItemStack(2), new ItemStack(Blocks.field_150347_e)}, Fluids.LAVA.getFluid(1600));
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(Blocks.field_150434_aF)}, Fluids.WATER.getFluid(500));
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(Items.field_151126_ay), ForestryItem.craftingMaterial.getItemStack(4, 5)}, Fluids.ICE.getFluid(4000));
        RecipeManagers.stillManager.addRecipe(100, Fluids.BIOMASS.getFluid(10), Fluids.ETHANOL.getFluid(3));
        if (FluidRegistry.isFluidRegistered((String)Fluids.LEGACY_HONEY.name())) {
            RecipeManagers.stillManager.addRecipe(1, Fluids.LEGACY_HONEY.getFluid(1000), Fluids.HONEY.getFluid(1000));
        }
        RecipeManagers.moistenerManager.addRecipe(new ItemStack(Items.field_151014_N), new ItemStack((Block)Blocks.field_150391_bh), 5000);
        RecipeManagers.moistenerManager.addRecipe(new ItemStack(Blocks.field_150347_e), new ItemStack(Blocks.field_150341_Y), 20000);
        RecipeManagers.moistenerManager.addRecipe(new ItemStack(Blocks.field_150417_aV), new ItemStack(Blocks.field_150417_aV, 1, 1), 20000);
        for (int i = 0; i < 6; ++i) {
            RecipeUtil.addFermenterRecipes(new ItemStack(Blocks.field_150345_g, 1, i), GameMode.getGameMode().getIntegerSetting("fermenter.yield.sapling"), Fluids.BIOMASS);
        }
        RecipeUtil.addFermenterRecipes(new ItemStack(Blocks.field_150434_aF), GameMode.getGameMode().getIntegerSetting("fermenter.yield.cactus"), Fluids.BIOMASS);
        RecipeUtil.addFermenterRecipes(new ItemStack(Items.field_151015_O), GameMode.getGameMode().getIntegerSetting("fermenter.yield.wheat"), Fluids.BIOMASS);
        RecipeUtil.addFermenterRecipes(new ItemStack(Items.field_151120_aE), GameMode.getGameMode().getIntegerSetting("fermenter.yield.cane"), Fluids.BIOMASS);
        RecipeUtil.addFermenterRecipes(new ItemStack((Block)Blocks.field_150338_P), GameMode.getGameMode().getIntegerSetting("fermenter.yield.mushroom"), Fluids.BIOMASS);
        RecipeUtil.addFermenterRecipes(new ItemStack((Block)Blocks.field_150337_Q), GameMode.getGameMode().getIntegerSetting("fermenter.yield.mushroom"), Fluids.BIOMASS);
        RecipeManagers.fabricatorSmeltingManager.addSmelting(new ItemStack(Blocks.field_150359_w), Fluids.GLASS.getFluid(1000), 1000);
        RecipeManagers.fabricatorSmeltingManager.addSmelting(new ItemStack(Blocks.field_150410_aZ), Fluids.GLASS.getFluid(375), 1000);
        RecipeManagers.fabricatorSmeltingManager.addSmelting(new ItemStack((Block)Blocks.field_150354_m), Fluids.GLASS.getFluid(1000), 3000);
        RecipeManagers.carpenterManager.addRecipe(50, Fluids.SEEDOIL.getFluid(250), null, ForestryItem.impregnatedCasing.getItemStack(), "###", "# #", "###", Character.valueOf('#'), "logWood");
        RecipeManagers.carpenterManager.addRecipe(50, Fluids.SEEDOIL.getFluid(500), null, ForestryBlock.core.getItemStack(1, 1), "#  ", "###", "# #", Character.valueOf('#'), "plankWood");
        RecipeManagers.carpenterManager.addRecipe(10, Fluids.SEEDOIL.getFluid(100), null, ForestryItem.stickImpregnated.getItemStack(2), "#", "#", Character.valueOf('#'), "logWood");
        RecipeManagers.carpenterManager.addRecipe(5, Fluids.WATER.getFluid(250), null, ForestryItem.woodPulp.getItemStack(4), "#", Character.valueOf('#'), "logWood");
        RecipeManagers.carpenterManager.addRecipe(5, Fluids.WATER.getFluid(250), null, new ItemStack(Items.field_151121_aF, 1), "#", "#", Character.valueOf('#'), "pulpWood");
        RecipeManagers.carpenterManager.addRecipe(5, Fluids.WATER.getFluid(1000), null, ForestryBlock.soil.getItemStack(9), new Object[]{"###", "#X#", "###", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), ForestryItem.mulch});
        RecipeManagers.carpenterManager.addRecipe(5, Fluids.WATER.getFluid(1000), null, ForestryBlock.soil.getItemStack(8, 1), new Object[]{"#X#", "XYX", "#X#", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), "sand", Character.valueOf('Y'), ForestryItem.mulch});
        RecipeManagers.carpenterManager.addRecipe(75, Fluids.WATER.getFluid(5000), null, ForestryItem.hardenedCasing.getItemStack(), new Object[]{"# #", " Y ", "# #", Character.valueOf('#'), "gemDiamond", Character.valueOf('Y'), ForestryItem.sturdyCasing});
        RecipeManagers.carpenterManager.addRecipe(20, Fluids.WATER.getFluid(1000), null, ForestryItem.circuitboards.getItemStack(1, 0), "R R", "R#R", "R R", Character.valueOf('#'), "ingotTin", Character.valueOf('R'), "dustRedstone");
        RecipeManagers.carpenterManager.addRecipe(40, Fluids.WATER.getFluid(1000), null, ForestryItem.circuitboards.getItemStack(1, 1), "R#R", "R#R", "R#R", Character.valueOf('#'), "ingotBronze", Character.valueOf('R'), "dustRedstone");
        RecipeManagers.carpenterManager.addRecipe(80, Fluids.WATER.getFluid(1000), null, ForestryItem.circuitboards.getItemStack(1, 2), "R#R", "R#R", "R#R", Character.valueOf('#'), "ingotIron", Character.valueOf('R'), "dustRedstone");
        RecipeManagers.carpenterManager.addRecipe(80, Fluids.WATER.getFluid(1000), null, ForestryItem.circuitboards.getItemStack(1, 3), "R#R", "R#R", "R#R", Character.valueOf('#'), "ingotGold", Character.valueOf('R'), "dustRedstone");
        RecipeManagers.carpenterManager.addRecipe(40, Fluids.WATER.getFluid(1000), null, ForestryItem.solderingIron.getItemStack(), " # ", "# #", "  B", Character.valueOf('#'), "ingotIron", Character.valueOf('B'), "ingotBronze");
        if (PluginManager.Module.APICULTURE.isEnabled()) {
            RecipeManagers.carpenterManager.addRecipe(5, Fluids.WATER.getFluid(1000), null, ForestryItem.iodineCharge.getItemStack(), new Object[]{"Z#Z", "#Y#", "X#X", Character.valueOf('#'), ForestryItem.pollenCluster, Character.valueOf('X'), Items.field_151016_H, Character.valueOf('Y'), ForestryItem.canEmpty, Character.valueOf('Z'), ForestryItem.honeyDrop});
            RecipeManagers.carpenterManager.addRecipe(5, Fluids.WATER.getFluid(1000), null, ForestryItem.craftingMaterial.getItemStack(1, 4), new Object[]{"Z#Z", "#Y#", "X#X", Character.valueOf('#'), ForestryItem.royalJelly, Character.valueOf('X'), Items.field_151016_H, Character.valueOf('Y'), ForestryItem.canEmpty, Character.valueOf('Z'), ForestryItem.honeydew});
        }
        RecipeManagers.carpenterManager.addRecipe(100, null, new ItemStack(Items.field_151079_bi, 1), " # ", "###", " # ", Character.valueOf('#'), ForestryItem.craftingMaterial.getItemStack(1, 1));
        RecipeManagers.carpenterManager.addRecipe(10, Fluids.WATER.getFluid(500), null, ForestryItem.craftingMaterial.getItemStack(1, 3), "###", "###", "###", Character.valueOf('#'), ForestryItem.craftingMaterial.getItemStack(1, 2));
        RecipeManagers.carpenterManager.addRecipe(5, Fluids.WATER.getFluid(1000), null, ForestryItem.carton.getItemStack(2), " # ", "# #", " # ", Character.valueOf('#'), "pulpWood");
        RecipeManagers.carpenterManager.addRecipe(20, (FluidStack)null, ForestryItem.carton.getItemStack(), ForestryItem.kitPickaxe.getItemStack(), "###", " X ", " X ", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), "stickWood");
        RecipeManagers.carpenterManager.addRecipe(20, (FluidStack)null, ForestryItem.carton.getItemStack(), ForestryItem.kitShovel.getItemStack(), " # ", " X ", " X ", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), "stickWood");
        RecipeManagers.carpenterManager.addRecipe(null, ForestryItem.ingotBronze.getItemStack(2, ForestryItem.ingotBronze.item().func_77612_l()), new Object[]{"#", Character.valueOf('#'), ForestryItem.brokenBronzePickaxe});
        RecipeManagers.carpenterManager.addRecipe(null, ForestryItem.ingotBronze.getItemStack(), new Object[]{"#", Character.valueOf('#'), ForestryItem.brokenBronzeShovel});
        if (PluginManager.Module.STORAGE.isEnabled()) {
            PluginStorage.createCrateRecipes();
        }
        ICircuitLayout layout = ChipsetManager.circuitRegistry.getLayout("forestry.machine.upgrade");
        ChipsetManager.solderManager.addRecipe(layout, ForestryItem.tubes.getItemStack(1, 9), Circuit.machineSpeedUpgrade1);
        ChipsetManager.solderManager.addRecipe(layout, ForestryItem.tubes.getItemStack(1, 7), Circuit.machineSpeedUpgrade2);
        ChipsetManager.solderManager.addRecipe(layout, ForestryItem.tubes.getItemStack(1, 4), Circuit.machineEfficiencyUpgrade1);
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return new GuiHandlerFactory();
    }
}

