/*
 * Decompiled with CFR 0.152.
 */
package forestry.food.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.food.BeverageManager;
import forestry.api.food.IBeverageEffect;
import forestry.core.config.Config;
import forestry.core.items.ItemForestryFood;
import forestry.core.render.TextureManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemBeverage
extends ItemForestryFood {
    public final BeverageInfo[] beverages;

    public ItemBeverage(BeverageInfo ... beverages) {
        super(1, 0.2f);
        this.func_77625_d(1);
        this.beverages = beverages;
    }

    public boolean func_77651_p() {
        return true;
    }

    public ItemStack func_77654_b(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        List<IBeverageEffect> effects = BeverageInfo.loadEffects(itemstack);
        --itemstack.field_77994_a;
        entityplayer.func_71024_bL().func_151686_a((ItemFood)this, itemstack);
        world.func_72956_a((Entity)entityplayer, "random.burp", 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        if (world.field_72995_K) {
            return itemstack;
        }
        for (IBeverageEffect effect : effects) {
            effect.doEffect(world, entityplayer);
        }
        return itemstack;
    }

    public int func_150905_g(ItemStack itemstack) {
        int meta = itemstack.func_77960_j();
        BeverageInfo beverage = this.beverages[meta];
        return beverage.heal;
    }

    public float func_150906_h(ItemStack itemstack) {
        int meta = itemstack.func_77960_j();
        BeverageInfo beverage = this.beverages[meta];
        return beverage.saturation;
    }

    public int func_77626_a(ItemStack itemstack) {
        return 32;
    }

    @Override
    public EnumAction func_77661_b(ItemStack itemstack) {
        return EnumAction.drink;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        int meta = itemstack.func_77960_j();
        BeverageInfo beverage = this.beverages[meta];
        if (entityplayer.func_71043_e(beverage.isAlwaysEdible)) {
            entityplayer.func_71008_a(itemstack, this.func_77626_a(itemstack));
        }
        return itemstack;
    }

    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        for (int i = 0; i < this.beverages.length; ++i) {
            if (!Config.isDebug && this.beverages[i].isSecret) continue;
            itemList.add(new ItemStack((Item)this, 1, i));
        }
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean flag) {
        List<IBeverageEffect> effects = BeverageInfo.loadEffects(itemstack);
        for (IBeverageEffect effect : effects) {
            if (effect.getDescription() == null) continue;
            list.add(effect.getDescription());
        }
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "." + this.beverages[stack.func_77960_j()].name;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        for (BeverageInfo info : this.beverages) {
            info.registerIcons(register);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int i, int j) {
        if (j > 0 && this.beverages[i].secondaryColor != 0) {
            return this.beverages[i].iconBottle;
        }
        return this.beverages[i].iconContents;
    }

    public boolean func_77623_v() {
        return true;
    }

    public int func_82790_a(ItemStack itemstack, int j) {
        if (j == 0 || this.beverages[itemstack.func_77960_j()].secondaryColor == 0) {
            return this.beverages[itemstack.func_77960_j()].primaryColor;
        }
        return this.beverages[itemstack.func_77960_j()].secondaryColor;
    }

    public static class BeverageInfo {
        public final String name;
        private final String iconType;
        public final int primaryColor;
        public final int secondaryColor;
        @SideOnly(value=Side.CLIENT)
        public IIcon iconBottle;
        @SideOnly(value=Side.CLIENT)
        public IIcon iconContents;
        public final int heal;
        public final float saturation;
        public final boolean isAlwaysEdible;
        public boolean isSecret = false;

        public BeverageInfo(String name, String iconType, int primaryColor, int secondaryColor, int heal, float saturation, boolean isAlwaysEdible) {
            this.name = name;
            this.iconType = iconType;
            this.primaryColor = primaryColor;
            this.secondaryColor = secondaryColor;
            this.heal = heal;
            this.saturation = saturation;
            this.isAlwaysEdible = isAlwaysEdible;
        }

        @SideOnly(value=Side.CLIENT)
        public void registerIcons(IIconRegister register) {
            this.iconBottle = TextureManager.registerTex(register, "liquids/" + this.iconType + ".bottle");
            this.iconContents = TextureManager.registerTex(register, "liquids/" + this.iconType + ".contents");
        }

        public static List<IBeverageEffect> loadEffects(ItemStack stack) {
            List<IBeverageEffect> effectsList = new ArrayList<IBeverageEffect>();
            NBTTagCompound nbttagcompound = stack.func_77978_p();
            if (nbttagcompound == null) {
                return effectsList;
            }
            if (nbttagcompound.func_74764_b("E")) {
                int effectLength = nbttagcompound.func_74762_e("L");
                NBTTagList nbttaglist = nbttagcompound.func_150295_c("E", 10);
                IBeverageEffect[] effects = new IBeverageEffect[effectLength];
                for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                    NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
                    byte byte0 = nbttagcompound1.func_74771_c("S");
                    if (byte0 < 0 || byte0 >= effects.length) continue;
                    effects[byte0] = BeverageManager.effectList[nbttagcompound1.func_74762_e("ID")];
                }
                effectsList = Arrays.asList(effects);
            }
            return effectsList;
        }

        public static void saveEffects(ItemStack stack, List<IBeverageEffect> effects) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            NBTTagList nbttaglist = new NBTTagList();
            nbttagcompound.func_74768_a("L", effects.size());
            for (int i = 0; i < effects.size(); ++i) {
                IBeverageEffect effect = effects.get(i);
                if (effect == null) continue;
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.func_74774_a("S", (byte)i);
                nbttagcompound1.func_74768_a("ID", effect.getId());
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            nbttagcompound.func_74782_a("E", (NBTBase)nbttaglist);
            stack.func_77982_d(nbttagcompound);
        }
    }
}

