/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.farming.FarmDirection;
import forestry.api.farming.Farmables;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.vect.Vect;
import forestry.farming.logic.FarmLogic;
import java.util.Collection;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class FarmLogicSucculent
extends FarmLogic {
    private final IFarmable[] germlings;

    public FarmLogicSucculent(IFarmHousing housing) {
        super(housing);
        Collection<IFarmable> farmables = Farmables.farmables.get("farmSucculentes");
        this.germlings = farmables.toArray(new IFarmable[farmables.size()]);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return Items.field_151100_aR.func_77617_a(2);
    }

    @Override
    public String getName() {
        if (this.isManual) {
            return "Manual Succulent Farm";
        }
        return "Managed Succulent Farm";
    }

    @Override
    public int getFertilizerConsumption() {
        return 10;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return 1;
    }

    @Override
    public boolean isAcceptedResource(ItemStack itemstack) {
        if (this.isManual) {
            return false;
        }
        return ItemStackUtil.equals((Block)Blocks.field_150354_m, itemstack);
    }

    @Override
    public boolean isAcceptedGermling(ItemStack itemstack) {
        if (this.isManual) {
            return false;
        }
        return ItemStackUtil.equals(Blocks.field_150434_aF, itemstack);
    }

    @Override
    public Collection<ItemStack> collect() {
        return null;
    }

    @Override
    public boolean cultivate(int x, int y, int z, FarmDirection direction, int extent) {
        return false;
    }

    @Override
    public Collection<ICrop> harvest(int x, int y, int z, FarmDirection direction, int extent) {
        World world = this.getWorld();
        Stack<ICrop> crops = new Stack<ICrop>();
        for (int i = 0; i < extent; ++i) {
            Vect position = this.translateWithOffset(x, y + 1, z, direction, i);
            for (IFarmable seed : this.germlings) {
                ICrop crop = seed.getCropAt(world, position.x, position.y, position.z);
                if (crop == null) continue;
                crops.push(crop);
            }
        }
        return crops;
    }
}

