/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import forestry.api.recipes.IStillRecipe;
import forestry.core.config.Config;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.fluids.tanks.StandardTank;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.GuiId;
import forestry.core.render.TankRenderInfo;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TilePowered;
import forestry.factory.recipes.StillRecipeManager;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileStill
extends TilePowered
implements ISidedInventory,
ILiquidTankTile,
IFluidHandler {
    private static final int ENERGY_PER_RECIPE_TIME = 200;
    public static final short SLOT_PRODUCT = 0;
    public static final short SLOT_RESOURCE = 1;
    public static final short SLOT_CAN = 2;
    private final FilteredTank resourceTank;
    private final FilteredTank productTank;
    private final TankManager tankManager;
    private IStillRecipe currentRecipe;
    private FluidStack bufferedLiquid;

    public TileStill() {
        super(1100, 8000, 200);
        this.setInternalInventory(new StillInventoryAdapter(this));
        this.setHints(Config.hints.get("still"));
        this.resourceTank = new FilteredTank(10000, StillRecipeManager.recipeFluidInputs);
        this.resourceTank.tankMode = StandardTank.TankMode.INPUT;
        this.productTank = new FilteredTank(10000, StillRecipeManager.recipeFluidOutputs);
        this.productTank.tankMode = StandardTank.TankMode.OUTPUT;
        this.tankManager = new TankManager(this, this.resourceTank, this.productTank);
    }

    @Override
    public void openGui(EntityPlayer player) {
        player.openGui(ForestryAPI.instance, GuiId.StillGUI.ordinal(), player.field_70170_p, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        this.tankManager.writeToNBT(nbttagcompound);
        if (this.bufferedLiquid != null) {
            NBTTagCompound buffer = new NBTTagCompound();
            this.bufferedLiquid.writeToNBT(buffer);
            nbttagcompound.func_74782_a("Buffer", (NBTBase)buffer);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.tankManager.readFromNBT(nbttagcompound);
        if (nbttagcompound.func_74764_b("Buffer")) {
            NBTTagCompound buffer = nbttagcompound.func_74775_l("Buffer");
            this.bufferedLiquid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)buffer);
        }
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.tankManager.writeData(data);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readData(data);
    }

    @Override
    public void updateServerSide() {
        super.updateServerSide();
        if (this.updateOnInterval(20)) {
            FluidHelper.drainContainers(this.tankManager, (IInventory)this, 2);
            FluidStack fluidStack = this.productTank.getFluid();
            if (fluidStack != null) {
                FluidHelper.fillContainers(this.tankManager, (IInventory)this, 1, 0, fluidStack.getFluid());
            }
        }
    }

    @Override
    public boolean workCycle() {
        int cycles = this.currentRecipe.getCyclesPerUnit();
        FluidStack output = this.currentRecipe.getOutput();
        FluidStack product = new FluidStack(output, output.amount * cycles);
        this.productTank.fill(product, true);
        this.bufferedLiquid = null;
        return true;
    }

    private void checkRecipe() {
        FluidStack recipeLiquid;
        FluidStack fluidStack = recipeLiquid = this.bufferedLiquid != null ? this.bufferedLiquid : this.resourceTank.getFluid();
        if (!StillRecipeManager.matches(this.currentRecipe, recipeLiquid)) {
            this.currentRecipe = StillRecipeManager.findMatchingRecipe(recipeLiquid);
            int recipeTime = this.currentRecipe == null ? 0 : this.currentRecipe.getCyclesPerUnit();
            this.setEnergyPerWorkCycle(200 * recipeTime);
            this.setTicksPerWorkCycle(recipeTime);
        }
    }

    @Override
    public boolean hasWork() {
        this.checkRecipe();
        boolean hasRecipe = this.currentRecipe != null;
        boolean hasTankSpace = true;
        boolean hasFluidResource = true;
        if (hasRecipe) {
            hasTankSpace = this.productTank.canFill(this.currentRecipe.getOutput());
            if (this.bufferedLiquid == null) {
                int cycles = this.currentRecipe.getCyclesPerUnit();
                FluidStack input = this.currentRecipe.getInput();
                int drainAmount = cycles * input.amount;
                hasFluidResource = this.resourceTank.canDrain(drainAmount);
                if (hasFluidResource) {
                    this.bufferedLiquid = new FluidStack(input, drainAmount);
                    this.resourceTank.drain(drainAmount, true);
                }
            }
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        errorLogic.setCondition(!hasRecipe, EnumErrorCode.NORECIPE);
        errorLogic.setCondition(!hasTankSpace, EnumErrorCode.NOSPACETANK);
        errorLogic.setCondition(!hasFluidResource, EnumErrorCode.NORESOURCE);
        return hasRecipe && hasFluidResource && hasTankSpace;
    }

    @Override
    public TankRenderInfo getResourceTankInfo() {
        return new TankRenderInfo((IFluidTank)this.resourceTank);
    }

    @Override
    public TankRenderInfo getProductTankInfo() {
        return new TankRenderInfo((IFluidTank)this.productTank);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tankManager.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tankManager.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int quantityMax, boolean doEmpty) {
        return this.tankManager.drain(from, quantityMax, doEmpty);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canDrain(from, fluid);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.tankManager.getTankInfo(from);
    }

    private static class StillInventoryAdapter
    extends TileInventoryAdapter<TileStill> {
        public StillInventoryAdapter(TileStill still) {
            super(still, 3, "Items");
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (slotIndex == 1) {
                return FluidHelper.isEmptyContainer(itemStack);
            }
            if (slotIndex == 2) {
                Fluid fluid = FluidHelper.getFluidInContainer(itemStack);
                return ((TileStill)this.tile).resourceTank.accepts(fluid);
            }
            return false;
        }

        @Override
        public boolean func_102008_b(int slotIndex, ItemStack itemstack, int side) {
            return slotIndex == 0;
        }
    }
}

