/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.core.ForestryAPI;
import forestry.api.recipes.IFabricatorRecipe;
import forestry.api.recipes.IFabricatorSmeltingRecipe;
import forestry.core.fluids.Fluids;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.fluids.tanks.StandardTank;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.items.ICraftingPlan;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.GuiId;
import forestry.core.recipes.RecipeUtil;
import forestry.core.tiles.ICrafter;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TilePowered;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.SlotUtil;
import forestry.factory.recipes.FabricatorRecipeManager;
import forestry.factory.recipes.FabricatorSmeltingRecipeManager;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileFabricator
extends TilePowered
implements ICrafter,
ILiquidTankTile,
IFluidHandler,
ISidedInventory {
    private static final int MAX_HEAT = 5000;
    public static final short SLOT_METAL = 0;
    public static final short SLOT_PLAN = 1;
    public static final short SLOT_RESULT = 2;
    public static final short SLOT_CRAFTING_LEGACY_1 = 3;
    public static final short SLOT_CRAFTING_LEGACY_COUNT = 9;
    public static final short SLOT_INVENTORY_1 = 12;
    public static final short SLOT_INVENTORY_COUNT = 18;
    public static final short SLOT_COUNT = 30;
    public static final short SLOT_CRAFTING_1 = 0;
    public static final short SLOT_CRAFTING_COUNT = 9;
    private final TileInventoryAdapter craftingInventory = new TileInventoryAdapter<TileFabricator>(this, 9, "CraftItems");
    private final TankManager tankManager;
    private final FilteredTank moltenTank;
    private int heat = 0;
    private int meltingPoint = 0;

    public TileFabricator() {
        super(1100, 3300, 200);
        this.setInternalInventory(new FabricatorInventoryAdapter(this));
        this.moltenTank = new FilteredTank(2000, Fluids.GLASS.getFluid());
        this.moltenTank.tankMode = StandardTank.TankMode.INTERNAL;
        this.tankManager = new TankManager(this, this.moltenTank);
    }

    @Override
    public void openGui(EntityPlayer player) {
        player.openGui(ForestryAPI.instance, GuiId.FabricatorGUI.ordinal(), player.field_70170_p, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("Heat", this.heat);
        this.tankManager.writeToNBT(nbttagcompound);
        this.craftingInventory.writeToNBT(nbttagcompound);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.heat = nbttagcompound.func_74762_e("Heat");
        this.tankManager.readFromNBT(nbttagcompound);
        this.craftingInventory.readFromNBT(nbttagcompound);
        IInventoryAdapter inventory = this.getInternalInventory();
        for (int slot = 3; slot < 12; ++slot) {
            ItemStack stack = inventory.func_70301_a(slot);
            if (stack == null) continue;
            inventory.func_70299_a(slot, null);
            int newSlot = slot - 3;
            this.craftingInventory.func_70299_a(newSlot, stack);
        }
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.tankManager.writeData(data);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readData(data);
    }

    @Override
    public void updateServerSide() {
        super.updateServerSide();
        if (!this.moltenTank.isFull()) {
            this.trySmelting();
        }
        if (!this.moltenTank.isEmpty() && this.heat < this.getMeltingPoint() - 100) {
            this.moltenTank.drain(5, true);
        }
        this.dissipateHeat();
    }

    private void trySmelting() {
        IInventoryAdapter inventory = this.getInternalInventory();
        ItemStack smeltResource = inventory.func_70301_a(0);
        if (smeltResource == null) {
            return;
        }
        IFabricatorSmeltingRecipe smelt = FabricatorSmeltingRecipeManager.findMatchingSmelting(smeltResource);
        if (smelt == null || smelt.getMeltingPoint() > this.heat) {
            return;
        }
        FluidStack smeltFluid = smelt.getProduct();
        if (this.moltenTank.canFill(smeltFluid)) {
            this.func_70298_a(0, 1);
            this.moltenTank.fill(smeltFluid, true);
            this.meltingPoint = smelt.getMeltingPoint();
        }
    }

    @Override
    public boolean workCycle() {
        this.craftResult(null);
        return this.addHeat(100);
    }

    private boolean addHeat(int addition) {
        if (this.heat >= 5000) {
            return false;
        }
        this.heat += addition;
        if (this.heat > 5000) {
            this.heat = 5000;
        }
        return true;
    }

    private void dissipateHeat() {
        if (this.heat > 2500) {
            this.heat -= 2;
        } else if (this.heat > 0) {
            --this.heat;
        }
    }

    private IFabricatorRecipe getRecipe() {
        IInventoryAdapter inventory = this.getInternalInventory();
        ItemStack plan = inventory.func_70301_a(1);
        ItemStack[] crafting = InventoryUtil.getStacks((IInventory)this.craftingInventory, 0, 9);
        return FabricatorRecipeManager.findMatchingRecipe(plan, this.moltenTank.getFluid(), crafting);
    }

    @Override
    public boolean canTakeStack(int slotIndex) {
        return true;
    }

    @Override
    public ItemStack getResult() {
        IFabricatorRecipe myRecipe = this.getRecipe();
        if (myRecipe == null) {
            return null;
        }
        return RecipeUtil.getCraftingResult(myRecipe.getRecipeOutput(), myRecipe.preservesNbt(), (IInventory)this.craftingInventory);
    }

    @Override
    public ItemStack takenFromSlot(int slotIndex, EntityPlayer player) {
        if (slotIndex != 2) {
            return null;
        }
        return this.getInternalInventory().func_70298_a(2, 1);
    }

    private void craftResult(EntityPlayer player) {
        Item planItem;
        IFabricatorRecipe myRecipe = this.getRecipe();
        if (myRecipe == null) {
            return;
        }
        ItemStack result = this.getResult();
        if (result == null) {
            return;
        }
        IInventoryAdapter inventory = this.getInternalInventory();
        if (inventory.func_70301_a(2) != null) {
            return;
        }
        FluidStack liquid = myRecipe.getLiquid();
        ItemStack[] crafting = InventoryUtil.getStacks((IInventory)this.craftingInventory, 0, 9);
        if (!this.removeFromInventory(crafting, player, false)) {
            return;
        }
        if (!this.moltenTank.canDrain(liquid)) {
            return;
        }
        this.removeFromInventory(crafting, player, true);
        this.moltenTank.drain(liquid.amount, true);
        if (inventory.func_70301_a(1) != null && (planItem = inventory.func_70301_a(1).func_77973_b()) instanceof ICraftingPlan) {
            inventory.func_70299_a(1, ((ICraftingPlan)planItem).planUsed(inventory.func_70301_a(1), result));
        }
        inventory.func_70299_a(2, result);
    }

    private boolean removeFromInventory(ItemStack[] set, EntityPlayer player, boolean doRemove) {
        InventoryMapper inventory = new InventoryMapper((IInventory)this, 12, 18);
        return InventoryUtil.removeSets(inventory, 1, set, player, true, true, false, doRemove);
    }

    @Override
    public boolean hasWork() {
        IInventoryAdapter inventory = this.getInternalInventory();
        ItemStack itemToMelt = inventory.func_70301_a(0);
        IFabricatorSmeltingRecipe smelting = FabricatorSmeltingRecipeManager.findMatchingSmelting(itemToMelt);
        if (smelting != null && this.moltenTank.fill(smelting.getProduct(), false) > 0) {
            return true;
        }
        ItemStack plan = inventory.func_70301_a(1);
        ItemStack[] resources = InventoryUtil.getStacks((IInventory)this.craftingInventory, 0, 9);
        return FabricatorRecipeManager.findMatchingRecipe(plan, this.moltenTank.getFluid(), resources) != null;
    }

    public int getHeatScaled(int i) {
        return this.heat * i / 5000;
    }

    private int getMeltingPoint() {
        if (this.func_70301_a(0) != null) {
            IFabricatorSmeltingRecipe smelt = FabricatorSmeltingRecipeManager.findMatchingSmelting(this.func_70301_a(0));
            if (smelt != null) {
                return smelt.getMeltingPoint();
            }
        } else if (this.moltenTank.getFluidAmount() > 0) {
            return this.meltingPoint;
        }
        return 0;
    }

    public int getMeltingPointScaled(int i) {
        int meltingPoint = this.getMeltingPoint();
        if (meltingPoint <= 0) {
            return 0;
        }
        return meltingPoint * i / 5000;
    }

    public void getGUINetworkData(int i, int j) {
        if (i == 0) {
            this.heat = j;
        } else if (i == 1) {
            this.meltingPoint = j;
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        iCrafting.func_71112_a(container, 0, this.heat);
        iCrafting.func_71112_a(container, 1, this.getMeltingPoint());
    }

    public InventoryAdapter getCraftingInventory() {
        return this.craftingInventory;
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tankManager.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tankManager.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tankManager.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.tankManager.getTankInfo(from);
    }

    private static class FabricatorInventoryAdapter
    extends TileInventoryAdapter<TileFabricator> {
        public FabricatorInventoryAdapter(TileFabricator fabricator) {
            super(fabricator, 30, "Items");
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (slotIndex == 0) {
                return FabricatorSmeltingRecipeManager.findMatchingSmelting(itemStack) != null;
            }
            if (slotIndex == 1) {
                return FabricatorRecipeManager.isPlan(itemStack);
            }
            if (SlotUtil.isSlotInRange(slotIndex, 12, 18)) {
                if (FabricatorRecipeManager.isPlan(itemStack)) {
                    return false;
                }
                if (FabricatorSmeltingRecipeManager.findMatchingSmelting(itemStack) != null) {
                    return false;
                }
            }
            return SlotUtil.isSlotInRange(slotIndex, 12, 18);
        }

        @Override
        public boolean func_102008_b(int slotIndex, ItemStack stack, int side) {
            return slotIndex == 2;
        }
    }
}

