/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.craftguide;

import forestry.api.fuels.FuelManager;
import forestry.api.recipes.IFermenterRecipe;
import forestry.api.recipes.RecipeManagers;
import forestry.core.config.ForestryBlock;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import uristqwerty.CraftGuide.api.ItemSlot;
import uristqwerty.CraftGuide.api.LiquidSlot;
import uristqwerty.CraftGuide.api.RecipeGenerator;
import uristqwerty.CraftGuide.api.RecipeProvider;
import uristqwerty.CraftGuide.api.RecipeTemplate;
import uristqwerty.CraftGuide.api.Slot;
import uristqwerty.CraftGuide.api.SlotType;

public class CraftGuideFermenter
implements RecipeProvider {
    private final Slot[] slots = new Slot[5];

    public CraftGuideFermenter() {
        this.slots[0] = new ItemSlot(3, 12, 16, 16, true);
        this.slots[1] = new ItemSlot(3, 30, 16, 16, true);
        this.slots[2] = new LiquidSlot(21, 21);
        this.slots[3] = new LiquidSlot(59, 21).setSlotType(SlotType.OUTPUT_SLOT);
        this.slots[4] = new ItemSlot(40, 21, 16, 16).setSlotType(SlotType.MACHINE_SLOT);
    }

    public void generateRecipes(RecipeGenerator generator) {
        if (ForestryBlock.factoryTESR.block() == null) {
            return;
        }
        ItemStack machine = ForestryBlock.factoryTESR.getItemStack(1, 3);
        RecipeTemplate template = generator.createRecipeTemplate(this.slots, machine);
        ArrayList<ItemStack> fuels = new ArrayList<ItemStack>(FuelManager.fermenterFuel.keySet());
        for (IFermenterRecipe recipe : RecipeManagers.fermenterManager.recipes()) {
            Object[] array = new Object[5];
            array[0] = recipe.getResource();
            array[1] = fuels;
            array[2] = recipe.getFluidResource();
            int amount = Math.round((float)recipe.getFermentationValue() * recipe.getModifier());
            FluidStack output = new FluidStack(recipe.getOutput(), amount);
            array[3] = output;
            array[4] = machine;
            generator.addRecipe(template, array);
        }
    }
}

