/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.worldgen;

import forestry.core.config.ForestryBlock;
import forestry.core.tiles.TileForestry;
import forestry.core.worldgen.IBlockType;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockTypeTileForestry
implements IBlockType {
    private final Block block;
    private final int meta;
    private ForgeDirection direction;

    public BlockTypeTileForestry(ForestryBlock forestryBlock, int meta) {
        this.block = forestryBlock.block();
        this.meta = meta;
    }

    @Override
    public void setDirection(ForgeDirection facing) {
        this.direction = facing;
    }

    @Override
    public void setBlock(World world, int x, int y, int z) {
        boolean placed = world.func_147465_d(x, y, z, this.block, this.meta, 3);
        if (!placed) {
            return;
        }
        Block worldBlock = world.func_147439_a(x, y, z);
        if (!Block.func_149680_a((Block)this.block, (Block)worldBlock)) {
            return;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof TileForestry)) {
            world.func_147468_f(x, y, z);
            return;
        }
        TileForestry tileForestry = (TileForestry)tile;
        tileForestry.setOrientation(this.direction);
    }

    @Override
    public int getMeta() {
        return this.meta;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public ItemStack getItemStack() {
        return new ItemStack(this.block, 1, this.meta);
    }
}

