/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import buildcraft.api.tiles.IHasWork;
import cpw.mods.fml.common.Optional;
import forestry.api.core.IErrorLogic;
import forestry.core.circuits.ISpeedUpgradable;
import forestry.core.errors.EnumErrorCode;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.render.TankRenderInfo;
import forestry.core.tiles.IPowerHandler;
import forestry.core.tiles.IRenderableTile;
import forestry.core.tiles.TileBase;
import forestry.energy.EnergyManager;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.Interface(iface="buildcraft.api.tiles.IHasWork", modid="BuildCraftAPI|tiles")
public abstract class TilePowered
extends TileBase
implements IRenderableTile,
IPowerHandler,
IHasWork,
ISpeedUpgradable {
    private static final int WORK_TICK_INTERVAL = 5;
    private final EnergyManager energyManager;
    private int workCounter;
    private int ticksPerWorkCycle;
    private int energyPerWorkCycle;
    protected float speedMultiplier = 1.0f;
    protected float powerMultiplier = 1.0f;
    private int noPowerTime = 0;

    protected TilePowered(int maxTransfer, int capacity, int energyPerWorkCycle) {
        this.energyManager = new EnergyManager(maxTransfer, capacity);
        this.energyManager.setReceiveOnly();
        this.setEnergyPerWorkCycle(energyPerWorkCycle);
        this.ticksPerWorkCycle = 4;
    }

    public int getWorkCounter() {
        return this.workCounter;
    }

    public void setTicksPerWorkCycle(int ticksPerWorkCycle) {
        this.ticksPerWorkCycle = ticksPerWorkCycle;
        this.workCounter = 0;
    }

    public int getTicksPerWorkCycle() {
        if (this.field_145850_b.field_72995_K) {
            return this.ticksPerWorkCycle;
        }
        return Math.round((float)this.ticksPerWorkCycle / this.speedMultiplier);
    }

    public void setEnergyPerWorkCycle(int energyPerWorkCycle) {
        this.energyPerWorkCycle = EnergyManager.scaleForDifficulty(energyPerWorkCycle);
    }

    public int getEnergyPerWorkCycle() {
        return Math.round((float)this.energyPerWorkCycle * this.powerMultiplier);
    }

    public boolean hasResourcesMin(float percentage) {
        return false;
    }

    public boolean hasFuelMin(float percentage) {
        return false;
    }

    public abstract boolean hasWork();

    @Override
    protected void updateServerSide() {
        super.updateServerSide();
        if (!this.updateOnInterval(5)) {
            return;
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        boolean disabled = this.isRedstoneActivated();
        errorLogic.setCondition(disabled, EnumErrorCode.DISABLED);
        if (disabled) {
            return;
        }
        if (!this.hasWork()) {
            return;
        }
        int ticksPerWorkCycle = this.getTicksPerWorkCycle();
        if (this.workCounter < ticksPerWorkCycle) {
            int energyPerWorkCycle = this.getEnergyPerWorkCycle();
            boolean consumedEnergy = this.energyManager.consumeEnergyToDoWork(ticksPerWorkCycle, energyPerWorkCycle);
            if (consumedEnergy) {
                errorLogic.setCondition(false, EnumErrorCode.NOPOWER);
                ++this.workCounter;
                this.noPowerTime = 0;
            } else {
                ++this.noPowerTime;
                if (this.noPowerTime > 4) {
                    errorLogic.setCondition(true, EnumErrorCode.NOPOWER);
                }
            }
        }
        if (this.workCounter >= ticksPerWorkCycle && this.workCycle()) {
            this.workCounter = 0;
        }
    }

    protected abstract boolean workCycle();

    public int getProgressScaled(int i) {
        int ticksPerWorkCycle = this.getTicksPerWorkCycle();
        if (ticksPerWorkCycle == 0) {
            return 0;
        }
        return this.workCounter * i / ticksPerWorkCycle;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.energyManager.writeToNBT(nbt);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energyManager.readFromNBT(nbt);
    }

    @Override
    public void writeGuiData(DataOutputStreamForestry data) throws IOException {
        super.writeGuiData(data);
        this.energyManager.writeData(data);
        data.writeVarInt(this.workCounter);
        data.writeVarInt(this.getTicksPerWorkCycle());
    }

    @Override
    public void readGuiData(DataInputStreamForestry data) throws IOException {
        super.readGuiData(data);
        this.energyManager.readData(data);
        this.workCounter = data.readVarInt();
        this.ticksPerWorkCycle = data.readVarInt();
    }

    @Override
    public void applySpeedUpgrade(double speedChange, double powerChange) {
        this.speedMultiplier = (float)((double)this.speedMultiplier + speedChange);
        this.powerMultiplier = (float)((double)this.powerMultiplier + powerChange);
        this.workCounter = 0;
    }

    @Override
    public TankRenderInfo getResourceTankInfo() {
        return TankRenderInfo.EMPTY;
    }

    @Override
    public TankRenderInfo getProductTankInfo() {
        return TankRenderInfo.EMPTY;
    }

    @Override
    public EnergyManager getEnergyManager() {
        return this.energyManager;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.energyManager.receiveEnergy(from, maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.energyManager.extractEnergy(from, maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.energyManager.getEnergyStored(from);
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.energyManager.getMaxEnergyStored(from);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.energyManager.canConnectEnergy(from);
    }
}

