/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import forestry.core.items.ItemCrated;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderCrateItem
implements IItemRenderer {
    private static final ResourceLocation BLOCK_TEXTURE = TextureMap.field_110575_b;
    private static final ResourceLocation ITEM_TEXTURE = TextureMap.field_110576_c;
    private static final ResourceLocation GLINT_TEXTURE = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private static final float PIXEL = 0.0625f;
    private final RenderItem renderItem = new RenderItem();

    public boolean handleRenderType(ItemStack stack, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case INVENTORY: 
            case ENTITY: 
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack stack, IItemRenderer.ItemRendererHelper helper) {
        return helper == IItemRenderer.ItemRendererHelper.ENTITY_BOBBING;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack stack, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            this.render(IItemRenderer.ItemRenderType.INVENTORY, stack);
        } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
            if (RenderManager.field_78727_a.field_78733_k.field_74347_j) {
                this.renderAsEntity(stack, (EntityItem)data[1]);
            } else {
                this.renderAsEntityFlat(stack);
            }
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            GL11.glPushMatrix();
            this.renderEquipped(stack);
            ItemStack contained = RenderCrateItem.getContainedFromCrate(stack);
            if (contained != null) {
                float scale = 0.5f;
                GL11.glScalef((float)scale, (float)scale, (float)1.1f);
                GL11.glTranslatef((float)0.625f, (float)0.5f, (float)0.001f);
                if (contained.func_77973_b() instanceof ItemBlock) {
                    this.renderIn3D(contained);
                } else {
                    this.renderEquipped(contained);
                }
            }
            GL11.glPopMatrix();
        }
    }

    private void renderEquipped(ItemStack stack) {
        GL11.glPushMatrix();
        Tessellator tessellator = Tessellator.field_78398_a;
        int meta = stack.func_77960_j();
        for (int pass = 0; pass < stack.func_77973_b().getRenderPasses(meta); ++pass) {
            IIcon icon = stack.func_77973_b().func_77618_c(meta, pass);
            if (icon == null) continue;
            if (this.renderItem.field_77024_a) {
                int color = stack.func_77973_b().func_82790_a(stack, pass);
                float c1 = (float)(color >> 16 & 0xFF) / 255.0f;
                float c2 = (float)(color >> 8 & 0xFF) / 255.0f;
                float c3 = (float)(color & 0xFF) / 255.0f;
                GL11.glColor4f((float)c1, (float)c2, (float)c3, (float)1.0f);
            }
            float uv1 = icon.func_94209_e();
            float uv2 = icon.func_94212_f();
            float uv3 = icon.func_94206_g();
            float uv4 = icon.func_94210_h();
            ItemRenderer.func_78439_a((Tessellator)tessellator, (float)uv2, (float)uv3, (float)uv1, (float)uv4, (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
        }
        GL11.glPopMatrix();
    }

    private void renderAsEntity(ItemStack stack, EntityItem entity) {
        GL11.glPushMatrix();
        int iterations = 1;
        if (stack.field_77994_a > 1) {
            iterations = 2;
        }
        if (stack.field_77994_a > 15) {
            iterations = 3;
        }
        if (stack.field_77994_a > 31) {
            iterations = 4;
        }
        Random rand = new Random(187L);
        float offsetZ = 0.084375f;
        GL11.glRotatef((float)((((float)entity.field_70292_b + 1.0f) / 20.0f + entity.field_70290_d) * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.25f, (float)(-(offsetZ * (float)iterations / 2.0f)));
        for (int count = 0; count < iterations; ++count) {
            if (count > 0) {
                float offsetX = (rand.nextFloat() * 2.0f - 1.0f) * 0.3f / 0.5f;
                float offsetY = (rand.nextFloat() * 2.0f - 1.0f) * 0.3f / 0.5f;
                GL11.glTranslatef((float)offsetX, (float)offsetY, (float)offsetZ);
            } else {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)offsetZ);
            }
            this.renderIn3D(stack);
            ItemStack contained = RenderCrateItem.getContainedFromCrate(stack);
            if (contained == null) continue;
            GL11.glPushMatrix();
            float scale = 0.5f;
            GL11.glScalef((float)scale, (float)scale, (float)1.1f);
            GL11.glTranslatef((float)0.625f, (float)0.5f, (float)0.003f);
            this.renderIn3D(contained);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    private void renderIn3D(ItemStack stack) {
        GL11.glPushMatrix();
        Tessellator tessellator = Tessellator.field_78398_a;
        if (RenderManager.field_78727_a.field_78724_e == null) {
            return;
        }
        int meta = stack.func_77960_j();
        for (int pass = 0; pass < stack.func_77973_b().getRenderPasses(meta); ++pass) {
            IIcon icon = stack.func_77973_b().func_77618_c(meta, pass);
            if (icon == null) continue;
            if (this.renderItem.field_77024_a) {
                int color = stack.func_77973_b().func_82790_a(stack, pass);
                float c1 = (float)(color >> 16 & 0xFF) / 255.0f;
                float c2 = (float)(color >> 8 & 0xFF) / 255.0f;
                float c3 = (float)(color & 0xFF) / 255.0f;
                GL11.glColor4f((float)c1, (float)c2, (float)c3, (float)1.0f);
            }
            float minU = icon.func_94209_e();
            float maxU = icon.func_94212_f();
            float minV = icon.func_94206_g();
            float maxV = icon.func_94210_h();
            if (stack.func_94608_d() == 0) {
                RenderManager.field_78727_a.field_78724_e.func_110577_a(BLOCK_TEXTURE);
            } else {
                RenderManager.field_78727_a.field_78724_e.func_110577_a(ITEM_TEXTURE);
            }
            ItemRenderer.func_78439_a((Tessellator)tessellator, (float)maxU, (float)minV, (float)minU, (float)maxV, (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
            if (!stack.hasEffect(pass)) continue;
            GL11.glDepthFunc((int)514);
            GL11.glDisable((int)2896);
            RenderManager.field_78727_a.field_78724_e.func_110577_a(GLINT_TEXTURE);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)768, (int)1);
            float f13 = 0.76f;
            GL11.glColor4f((float)(0.5f * f13), (float)(0.25f * f13), (float)(0.8f * f13), (float)1.0f);
            GL11.glMatrixMode((int)5890);
            GL11.glPushMatrix();
            float f14 = 0.125f;
            GL11.glScalef((float)f14, (float)f14, (float)f14);
            float f15 = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f * 8.0f;
            GL11.glTranslatef((float)f15, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            ItemRenderer.func_78439_a((Tessellator)tessellator, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)255, (int)255, (float)0.0625f);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glScalef((float)f14, (float)f14, (float)f14);
            f15 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f * 8.0f;
            GL11.glTranslatef((float)(-f15), (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            ItemRenderer.func_78439_a((Tessellator)tessellator, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)255, (int)255, (float)0.0625f);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2896);
            GL11.glDepthFunc((int)515);
        }
        GL11.glPopMatrix();
    }

    private void renderAsEntityFlat(ItemStack stack) {
        GL11.glPushMatrix();
        int iterations = 1;
        if (stack.field_77994_a > 1) {
            iterations = 2;
        }
        if (stack.field_77994_a > 15) {
            iterations = 3;
        }
        if (stack.field_77994_a > 31) {
            iterations = 4;
        }
        Random rand = new Random(187L);
        for (int ii = 0; ii < iterations; ++ii) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(180.0f - RenderManager.field_78727_a.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            if (ii > 0) {
                float var12 = (rand.nextFloat() * 2.0f - 1.0f) * 0.3f;
                float var13 = (rand.nextFloat() * 2.0f - 1.0f) * 0.3f;
                float var14 = (rand.nextFloat() * 2.0f - 1.0f) * 0.3f;
                GL11.glTranslatef((float)var12, (float)var13, (float)var14);
            }
            GL11.glTranslatef((float)0.5f, (float)0.8f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glScalef((float)0.0625f, (float)0.0625f, (float)1.0f);
            this.render(IItemRenderer.ItemRenderType.ENTITY, stack);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    private void render(IItemRenderer.ItemRenderType type, ItemStack stack) {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        IIcon crateTexture = stack.func_77954_c();
        this.renderItem.func_94149_a(0, 0, crateTexture, 16, 16);
        ItemStack contained = RenderCrateItem.getContainedFromCrate(stack);
        if (contained != null) {
            int meta = contained.func_77960_j();
            float scale = 0.5f;
            GL11.glScalef((float)scale, (float)scale, (float)1.0f);
            GL11.glTranslatef((float)6.0f, (float)8.0f, (float)0.0f);
            if (type == IItemRenderer.ItemRenderType.ENTITY) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.1f);
            }
            if (contained.func_77973_b() instanceof ItemBlock) {
                GL11.glScalef((float)16.0f, (float)16.0f, (float)1.0f);
                GL11.glTranslatef((float)1.0f, (float)1.0f, (float)0.1f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                this.renderIn3D(contained);
            } else {
                for (int pass = 0; pass < contained.func_77973_b().getRenderPasses(meta); ++pass) {
                    IIcon containedTexture = contained.func_77973_b().func_77618_c(meta, pass);
                    if (containedTexture == null) continue;
                    if (this.renderItem.field_77024_a) {
                        int color = contained.func_77973_b().func_82790_a(contained, pass);
                        float c1 = (float)(color >> 16 & 0xFF) / 255.0f;
                        float c2 = (float)(color >> 8 & 0xFF) / 255.0f;
                        float c3 = (float)(color & 0xFF) / 255.0f;
                        GL11.glColor4f((float)c1, (float)c2, (float)c3, (float)1.0f);
                    }
                    this.renderItem.func_94149_a(0, 0, containedTexture, 16, 16);
                }
            }
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private static ItemStack getContainedFromCrate(ItemStack crate) {
        if (crate == null) {
            return null;
        }
        Item crateItem = crate.func_77973_b();
        if (crateItem instanceof ItemCrated) {
            return ((ItemCrated)crateItem).getContained();
        }
        return null;
    }
}

