/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.recipes.nei;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import forestry.core.recipes.ShapedRecipeCustom;
import forestry.core.recipes.nei.INBTMatchingCachedRecipe;
import forestry.core.recipes.nei.NEIUtils;
import forestry.core.recipes.nei.RecipeHandlerBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;

public class NEIHandlerShapedCustom
extends RecipeHandlerBase {
    @Override
    public void loadCraftingRecipes(ItemStack result) {
        for (Object recipe : CraftingManager.func_77594_a().func_77592_b()) {
            if (!(recipe instanceof ShapedRecipeCustom) || !NEIServerUtils.areStacksSameTypeCrafting((ItemStack)((ShapedRecipeCustom)recipe).func_77571_b(), (ItemStack)result)) continue;
            CachedShapedCustomRecipe crecipe = new CachedShapedCustomRecipe((ShapedRecipeCustom)recipe);
            NEIUtils.setResultPermutationNBT(crecipe, result);
            this.arecipes.add(crecipe);
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        for (Object recipe : CraftingManager.func_77594_a().func_77592_b()) {
            if (!(recipe instanceof ShapedRecipeCustom)) continue;
            CachedShapedCustomRecipe crecipe = new CachedShapedCustomRecipe((ShapedRecipeCustom)recipe);
            if (crecipe.inputs == null || !crecipe.contains(crecipe.inputs, ingredient)) continue;
            NEIUtils.setIngredientPermutationNBT(crecipe, ingredient);
            this.arecipes.add(crecipe);
        }
    }

    @Override
    public String getRecipeID() {
        return "crafting";
    }

    public String getOverlayIdentifier() {
        return "crafting";
    }

    public String getRecipeName() {
        return NEIUtils.translate("handler.forestry.shaped");
    }

    public String getGuiTexture() {
        return "minecraft:textures/gui/container/crafting_table.png";
    }

    public class CachedShapedCustomRecipe
    extends RecipeHandlerBase.CachedBaseRecipe
    implements INBTMatchingCachedRecipe {
        private final boolean preservesNbt;
        public List<PositionedStack> inputs;
        public PositionedStack output;

        public CachedShapedCustomRecipe(ShapedRecipeCustom recipe) {
            super(NEIHandlerShapedCustom.this);
            this.inputs = new ArrayList<PositionedStack>();
            if (recipe.getIngredients() != null && recipe.getIngredients().length > 0) {
                this.setIngredients(recipe.getWidth(), recipe.getHeight(), recipe.getIngredients());
            }
            if (recipe.func_77571_b() != null) {
                ItemStack output = recipe.func_77571_b();
                this.output = new PositionedStack((Object)output, 119, 24);
            }
            this.preservesNbt = recipe.preserveNBT();
        }

        public void setIngredients(int width, int height, Object[] items) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    Object item;
                    if (items.length <= y * width + x || (item = items[y * width + x]) == null || item instanceof ItemStack[] && ((ItemStack[])item).length == 0 || item instanceof List && ((List)item).size() == 0) continue;
                    PositionedStack stack = new PositionedStack(item, 25 + x * 18, 6 + y * 18);
                    stack.setMaxSize(1);
                    this.inputs.add(stack);
                }
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEIHandlerShapedCustom.this.cycleticks / 20, this.inputs);
        }

        @Override
        public boolean preservesNBT() {
            return this.preservesNbt;
        }

        @Override
        public PositionedStack getResult() {
            return this.output;
        }
    }
}

