/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.recipes;

import forestry.api.recipes.IDescriptiveRecipe;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.recipes.RecipeUtil;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class ShapedRecipeCustom
implements IDescriptiveRecipe {
    private final int width;
    private final int height;
    private final Object[] ingredients;
    private final ItemStack product;
    private boolean preserveNBT = false;

    public ShapedRecipeCustom(int width, int height, Object[] ingredients, ItemStack product) {
        this.width = width;
        this.height = height;
        this.ingredients = ingredients;
        this.product = product;
    }

    public ShapedRecipeCustom setPreserveNBT() {
        this.preserveNBT = true;
        return this;
    }

    @Override
    public boolean preserveNBT() {
        return this.preserveNBT;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public ItemStack func_77571_b() {
        return this.product.func_77946_l();
    }

    @Override
    public Object[] getIngredients() {
        return this.ingredients;
    }

    public boolean func_77569_a(InventoryCrafting inventoryCrafting, World world) {
        return RecipeUtil.matches(this, (IInventory)inventoryCrafting);
    }

    @Override
    @Deprecated
    public boolean matches(IInventory inventoryCrafting, World world) {
        return RecipeUtil.matches(this, inventoryCrafting);
    }

    public ItemStack func_77572_b(InventoryCrafting inventoryCrafting) {
        return RecipeUtil.getCraftingResult(this, (IInventory)inventoryCrafting);
    }

    public int func_77570_a() {
        return this.width * this.height;
    }

    public static ShapedRecipeCustom createShapedRecipe(ItemStack product, Object ... materials) {
        String s = "";
        int index = 0;
        int columns = 0;
        int rows = 0;
        if (materials[index] instanceof String[]) {
            String[] as;
            for (String pattern : as = (String[])materials[index++]) {
                ++rows;
                columns = pattern.length();
                s = s + pattern;
            }
        } else {
            while (materials[index] instanceof String) {
                String pattern = (String)materials[index++];
                ++rows;
                columns = pattern.length();
                s = s + pattern;
            }
        }
        HashMap<Character, Object> hashmap = new HashMap<Character, Object>();
        while (index < materials.length) {
            Character character = (Character)materials[index];
            if (materials[index + 1] instanceof Item) {
                hashmap.put(character, new ItemStack((Item)materials[index + 1]));
            } else if (materials[index + 1] instanceof ForestryItem) {
                hashmap.put(character, ((ForestryItem)((Object)materials[index + 1])).getItemStack());
            } else if (materials[index + 1] instanceof ForestryBlock) {
                hashmap.put(character, ((ForestryBlock)((Object)materials[index + 1])).getItemStack());
            } else if (materials[index + 1] instanceof Block) {
                hashmap.put(character, new ItemStack((Block)materials[index + 1], 1, Short.MAX_VALUE));
            } else if (materials[index + 1] instanceof ItemStack) {
                hashmap.put(character, materials[index + 1]);
            } else if (materials[index + 1] instanceof String) {
                hashmap.put(character, OreDictionary.getOres((String)((String)materials[index + 1])));
            } else {
                throw new RuntimeException("Invalid Recipe Defined!");
            }
            index += 2;
        }
        Object[] ingredients = new Object[columns * rows];
        for (int l = 0; l < columns * rows; ++l) {
            char c = s.charAt(l);
            ingredients[l] = hashmap.containsKey(Character.valueOf(c)) ? hashmap.get(Character.valueOf(c)) : null;
        }
        return new ShapedRecipeCustom(columns, rows, ingredients, product);
    }

    public static ShapedRecipeCustom buildRecipe(ItemStack product, Object ... materials) {
        ShapedRecipeCustom recipe = ShapedRecipeCustom.createShapedRecipe(product, materials);
        CraftingManager.func_77594_a().func_77592_b().add(recipe);
        return recipe;
    }

    public static ShapedRecipeCustom buildPriorityRecipe(ItemStack product, Object ... materials) {
        ShapedRecipeCustom recipe = ShapedRecipeCustom.createShapedRecipe(product, materials);
        CraftingManager.func_77594_a().func_77592_b().add(0, recipe);
        return recipe;
    }
}

