/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.multiblock.rectangular;

import forestry.core.multiblock.CoordTriplet;
import forestry.core.multiblock.MultiblockControllerBase;
import forestry.core.multiblock.MultiblockValidationException;
import forestry.core.multiblock.rectangular.RectangularMultiblockTileEntityBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public abstract class RectangularMultiblockControllerBase
extends MultiblockControllerBase {
    protected RectangularMultiblockControllerBase(World world) {
        super(world);
    }

    @Override
    protected void isMachineWhole() throws MultiblockValidationException {
        int minX = this.getMinimumXSize();
        int minY = this.getMinimumYSize();
        int minZ = this.getMinimumZSize();
        if (this.connectedParts.size() < this.getMinimumNumberOfBlocksForAssembledMachine()) {
            throw new MultiblockValidationException(StatCollector.func_74837_a((String)"for.multiblock.error.small", (Object[])new Object[]{minX, minY, minZ}));
        }
        CoordTriplet maximumCoord = this.getMaximumCoord();
        CoordTriplet minimumCoord = this.getMinimumCoord();
        int deltaX = maximumCoord.x - minimumCoord.x + 1;
        int deltaY = maximumCoord.y - minimumCoord.y + 1;
        int deltaZ = maximumCoord.z - minimumCoord.z + 1;
        int maxX = this.getMaximumXSize();
        int maxY = this.getMaximumYSize();
        int maxZ = this.getMaximumZSize();
        if (maxX > 0 && deltaX > maxX) {
            throw new MultiblockValidationException(StatCollector.func_74837_a((String)"for.multiblock.error.large.x", (Object[])new Object[]{maxX}));
        }
        if (maxY > 0 && deltaY > maxY) {
            throw new MultiblockValidationException(StatCollector.func_74837_a((String)"for.multiblock.error.large.y", (Object[])new Object[]{maxY}));
        }
        if (maxZ > 0 && deltaZ > maxZ) {
            throw new MultiblockValidationException(StatCollector.func_74837_a((String)"for.multiblock.error.large.z", (Object[])new Object[]{maxZ}));
        }
        if (deltaX < minX) {
            throw new MultiblockValidationException(StatCollector.func_74837_a((String)"for.multiblock.error.small.x", (Object[])new Object[]{minX}));
        }
        if (deltaY < minY) {
            throw new MultiblockValidationException(StatCollector.func_74837_a((String)"for.multiblock.error.small.y", (Object[])new Object[]{minY}));
        }
        if (deltaZ < minZ) {
            throw new MultiblockValidationException(StatCollector.func_74837_a((String)"for.multiblock.error.small.z", (Object[])new Object[]{minZ}));
        }
        Class<?> myClass = this.getClass();
        for (int x = minimumCoord.x; x <= maximumCoord.x; ++x) {
            for (int y = minimumCoord.y; y <= maximumCoord.y; ++y) {
                for (int z = minimumCoord.z; z <= maximumCoord.z; ++z) {
                    RectangularMultiblockTileEntityBase part;
                    TileEntity te = this.worldObj.func_147438_o(x, y, z);
                    if (te instanceof RectangularMultiblockTileEntityBase) {
                        part = (RectangularMultiblockTileEntityBase)te;
                        if (!myClass.equals(part.getMultiblockControllerType())) {
                            throw new MultiblockValidationException(StatCollector.func_74837_a((String)"for.multiblock.error.invalid.part", (Object[])new Object[]{x, y, z, myClass.getSimpleName()}));
                        }
                    } else {
                        part = null;
                    }
                    int extremes = 0;
                    if (x == minimumCoord.x) {
                        ++extremes;
                    }
                    if (y == minimumCoord.y) {
                        ++extremes;
                    }
                    if (z == minimumCoord.z) {
                        ++extremes;
                    }
                    if (x == maximumCoord.x) {
                        ++extremes;
                    }
                    if (y == maximumCoord.y) {
                        ++extremes;
                    }
                    if (z == maximumCoord.z) {
                        ++extremes;
                    }
                    if (extremes >= 1) {
                        int exteriorLevel = y - minimumCoord.y;
                        if (part != null) {
                            part.isGoodForExteriorLevel(exteriorLevel);
                            continue;
                        }
                        this.isBlockGoodForExteriorLevel(exteriorLevel, this.worldObj, x, y, z);
                        continue;
                    }
                    if (part != null) {
                        part.isGoodForInterior();
                        continue;
                    }
                    this.isBlockGoodForInterior(this.worldObj, x, y, z);
                }
            }
        }
    }
}

