/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.multiblock;

import com.mojang.authlib.GameProfile;
import forestry.core.access.IOwnable;
import forestry.core.config.Constants;
import forestry.core.inventory.FakeInventoryAdapter;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.multiblock.CoordTriplet;
import forestry.core.multiblock.IMultiblockPart;
import forestry.core.multiblock.MultiblockControllerBase;
import forestry.core.multiblock.MultiblockRegistry;
import forestry.core.tiles.IFilterSlotDelegate;
import forestry.core.utils.Log;
import forestry.core.utils.PlayerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.chunk.IChunkProvider;

public abstract class MultiblockTileEntityBase
extends IMultiblockPart
implements ISidedInventory,
IFilterSlotDelegate,
IOwnable {
    private MultiblockControllerBase controller = null;
    private boolean visited = false;
    private boolean saveMultiblockData = false;
    private NBTTagCompound cachedMultiblockData = null;
    private boolean paused = false;
    private GameProfile owner;

    @Override
    public final Set<MultiblockControllerBase> attachToNeighbors() {
        IMultiblockPart[] partsToCheck;
        HashSet<MultiblockControllerBase> controllers = null;
        MultiblockControllerBase bestController = null;
        for (IMultiblockPart neighborPart : partsToCheck = this.getNeighboringParts()) {
            MultiblockControllerBase candidate;
            if (!neighborPart.isConnected() || !(candidate = neighborPart.getMultiblockController()).getClass().equals(this.getMultiblockControllerType())) continue;
            if (controllers == null) {
                controllers = new HashSet<MultiblockControllerBase>();
                bestController = candidate;
            } else if (!controllers.contains(candidate) && candidate.shouldConsume(bestController)) {
                bestController = candidate;
            }
            controllers.add(candidate);
        }
        if (bestController != null) {
            this.controller = bestController;
            bestController.attachBlock(this);
        }
        return controllers;
    }

    @Override
    public final void assertDetached() {
        if (this.controller != null) {
            Log.info("[assert] Part @ (%d, %d, %d) should be detached already, but detected that it was not. This is not a fatal error, and will be repaired, but is unusual.", this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.controller = null;
        }
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        if (data.func_74764_b("multiblockData")) {
            this.cachedMultiblockData = data.func_74775_l("multiblockData");
        }
        if (data.func_74764_b("owner")) {
            this.owner = NBTUtil.func_152459_a((NBTTagCompound)data.func_74775_l("owner"));
        }
        this.getInternalInventory().readFromNBT(data);
    }

    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        if (this.isMultiblockSaveDelegate() && this.isConnected()) {
            NBTTagCompound multiblockData = new NBTTagCompound();
            this.controller.writeToNBT(multiblockData);
            data.func_74782_a("multiblockData", (NBTBase)multiblockData);
        }
        if (this.owner != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            NBTUtil.func_152460_a((NBTTagCompound)nbt, (GameProfile)this.owner);
            data.func_74782_a("owner", (NBTBase)nbt);
        }
        this.getInternalInventory().writeToNBT(data);
    }

    public boolean canUpdate() {
        return false;
    }

    public final void func_145843_s() {
        super.func_145843_s();
        this.detachSelf(false);
    }

    public final void onChunkUnload() {
        super.onChunkUnload();
        this.detachSelf(true);
    }

    public final void func_145829_t() {
        super.func_145829_t();
        MultiblockRegistry.onPartAdded(this.field_145850_b, this);
    }

    public final Packet func_145844_m() {
        NBTTagCompound packetData = new NBTTagCompound();
        this.encodeDescriptionPacket(packetData);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, packetData);
    }

    public final void onDataPacket(NetworkManager network, S35PacketUpdateTileEntity packet) {
        this.decodeDescriptionPacket(packet.func_148857_g());
    }

    protected void encodeDescriptionPacket(NBTTagCompound packetData) {
        if (this.isMultiblockSaveDelegate() && this.isConnected()) {
            NBTTagCompound tag = new NBTTagCompound();
            this.getMultiblockController().formatDescriptionPacket(tag);
            packetData.func_74782_a("multiblockData", (NBTBase)tag);
        }
    }

    protected void decodeDescriptionPacket(NBTTagCompound packetData) {
        if (packetData.func_74764_b("multiblockData")) {
            NBTTagCompound tag = packetData.func_74775_l("multiblockData");
            if (this.isConnected()) {
                this.getMultiblockController().decodeDescriptionPacket(tag);
            } else {
                this.cachedMultiblockData = tag;
            }
        }
    }

    @Override
    public final boolean hasMultiblockSaveData() {
        return this.cachedMultiblockData != null;
    }

    @Override
    public final NBTTagCompound getMultiblockSaveData() {
        return this.cachedMultiblockData;
    }

    @Override
    public final void onMultiblockDataAssimilated() {
        this.cachedMultiblockData = null;
    }

    @Override
    public abstract void onMachineAssembled(MultiblockControllerBase var1);

    @Override
    public abstract void onMachineBroken();

    @Override
    public abstract void onMachineActivated();

    @Override
    public abstract void onMachineDeactivated();

    @Override
    public final boolean isConnected() {
        return this.controller != null;
    }

    @Override
    public final MultiblockControllerBase getMultiblockController() {
        return this.controller;
    }

    @Override
    public final CoordTriplet getWorldLocation() {
        return new CoordTriplet(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public final void becomeMultiblockSaveDelegate() {
        this.saveMultiblockData = true;
    }

    @Override
    public final void forfeitMultiblockSaveDelegate() {
        this.saveMultiblockData = false;
    }

    @Override
    public final boolean isMultiblockSaveDelegate() {
        return this.saveMultiblockData;
    }

    @Override
    public final void setUnvisited() {
        this.visited = false;
    }

    @Override
    public final void setVisited() {
        this.visited = true;
    }

    @Override
    public final boolean isVisited() {
        return this.visited;
    }

    @Override
    public final void onAssimilated(MultiblockControllerBase newController) {
        assert (this.controller != newController);
        this.controller = newController;
    }

    @Override
    public void onAttached(MultiblockControllerBase newController) {
        this.controller = newController;
    }

    @Override
    public final void onDetached(MultiblockControllerBase oldController) {
        this.controller = null;
    }

    @Override
    public abstract MultiblockControllerBase createNewMultiblock();

    @Override
    public final IMultiblockPart[] getNeighboringParts() {
        CoordTriplet[] neighbors = new CoordTriplet[]{new CoordTriplet(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e), new CoordTriplet(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e), new CoordTriplet(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1), new CoordTriplet(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1), new CoordTriplet(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e), new CoordTriplet(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e)};
        ArrayList<IMultiblockPart> neighborParts = new ArrayList<IMultiblockPart>();
        IChunkProvider chunkProvider = this.field_145850_b.func_72863_F();
        for (CoordTriplet neighbor : neighbors) {
            TileEntity te;
            if (!chunkProvider.func_73149_a(neighbor.getChunkX(), neighbor.getChunkZ()) || !((te = this.field_145850_b.func_147438_o(neighbor.x, neighbor.y, neighbor.z)) instanceof IMultiblockPart)) continue;
            neighborParts.add((IMultiblockPart)te);
        }
        IMultiblockPart[] tmp = new IMultiblockPart[neighborParts.size()];
        return neighborParts.toArray(tmp);
    }

    @Override
    public final void onOrphaned(MultiblockControllerBase controller, int oldSize, int newSize) {
        this.func_70296_d();
        this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
    }

    public void notifyNeighborsOfBlockChange() {
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
    }

    protected void notifyNeighborsOfTileChange() {
        this.field_145850_b.func_147453_f(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
    }

    protected void detachSelf(boolean chunkUnloading) {
        if (this.controller != null) {
            this.controller.detachBlock(this, chunkUnloading);
            this.controller = null;
        }
        MultiblockRegistry.onPartRemovedFromWorld(this.field_145850_b, this);
    }

    @Override
    public boolean isOwned() {
        return this.owner != null;
    }

    @Override
    public GameProfile getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(GameProfile owner) {
        this.owner = owner;
    }

    @Override
    public boolean isOwner(EntityPlayer player) {
        return PlayerUtil.isSameGameProfile(this.owner, player.func_146103_bH());
    }

    public IInventoryAdapter getInternalInventory() {
        return FakeInventoryAdapter.instance();
    }

    public boolean allowsAutomation() {
        return false;
    }

    public final int func_70302_i_() {
        return this.getInternalInventory().func_70302_i_();
    }

    public final ItemStack func_70301_a(int slotIndex) {
        return this.getInternalInventory().func_70301_a(slotIndex);
    }

    public final ItemStack func_70298_a(int slotIndex, int amount) {
        return this.getInternalInventory().func_70298_a(slotIndex, amount);
    }

    public final ItemStack func_70304_b(int slotIndex) {
        return this.getInternalInventory().func_70304_b(slotIndex);
    }

    public final void func_70299_a(int slotIndex, ItemStack itemstack) {
        this.getInternalInventory().func_70299_a(slotIndex, itemstack);
    }

    public final int func_70297_j_() {
        return this.getInternalInventory().func_70297_j_();
    }

    public final void func_70295_k_() {
        this.getInternalInventory().func_70295_k_();
    }

    public final void func_70305_f() {
        this.getInternalInventory().func_70305_f();
    }

    public final String func_145825_b() {
        return this.getInternalInventory().func_145825_b();
    }

    public final boolean func_70300_a(EntityPlayer player) {
        return this.getInternalInventory().func_70300_a(player);
    }

    public final boolean func_145818_k_() {
        return this.getInternalInventory().func_145818_k_();
    }

    public final boolean func_94041_b(int slotIndex, ItemStack itemStack) {
        return this.getInternalInventory().func_94041_b(slotIndex, itemStack);
    }

    public final int[] func_94128_d(int side) {
        if (this.allowsAutomation()) {
            return this.getInternalInventory().func_94128_d(side);
        }
        return Constants.SLOTS_NONE;
    }

    public final boolean func_102007_a(int slotIndex, ItemStack itemStack, int side) {
        if (this.allowsAutomation()) {
            return this.getInternalInventory().func_102007_a(slotIndex, itemStack, side);
        }
        return false;
    }

    public final boolean func_102008_b(int slotIndex, ItemStack itemStack, int side) {
        if (this.allowsAutomation()) {
            return this.getInternalInventory().func_102008_b(slotIndex, itemStack, side);
        }
        return false;
    }

    @Override
    public final boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        return this.getInternalInventory().canSlotAccept(slotIndex, itemStack);
    }

    @Override
    public final boolean isLocked(int slotIndex) {
        return this.getInternalInventory().isLocked(slotIndex);
    }

    public void openGui(EntityPlayer player) {
    }
}

