/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.CreativeTabForestry;
import forestry.core.fluids.BlockForestryFluid;
import forestry.core.fluids.FluidHelper;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import java.awt.Color;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;

public class ItemLiquidContainer
extends Item {
    private static final Map<Block, ItemLiquidContainer> buckets = new HashMap<Block, ItemLiquidContainer>();
    private boolean isDrink = false;
    private boolean isAlwaysEdible = false;
    private int healAmount = 0;
    private float saturationModifier = 0.0f;
    private final EnumContainerType type;
    private final Block contents;
    private final Color color;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public ItemLiquidContainer(EnumContainerType type, Block contents, Color color) {
        this.type = type;
        this.contents = contents;
        this.color = color;
        this.func_77637_a(CreativeTabForestry.tabForestry);
        if (type == EnumContainerType.BUCKET) {
            this.func_77642_a(Items.field_151133_ar);
            this.field_77777_bU = 1;
            buckets.put(contents, this);
        }
    }

    public static ItemLiquidContainer getExistingBucket(Block contents) {
        return buckets.get(contents);
    }

    private static int getMatchingSlot(EntityPlayer player, ItemStack stack) {
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.length; ++slot) {
            int space;
            ItemStack slotStack = player.field_71071_by.func_70301_a(slot);
            if (slotStack == null) {
                return slot;
            }
            if (!slotStack.func_77969_a(stack) || (space = slotStack.func_77976_d() - slotStack.field_77994_a) < stack.field_77994_a) continue;
            return slot;
        }
        return -1;
    }

    public ItemStack func_77654_b(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (!this.isDrink) {
            return itemstack;
        }
        --itemstack.field_77994_a;
        entityplayer.func_71024_bL().func_75122_a(this.healAmount, this.saturationModifier);
        world.func_72956_a((Entity)entityplayer, "random.burp", 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        return itemstack;
    }

    public int func_77626_a(ItemStack itemstack) {
        if (this.isDrink) {
            return 32;
        }
        return super.func_77626_a(itemstack);
    }

    public EnumAction func_77661_b(ItemStack itemstack) {
        if (this.isDrink) {
            return EnumAction.drink;
        }
        return EnumAction.none;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (world.field_72995_K) {
            return itemstack;
        }
        if (this.isDrink) {
            if (entityplayer.func_71043_e(this.isAlwaysEdible)) {
                entityplayer.func_71008_a(itemstack, this.func_77626_a(itemstack));
            }
            return itemstack;
        }
        MovingObjectPosition movingobjectposition = this.func_77621_a(world, entityplayer, true);
        if (movingobjectposition != null && movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int x = movingobjectposition.field_72311_b;
            int y = movingobjectposition.field_72312_c;
            int z = movingobjectposition.field_72309_d;
            Block targetedBlock = world.func_147439_a(x, y, z);
            FluidStack fluid = null;
            if (targetedBlock instanceof IFluidBlock) {
                fluid = ((IFluidBlock)targetedBlock).drain(world, x, y, z, false);
            } else if (targetedBlock == Blocks.field_150355_j || targetedBlock == Blocks.field_150358_i) {
                fluid = new FluidStack(FluidRegistry.WATER, 1000);
            } else if (targetedBlock == Blocks.field_150353_l || targetedBlock == Blocks.field_150356_k) {
                fluid = new FluidStack(FluidRegistry.LAVA, 1000);
            }
            if (fluid == null || fluid.amount <= 0 && this.type == EnumContainerType.BUCKET) {
                return this.tryPlaceLiquid(itemstack, world, entityplayer, movingobjectposition);
            }
            ItemStack filledContainer = FluidHelper.getFilledContainer(fluid.getFluid(), itemstack);
            if (filledContainer == null) {
                return itemstack;
            }
            int slot = ItemLiquidContainer.getMatchingSlot(entityplayer, filledContainer);
            if (slot < 0) {
                return itemstack;
            }
            if (entityplayer.field_71071_by.func_70301_a(slot) == null) {
                entityplayer.field_71071_by.func_70299_a(slot, filledContainer.func_77946_l());
            } else {
                ++entityplayer.field_71071_by.func_70301_a((int)slot).field_77994_a;
            }
            if (targetedBlock instanceof IFluidBlock) {
                ((IFluidBlock)targetedBlock).drain(world, x, y, z, true);
            } else {
                world.func_147468_f(x, y, z);
            }
            --itemstack.field_77994_a;
            Proxies.net.inventoryChangeNotify(entityplayer);
            return itemstack;
        }
        return itemstack;
    }

    private ItemStack tryPlaceLiquid(ItemStack itemstack, World world, EntityPlayer player, MovingObjectPosition movingobjectposition) {
        if (this.type != EnumContainerType.BUCKET) {
            return itemstack;
        }
        if (this.contents == Blocks.field_150350_a) {
            return new ItemStack(Items.field_151133_ar);
        }
        int x = movingobjectposition.field_72311_b;
        int y = movingobjectposition.field_72312_c;
        int z = movingobjectposition.field_72309_d;
        switch (movingobjectposition.field_72310_e) {
            case 0: {
                --y;
                break;
            }
            case 1: {
                ++y;
                break;
            }
            case 2: {
                --z;
                break;
            }
            case 3: {
                ++z;
                break;
            }
            case 4: {
                --x;
                break;
            }
            case 5: {
                ++x;
            }
        }
        if (!player.func_82247_a(x, y, z, movingobjectposition.field_72310_e, itemstack)) {
            return itemstack;
        }
        if (this.tryPlaceLiquidAtPosition(world, x, y, z) && !player.field_71075_bZ.field_75098_d) {
            return new ItemStack(Items.field_151133_ar);
        }
        return itemstack;
    }

    private boolean tryPlaceLiquidAtPosition(World world, int x, int y, int z) {
        boolean isLiquid;
        if (this.contents == Blocks.field_150350_a) {
            return false;
        }
        Material material = world.func_147439_a(x, y, z).func_149688_o();
        boolean bl = isLiquid = !material.func_76220_a();
        if (!world.func_147437_c(x, y, z) && !isLiquid) {
            return false;
        }
        if (world.field_73011_w.field_76575_d && this.contents != Blocks.field_150356_k) {
            int flammability = this.contents.getFlammability((IBlockAccess)world, x, y, z, ForgeDirection.UNKNOWN);
            if (this.contents instanceof BlockForestryFluid && flammability > 0) {
                float explosionSize = 4.0f * (float)flammability / 300.0f;
                world.func_72885_a(null, (double)x, (double)y, (double)z, explosionSize, true, true);
                return true;
            }
            Random random = world.field_73012_v;
            world.func_72908_a((double)x + 0.5, (double)((float)y + 0.5f), (double)((float)z + 0.5f), "random.fizz", 0.5f, 2.6f + (random.nextFloat() - random.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                world.func_72869_a("largesmoke", (double)x + random.nextDouble(), (double)y + random.nextDouble(), (double)z + random.nextDouble(), 0.0, 0.0, 0.0);
            }
        } else {
            if (!world.field_72995_K && isLiquid && !material.func_76224_d()) {
                world.func_147480_a(x, y, z, true);
            }
            world.func_147465_d(x, y, z, this.contents, 0, 3);
        }
        return true;
    }

    public ItemLiquidContainer setDrink(int healAmount, float saturationModifier) {
        this.isDrink = true;
        this.healAmount = healAmount;
        this.saturationModifier = saturationModifier;
        return this;
    }

    public ItemLiquidContainer setAlwaysEdible() {
        this.isAlwaysEdible = true;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.icons = new IIcon[2];
        this.icons[0] = TextureManager.registerTex(register, "liquids/" + this.type.toString().toLowerCase(Locale.ENGLISH) + ".bottle");
        this.icons[1] = TextureManager.registerTex(register, "liquids/" + this.type.toString().toLowerCase(Locale.ENGLISH) + ".contents");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int i, int j) {
        if (j > 0 && this.color != null) {
            return this.icons[1];
        }
        return this.icons[0];
    }

    public boolean func_77623_v() {
        return true;
    }

    public int func_82790_a(ItemStack itemstack, int j) {
        if (j > 0 && this.color != null) {
            return this.color.getRGB() & 0xFFFFFF;
        }
        return 0xFFFFFF;
    }

    public EnumContainerType getType() {
        return this.type;
    }

    public static enum EnumContainerType {
        GLASS,
        JAR,
        CAN,
        CAPSULE,
        REFRACTORY,
        BUCKET;

    }
}

