/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory;

import forestry.core.config.Constants;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.InventoryPlain;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InventoryAdapter
implements IInventoryAdapter,
IStreamable {
    private final IInventory inventory;
    private boolean allowAutomation = true;
    private int[][] slotMap;

    public InventoryAdapter(int size, String name) {
        this(size, name, 64);
    }

    public InventoryAdapter(int size, String name, int stackLimit) {
        this(new InventoryPlain(size, name, stackLimit));
    }

    public InventoryAdapter(IInventory inventory) {
        this.inventory = inventory;
        this.configureSided();
    }

    public InventoryAdapter disableAutomation() {
        this.allowAutomation = false;
        return this;
    }

    public InventoryAdapter copy() {
        InventoryAdapter copy = new InventoryAdapter(this.inventory.func_70302_i_(), this.inventory.func_145825_b(), this.inventory.func_70297_j_());
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            if (this.inventory.func_70301_a(i) == null) continue;
            copy.func_70299_a(i, this.inventory.func_70301_a(i).func_77946_l());
        }
        return copy;
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slotId) {
        return this.inventory.func_70301_a(slotId);
    }

    public ItemStack func_70298_a(int slotId, int count) {
        return this.inventory.func_70298_a(slotId, count);
    }

    public void func_70299_a(int slotId, ItemStack itemstack) {
        this.inventory.func_70299_a(slotId, itemstack);
    }

    public String func_145825_b() {
        return this.inventory.func_145825_b();
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public void func_70296_d() {
        this.inventory.func_70296_d();
    }

    public ItemStack func_70304_b(int slotIndex) {
        return this.inventory.func_70304_b(slotIndex);
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean isLocked(int slotIndex) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int[] func_94128_d(int side) {
        if (this.allowAutomation) {
            return this.slotMap[side];
        }
        return Constants.SLOTS_NONE;
    }

    private void configureSided() {
        this.slotMap = new int[6][0];
        int count = this.func_70302_i_();
        int[] slots = new int[count];
        for (int i = 0; i < count; ++i) {
            slots[i] = i;
        }
        for (int side : Constants.FACINGS) {
            this.slotMap[side] = slots;
        }
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        if (!nbttagcompound.func_74764_b(this.inventory.func_145825_b())) {
            return;
        }
        NBTTagList nbttaglist = nbttagcompound.func_150295_c(this.inventory.func_145825_b(), 10);
        for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
            NBTTagCompound nbttagcompound2 = nbttaglist.func_150305_b(j);
            byte index = nbttagcompound2.func_74771_c("Slot");
            this.inventory.func_70299_a((int)index, ItemStack.func_77949_a((NBTTagCompound)nbttagcompound2));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            if (this.inventory.func_70301_a(i) == null) continue;
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            nbttagcompound2.func_74774_a("Slot", (byte)i);
            this.inventory.func_70301_a(i).func_77955_b(nbttagcompound2);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound2);
        }
        nbttagcompound.func_74782_a(this.inventory.func_145825_b(), (NBTBase)nbttaglist);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        data.writeInventory(this.inventory);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        data.readInventory(this.inventory);
    }
}

