/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import codechicken.nei.VisiblityData;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.TaggedInventoryArea;
import cpw.mods.fml.common.Optional;
import forestry.api.core.IErrorLogicSource;
import forestry.api.core.IErrorSource;
import forestry.core.config.Config;
import forestry.core.gui.IHintSource;
import forestry.core.gui.ledgers.ClimateLedger;
import forestry.core.gui.ledgers.HintLedger;
import forestry.core.gui.ledgers.LedgerManager;
import forestry.core.gui.ledgers.OwnerLedger;
import forestry.core.gui.ledgers.PowerLedger;
import forestry.core.gui.tooltips.IToolTipProvider;
import forestry.core.gui.tooltips.ToolTip;
import forestry.core.gui.tooltips.ToolTipLine;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.proxy.Proxies;
import forestry.core.render.FontColour;
import forestry.core.tiles.IClimatised;
import forestry.core.tiles.IPowerHandler;
import forestry.core.tiles.TileForestry;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@Optional.Interface(iface="codechicken.nei.api.INEIGuiHandler", modid="NotEnoughItems")
public abstract class GuiForestry<C extends Container, I extends IInventory>
extends GuiContainer
implements INEIGuiHandler {
    protected static final int LINE_HEIGHT = 12;
    protected final I inventory;
    protected final C container;
    protected final FontColour fontColor;
    public final ResourceLocation textureFile;
    protected WidgetManager widgetManager = new WidgetManager(this);
    protected LedgerManager ledgerManager;
    protected int column0;
    protected int column1;
    protected int column2;
    private int line;

    protected GuiForestry(String texture, C container, I inventory) {
        this(new ResourceLocation("forestry", texture), container, inventory);
    }

    protected GuiForestry(ResourceLocation texture, C container, I inventory) {
        super(container);
        this.textureFile = texture;
        this.inventory = inventory;
        this.container = container;
        this.fontColor = new FontColour(Proxies.render.getSelectedTexturePack());
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int maxLedgerWidth = (this.field_146294_l - this.field_146999_f) / 2;
        this.ledgerManager = new LedgerManager(this, maxLedgerWidth);
        if (this.inventory instanceof IErrorSource) {
            this.ledgerManager.add((IErrorSource)this.inventory);
        }
        if (this.inventory instanceof IErrorLogicSource) {
            IErrorLogicSource errorLogicSource = (IErrorLogicSource)this.inventory;
            this.ledgerManager.add(errorLogicSource.getErrorLogic());
        }
        if (this.inventory instanceof IClimatised) {
            this.ledgerManager.add(new ClimateLedger(this.ledgerManager, (IClimatised)this.inventory));
        }
        if (Config.enableEnergyStat && this.inventory instanceof IPowerHandler && ((IPowerHandler)this.inventory).getEnergyManager().getMaxEnergyStored() > 0) {
            this.ledgerManager.add(new PowerLedger(this.ledgerManager, (IPowerHandler)this.inventory));
        }
        if (Config.enableHints && this.inventory instanceof IHintSource && ((IHintSource)this.inventory).hasHints()) {
            this.ledgerManager.add(new HintLedger(this.ledgerManager, (IHintSource)this.inventory));
        }
        if (this.inventory instanceof TileForestry) {
            this.ledgerManager.add(new OwnerLedger(this.ledgerManager, (TileForestry)this.inventory));
        }
    }

    protected final void startPage() {
        this.line = 12;
        GL11.glPushMatrix();
    }

    protected final void startPage(int column0, int column1, int column2) {
        this.column0 = column0;
        this.column1 = column1;
        this.column2 = column2;
        this.startPage();
    }

    protected final int getLineY() {
        return this.line;
    }

    protected final void newLine() {
        this.line += 12;
    }

    protected final void newLineCompressed() {
        this.line += 10;
    }

    protected final void newLine(int lineHeight) {
        this.line += lineHeight;
    }

    protected final void endPage() {
        GL11.glPopMatrix();
    }

    protected final void drawRow(String text0, String text1, String text2, int colour0, int colour1, int colour2) {
        this.drawLine(text0, this.column0, colour0);
        this.drawLine(text1, this.column1, colour1);
        this.drawLine(text2, this.column2, colour2);
    }

    protected final void drawLine(String text, int x) {
        this.drawLine(text, x, this.fontColor.get("gui.screen"));
    }

    protected final void drawSplitLine(String text, int x, int maxWidth) {
        this.drawSplitLine(text, x, maxWidth, this.fontColor.get("gui.screen"));
    }

    protected final void drawCenteredLine(String text, int x, int width) {
        this.drawCenteredLine(text, x, width, this.fontColor.get("gui.screen"));
    }

    protected final void drawCenteredLine(String text, int x, int width, int color) {
        this.field_146289_q.func_78276_b(text, this.field_147003_i + x + (width - this.field_146289_q.func_78256_a(text)) / 2, this.field_147009_r + this.line, color);
    }

    protected final void drawLine(String text, int x, int color) {
        this.field_146289_q.func_78276_b(text, this.field_147003_i + x, this.field_147009_r + this.line, color);
    }

    protected final void drawSplitLine(String text, int x, int maxWidth, int color) {
        this.field_146289_q.func_78279_b(text, this.field_147003_i + x, this.field_147009_r + this.line, maxWidth, color);
    }

    protected int getCenteredOffset(String string) {
        return this.getCenteredOffset(string, this.field_146999_f);
    }

    protected int getCenteredOffset(String string, int xWidth) {
        return (xWidth - this.field_146289_q.func_78256_a(string)) / 2;
    }

    protected void func_73864_a(int xPos, int yPos, int mouseButton) {
        super.func_73864_a(xPos, yPos, mouseButton);
        this.ledgerManager.handleMouseClicked(xPos, yPos, mouseButton);
        this.widgetManager.handleMouseClicked(xPos, yPos, mouseButton);
    }

    protected void func_146286_b(int mouseX, int mouseY, int eventType) {
        super.func_146286_b(mouseX, mouseY, eventType);
        this.widgetManager.handleMouseRelease(mouseX, mouseY, eventType);
    }

    protected void func_146273_a(int mouseX, int mouseY, int mouseButton, long time) {
        this.widgetManager.handleMouseMove(mouseX, mouseY, mouseButton, time);
        super.func_146273_a(mouseX, mouseY, mouseButton, time);
    }

    protected Slot func_146975_c(int par1, int par2) {
        for (int k = 0; k < this.field_147002_h.field_75151_b.size(); ++k) {
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(k);
            if (!this.isMouseOverSlot(slot, par1, par2)) continue;
            return slot;
        }
        return null;
    }

    private boolean isMouseOverSlot(Slot par1Slot, int par2, int par3) {
        return this.func_146978_c(par1Slot.field_75223_e, par1Slot.field_75221_f, 16, 16, par2, par3);
    }

    private void drawToolTips(ToolTip toolTips, int mouseX, int mouseY) {
        int y;
        if (toolTips == null) {
            return;
        }
        if (toolTips.isEmpty()) {
            return;
        }
        int left = this.field_147003_i;
        int top = this.field_147009_r;
        int length = 0;
        int height = 0;
        Iterator i$ = toolTips.iterator();
        while (i$.hasNext()) {
            ToolTipLine tip = (ToolTipLine)i$.next();
            y = this.field_146289_q.func_78256_a(tip.toString());
            height += 10 + tip.getSpacing();
            if (y <= length) continue;
            length = y;
        }
        int x = mouseX - left + 12;
        y = mouseY - top - 12;
        this.field_73735_i = 300.0f;
        GuiForestry.field_146296_j.field_77023_b = 300.0f;
        Color backgroundColor = new Color(16, 0, 16, 240);
        int backgroundColorInt = backgroundColor.getRGB();
        this.func_73733_a(x - 3, y - 4, x + length + 2, y - 3, backgroundColorInt, backgroundColorInt);
        this.func_73733_a(x - 3, y + height + 1, x + length + 2, y + height + 2, backgroundColorInt, backgroundColorInt);
        this.func_73733_a(x - 3, y - 3, x + length + 2, y + height + 1, backgroundColorInt, backgroundColorInt);
        this.func_73733_a(x - 4, y - 3, x - 3, y + height + 1, backgroundColorInt, backgroundColorInt);
        this.func_73733_a(x + length + 2, y - 3, x + length + 3, y + height + 1, backgroundColorInt, backgroundColorInt);
        Color borderColorTop = new Color(80, 0, 255, 80);
        int borderColorTopInt = borderColorTop.getRGB();
        Color borderColorBottom = new Color((borderColorTopInt & 0xFEFEFE) >> 1 | borderColorTopInt & 0xFF000000, true);
        int borderColorBottomInt = borderColorBottom.getRGB();
        this.func_73733_a(x - 3, y - 3 + 1, x - 3 + 1, y + height, borderColorTopInt, borderColorBottomInt);
        this.func_73733_a(x + length + 1, y - 3 + 1, x + length + 2, y + height, borderColorTopInt, borderColorBottomInt);
        this.func_73733_a(x - 3, y - 3, x + length + 2, y - 3 + 1, borderColorTopInt, borderColorTopInt);
        this.func_73733_a(x - 3, y + height, x + length + 2, y + height + 1, borderColorBottomInt, borderColorBottomInt);
        boolean firstLine = true;
        Iterator i$2 = toolTips.iterator();
        while (i$2.hasNext()) {
            ToolTipLine tip = (ToolTipLine)i$2.next();
            String line = tip.toString();
            if (!firstLine) {
                line = EnumChatFormatting.GRAY + line;
            }
            this.field_146289_q.func_78261_a(line, x, y, -1);
            y += 10 + tip.getSpacing();
            firstLine = false;
        }
        this.field_73735_i = 0.0f;
        GuiForestry.field_146296_j.field_77023_b = 0.0f;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GL11.glPushAttrib((int)8192);
        RenderHelper.func_74520_c();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.ledgerManager.drawTooltips(mouseX, mouseY);
        InventoryPlayer playerInv = this.field_146297_k.field_71439_g.field_71071_by;
        if (playerInv.func_70445_o() == null) {
            this.drawToolTips(this.widgetManager.getWidgets(), mouseX, mouseY);
            this.drawToolTips(this.field_146292_n, mouseX, mouseY);
            this.drawToolTips(this.field_147002_h.field_75151_b, mouseX, mouseY);
        }
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    private void drawToolTips(Collection<?> objects, int mouseX, int mouseY) {
        for (Object obj : objects) {
            ToolTip tips;
            IToolTipProvider provider;
            if (!(obj instanceof IToolTipProvider) || !(provider = (IToolTipProvider)obj).isToolTipVisible() || (tips = provider.getToolTip()) == null) continue;
            boolean mouseOver = provider.isMouseOver(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
            tips.onTick(mouseOver);
            if (!mouseOver || !tips.isReady()) continue;
            tips.refresh();
            this.drawToolTips(tips, mouseX, mouseY);
        }
    }

    protected void func_146976_a(float f, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture(this.textureFile);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        int left = this.field_147003_i;
        int top = this.field_147009_r;
        GL11.glPushAttrib((int)8192);
        RenderHelper.func_74520_c();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)left, (float)top, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawWidgets();
        GL11.glPopMatrix();
        GL11.glPopAttrib();
        this.bindTexture(this.textureFile);
    }

    protected void drawWidgets() {
        this.ledgerManager.drawLedgers();
        this.widgetManager.drawWidgets();
    }

    protected void bindTexture(ResourceLocation texturePath) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Proxies.render.bindTexture(texturePath);
    }

    public void setZLevel(float level) {
        this.field_73735_i = level;
    }

    public static RenderItem getItemRenderer() {
        return field_146296_j;
    }

    public int getSizeX() {
        return this.field_146999_f;
    }

    public int getSizeY() {
        return this.field_147000_g;
    }

    public int getGuiLeft() {
        return this.field_147003_i;
    }

    public int getGuiTop() {
        return this.field_147009_r;
    }

    public FontColour getFontColor() {
        return this.fontColor;
    }

    public void func_73733_a(int par1, int par2, int par3, int par4, int par5, int par6) {
        super.func_73733_a(par1, par2, par3, par4, par5, par6);
    }

    public void drawItemStack(ItemStack stack, int xPos, int yPos) {
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderHelper.func_74520_c();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 100.0f;
        GuiForestry.field_146296_j.field_77023_b = 100.0f;
        FontRenderer font = null;
        if (stack != null) {
            font = stack.func_77973_b().getFontRenderer(stack);
        }
        if (font == null) {
            font = this.field_146289_q;
        }
        field_146296_j.func_82406_b(font, this.field_146297_k.func_110434_K(), stack, xPos, yPos);
        field_146296_j.func_77021_b(font, this.field_146297_k.func_110434_K(), stack, xPos, yPos);
        this.field_73735_i = 0.0f;
        GuiForestry.field_146296_j.field_77023_b = 0.0f;
        RenderHelper.func_74518_a();
        GL11.glPopAttrib();
    }

    @Optional.Method(modid="NotEnoughItems")
    public VisiblityData modifyVisiblity(GuiContainer gui, VisiblityData currentVisibility) {
        return null;
    }

    @Optional.Method(modid="NotEnoughItems")
    public Iterable<Integer> getItemSpawnSlots(GuiContainer gui, ItemStack item) {
        return Collections.emptyList();
    }

    @Optional.Method(modid="NotEnoughItems")
    public List<TaggedInventoryArea> getInventoryAreas(GuiContainer gui) {
        return Collections.emptyList();
    }

    @Optional.Method(modid="NotEnoughItems")
    public boolean handleDragNDrop(GuiContainer gui, int mousex, int mousey, ItemStack draggedStack, int button) {
        return false;
    }

    @Optional.Method(modid="NotEnoughItems")
    public boolean hideItemPanelSlot(GuiContainer gui, int x, int y, int w, int h) {
        if (gui instanceof GuiForestry) {
            return ((GuiForestry)gui).ledgerManager.ledgerOverlaps(x, y, w, h);
        }
        return false;
    }

    protected class ItemStackWidget
    extends Widget {
        private final ItemStack itemStack;

        public ItemStackWidget(int xPos, int yPos, ItemStack itemStack) {
            super(GuiForestry.this.widgetManager, xPos, yPos);
            this.itemStack = itemStack;
        }

        @Override
        public void draw(int startX, int startY) {
            GuiForestry.this.drawItemStack(this.itemStack, this.xPos + startX, this.yPos + startY);
        }

        @Override
        public ToolTip getToolTip() {
            EntityPlayer player = Proxies.common.getPlayer();
            ToolTip tip = new ToolTip();
            if (this.itemStack != null) {
                tip.add(this.itemStack.func_82840_a(player, false));
            }
            return tip;
        }
    }
}

