/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.Event;
import forestry.api.core.ForestryEvent;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.network.PacketGenomeTrackerUpdate;
import forestry.core.proxy.Proxies;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.common.MinecraftForge;

public abstract class BreedingTracker
extends WorldSavedData
implements IBreedingTracker {
    private static final String SPECIES_COUNT_KEY = "SpeciesCount";
    private static final String MUTATIONS_COUNT_KEY = "MutationsCount";
    private static final String RESEARCHED_COUNT_KEY = "ResearchedCount";
    private static final String SPECIES_KEY = "SD";
    private static final String MUTATIONS_KEY = "MD";
    private static final String RESEARCHED_KEY = "RD";
    private static final String MODE_NAME_KEY = "BMS";
    private static final String MUTATION_FORMAT = "%s-%s=%s";
    public static final String TYPE_KEY = "TYPE";
    private final Set<String> discoveredSpecies = new HashSet<String>();
    private final Set<String> discoveredMutations = new HashSet<String>();
    private final Set<String> researchedMutations = new HashSet<String>();
    private String modeName;
    private final GameProfile username;

    protected BreedingTracker(String s, GameProfile username) {
        super(s);
        this.username = username;
    }

    @Override
    public String getModeName() {
        return this.modeName;
    }

    @Override
    public void setModeName(String name) {
        this.modeName = name;
        this.func_76185_a();
    }

    protected abstract IBreedingTracker getBreedingTracker(EntityPlayer var1);

    protected abstract String speciesRootUID();

    @Override
    public void synchToPlayer(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            IBreedingTracker breedingTracker = this.getBreedingTracker(player);
            String modeName = breedingTracker.getModeName();
            this.setModeName(modeName);
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            this.encodeToNBT(nbttagcompound);
            Proxies.net.sendToPlayer(new PacketGenomeTrackerUpdate(nbttagcompound), (EntityPlayer)((EntityPlayerMP)player));
        }
    }

    @Override
    public void decodeFromNBT(NBTTagCompound nbttagcompound) {
        this.func_76184_a(nbttagcompound);
    }

    @Override
    public void encodeToNBT(NBTTagCompound nbttagcompound) {
        this.func_76187_b(nbttagcompound);
    }

    public void func_76184_a(NBTTagCompound nbttagcompound) {
        if (nbttagcompound.func_74764_b(MODE_NAME_KEY)) {
            this.modeName = nbttagcompound.func_74779_i(MODE_NAME_KEY);
        }
        BreedingTracker.readValuesFromNBT(nbttagcompound, this.discoveredSpecies, SPECIES_COUNT_KEY, SPECIES_KEY);
        BreedingTracker.readValuesFromNBT(nbttagcompound, this.discoveredMutations, MUTATIONS_COUNT_KEY, MUTATIONS_KEY);
        BreedingTracker.readValuesFromNBT(nbttagcompound, this.researchedMutations, RESEARCHED_COUNT_KEY, RESEARCHED_KEY);
    }

    public void func_76187_b(NBTTagCompound nbttagcompound) {
        if (this.modeName != null && !this.modeName.isEmpty()) {
            nbttagcompound.func_74778_a(MODE_NAME_KEY, this.modeName);
        }
        nbttagcompound.func_74778_a(TYPE_KEY, this.speciesRootUID());
        BreedingTracker.writeValuesToNBT(nbttagcompound, this.discoveredSpecies, SPECIES_COUNT_KEY, SPECIES_KEY);
        BreedingTracker.writeValuesToNBT(nbttagcompound, this.discoveredMutations, MUTATIONS_COUNT_KEY, MUTATIONS_KEY);
        BreedingTracker.writeValuesToNBT(nbttagcompound, this.researchedMutations, RESEARCHED_COUNT_KEY, RESEARCHED_KEY);
    }

    private static void readValuesFromNBT(NBTTagCompound nbttagcompound, Collection<String> values, String countKey, String key) {
        values.clear();
        if (nbttagcompound.func_74764_b(countKey)) {
            int count = nbttagcompound.func_74762_e(countKey);
            for (int i = 0; i < count; ++i) {
                String value = nbttagcompound.func_74779_i(key + i);
                if (value == null || value.length() <= 0) continue;
                values.add(value);
            }
        }
    }

    private static void writeValuesToNBT(NBTTagCompound nbttagcompound, Collection<String> values, String countKey, String key) {
        int count = values.size();
        nbttagcompound.func_74768_a(countKey, count);
        Iterator<String> iterator = values.iterator();
        for (int i = 0; i < count; ++i) {
            String value = iterator.next();
            if (value == null || value.length() <= 0) continue;
            nbttagcompound.func_74778_a(key + i, value);
        }
    }

    private static String getMutationString(IMutation mutation) {
        String species0 = mutation.getAllele0().getUID();
        String species1 = mutation.getAllele1().getUID();
        String resultSpecies = mutation.getTemplate()[0].getUID();
        return String.format(MUTATION_FORMAT, species0, species1, resultSpecies);
    }

    @Override
    public void registerMutation(IMutation mutation) {
        String mutationString = BreedingTracker.getMutationString(mutation);
        if (!this.discoveredMutations.contains(mutationString)) {
            this.discoveredMutations.add(mutationString);
            this.func_76185_a();
            ISpeciesRoot speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(this.speciesRootUID());
            ForestryEvent.MutationDiscovered event = new ForestryEvent.MutationDiscovered(speciesRoot, this.username, mutation, this);
            MinecraftForge.EVENT_BUS.post((Event)event);
        }
    }

    @Override
    public boolean isDiscovered(IMutation mutation) {
        String mutationString = BreedingTracker.getMutationString(mutation);
        return this.discoveredMutations.contains(mutationString);
    }

    @Override
    public boolean isDiscovered(IAlleleSpecies species) {
        return this.discoveredSpecies.contains(species.getUID());
    }

    @Override
    public int getSpeciesBred() {
        return this.discoveredSpecies.size();
    }

    @Override
    public void registerBirth(IIndividual individual) {
        this.registerSpecies(individual.getGenome().getPrimary());
        this.registerSpecies(individual.getGenome().getSecondary());
    }

    @Override
    public void registerSpecies(IAlleleSpecies species) {
        if (!this.discoveredSpecies.contains(species.getUID())) {
            this.discoveredSpecies.add(species.getUID());
            ISpeciesRoot speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(this.speciesRootUID());
            ForestryEvent.SpeciesDiscovered event = new ForestryEvent.SpeciesDiscovered(speciesRoot, this.username, species, this);
            MinecraftForge.EVENT_BUS.post((Event)event);
        }
    }

    @Override
    public void researchMutation(IMutation mutation) {
        String mutationString = BreedingTracker.getMutationString(mutation);
        if (!this.researchedMutations.contains(mutationString)) {
            this.researchedMutations.add(mutationString);
            this.func_76185_a();
            this.registerMutation(mutation);
        }
    }

    @Override
    public boolean isResearched(IMutation mutation) {
        String mutationString = BreedingTracker.getMutationString(mutation);
        return this.researchedMutations.contains(mutationString);
    }
}

