/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.fluids.tanks;

import forestry.core.fluids.tanks.StandardTank;
import forestry.core.gui.tooltips.ToolTipLine;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StringUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.item.EnumRarity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FilteredTank
extends StandardTank {
    private final HashSet<Fluid> filters;

    public FilteredTank(int capacity, Fluid ... filters) {
        this(capacity, Arrays.asList(filters), null);
    }

    public FilteredTank(int capacity, Collection<Fluid> filters) {
        this(capacity, filters, null);
    }

    public FilteredTank(int capacity, Collection<Fluid> filters, TileEntity tile) {
        super(capacity, tile);
        this.filters = new HashSet<Fluid>(filters);
    }

    public void addFilter(Fluid filter) {
        if (!this.accepts(filter)) {
            this.filters.add(filter);
        }
    }

    @Override
    public int fill(FluidStack resource, boolean doFill) {
        if (this.liquidMatchesFilter(resource)) {
            return super.fill(resource, doFill);
        }
        return 0;
    }

    @Override
    public boolean accepts(Fluid fluid) {
        return this.filters.contains(fluid);
    }

    private boolean liquidMatchesFilter(FluidStack resource) {
        if (resource == null || this.filters == null) {
            return false;
        }
        return this.filters.contains(resource.getFluid());
    }

    @Override
    protected void refreshTooltip() {
        if (this.hasFluid()) {
            super.refreshTooltip();
            return;
        }
        this.toolTip.clear();
        if (Proxies.common.isShiftDown() || this.filters.size() < 5) {
            for (Fluid filter : this.filters) {
                EnumRarity rarity = filter.getRarity();
                if (rarity == null) {
                    rarity = EnumRarity.common;
                }
                FluidStack filterFluidStack = FluidRegistry.getFluidStack((String)filter.getName(), (int)0);
                ToolTipLine name = new ToolTipLine(filter.getLocalizedName(filterFluidStack), rarity.field_77937_e, 2);
                this.toolTip.add(name);
            }
        } else {
            this.toolTip.add(EnumChatFormatting.ITALIC + "<" + StringUtil.localize("gui.tooltip.tmi") + ">");
        }
        this.toolTip.add(String.format("%,d", this.getFluidAmount()) + " / " + String.format("%,d", this.getCapacity()));
    }
}

