/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.fluids;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import forestry.api.core.INBTTagable;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.Fluids;
import forestry.core.fluids.ITankManager;
import forestry.core.fluids.ITankUpdateHandler;
import forestry.core.fluids.tanks.FakeTank;
import forestry.core.fluids.tanks.StandardTank;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketTankLevelUpdate;
import forestry.core.proxy.Proxies;
import forestry.core.render.EnumTankLevel;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.IRenderableTile;
import forestry.core.utils.NBTUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class TankManager
implements ITankManager,
ITankUpdateHandler,
IStreamable,
INBTTagable {
    private final List<StandardTank> tanks = new ArrayList<StandardTank>();
    private final Table<Container, Integer, FluidStack> prevFluidStacks = HashBasedTable.create();
    private final ILiquidTankTile tile;
    private final List<EnumTankLevel> tankLevels = new ArrayList<EnumTankLevel>();

    public TankManager() {
        this.tile = null;
    }

    public TankManager(ILiquidTankTile tile, StandardTank ... tanks) {
        this.tile = tile;
        this.addAll(Arrays.asList(tanks));
    }

    public final boolean addAll(@Nonnull Collection<? extends StandardTank> collection) {
        boolean addedAll = true;
        for (StandardTank standardTank : collection) {
            addedAll &= this.add(standardTank);
        }
        return addedAll;
    }

    public boolean add(@Nonnull StandardTank tank) {
        boolean added = this.tanks.add(tank);
        int index = this.tanks.indexOf(tank);
        tank.setTankUpdateHandler(this);
        tank.setTankIndex(index);
        this.tankLevels.add(EnumTankLevel.rateTankLevel((IFluidTank)tank));
        return added;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        NBTTagList tagList = new NBTTagList();
        for (byte slot = 0; slot < this.tanks.size(); slot = (byte)((byte)(slot + 1))) {
            StandardTank tank = this.tanks.get(slot);
            if (tank.getFluid() == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("tank", slot);
            tank.writeToNBT(tag);
            tagList.func_74742_a((NBTBase)tag);
        }
        data.func_74782_a("tanks", (NBTBase)tagList);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        NBTUtil.NBTList tagList = NBTUtil.getNBTList(data, "tanks", NBTUtil.EnumNBTType.COMPOUND);
        Iterator i$ = tagList.iterator();
        while (i$.hasNext()) {
            NBTTagCompound tag = (NBTTagCompound)i$.next();
            byte slot = tag.func_74771_c("tank");
            if (slot < 0 || slot >= this.tanks.size()) continue;
            StandardTank tank = this.tanks.get(slot);
            tank.readFromNBT(tag);
            this.updateTankLevels(tank, false);
        }
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        for (StandardTank tank : this.tanks) {
            tank.writeData(data);
        }
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        for (StandardTank tank : this.tanks) {
            tank.readData(data);
        }
    }

    @Override
    public void containerAdded(Container container, ICrafting player) {
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        List<EntityPlayerMP> crafters = Collections.singletonList((EntityPlayerMP)player);
        for (StandardTank tank : this.tanks) {
            this.sendTankUpdate(container, tank, crafters);
        }
    }

    @Override
    public void containerRemoved(Container container) {
        for (StandardTank tank : this.tanks) {
            this.prevFluidStacks.remove((Object)container, (Object)tank.getTankIndex());
        }
    }

    @Override
    public void updateGuiData(Container container, List<EntityPlayerMP> crafters) {
        for (StandardTank tank : this.tanks) {
            this.updateGuiData(container, crafters, tank.getTankIndex());
        }
    }

    private void updateGuiData(Container container, List<EntityPlayerMP> crafters, int tankIndex) {
        FluidStack prev;
        StandardTank tank = this.tanks.get(tankIndex);
        if (tank == null) {
            return;
        }
        FluidStack fluidStack = tank.getFluid();
        if (FluidHelper.areFluidStacksEqual(fluidStack, prev = (FluidStack)this.prevFluidStacks.get((Object)container, (Object)tankIndex))) {
            return;
        }
        this.sendTankUpdate(container, tank, crafters);
    }

    private void sendTankUpdate(Container container, StandardTank tank, Iterable<EntityPlayerMP> crafters) {
        int tankIndex = tank.getTankIndex();
        FluidStack fluid = tank.getFluid();
        PacketTankLevelUpdate packet = new PacketTankLevelUpdate(this.tile, tankIndex, fluid);
        for (EntityPlayerMP player : crafters) {
            Proxies.net.sendToPlayer(packet, (EntityPlayer)player);
        }
        if (fluid == null) {
            this.prevFluidStacks.remove((Object)container, (Object)tankIndex);
        } else {
            this.prevFluidStacks.put((Object)container, (Object)tankIndex, (Object)fluid.copy());
        }
    }

    @Override
    public void processTankUpdate(int tankIndex, FluidStack contents) {
        if (tankIndex < 0 || tankIndex > this.tanks.size()) {
            return;
        }
        StandardTank tank = this.tanks.get(tankIndex);
        tank.setFluid(contents);
    }

    @Override
    public IFluidTank getTank(int tankIndex) {
        return (IFluidTank)this.tanks.get(tankIndex);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        for (StandardTank tank : this.tanks) {
            if (!TankManager.tankAcceptsFluid(tank, resource)) continue;
            return this.fill(tank.getTankIndex(), resource, doFill);
        }
        return FakeTank.INSTANCE.fill(resource, doFill);
    }

    public int fill(int tankIndex, FluidStack resource, boolean doFill) {
        if (tankIndex < 0 || tankIndex >= this.tanks.size() || resource == null) {
            return 0;
        }
        StandardTank tank = this.tanks.get(tankIndex);
        if (!tank.canBeFilledExternally()) {
            return 0;
        }
        return tank.fill(resource, doFill);
    }

    @Override
    public void updateTankLevels(StandardTank tank) {
        this.updateTankLevels(tank, true);
    }

    private void updateTankLevels(StandardTank tank, boolean sendUpdate) {
        if (!(this.tile instanceof IRenderableTile)) {
            return;
        }
        int tankIndex = tank.getTankIndex();
        EnumTankLevel tankLevel = EnumTankLevel.rateTankLevel((IFluidTank)tank);
        if (tankLevel != this.tankLevels.get(tankIndex)) {
            this.tankLevels.set(tankIndex, tankLevel);
            if (sendUpdate) {
                PacketTankLevelUpdate tankLevelUpdate = new PacketTankLevelUpdate(this.tile, tankIndex, tank.getFluid());
                Proxies.net.sendNetworkPacket(tankLevelUpdate, this.tile.getWorld());
            }
        }
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        for (StandardTank tank : this.tanks) {
            if (!TankManager.tankCanDrain(tank)) continue;
            return this.drain(tank.getTankIndex(), maxDrain, doDrain);
        }
        return FakeTank.INSTANCE.drain(maxDrain, doDrain);
    }

    public FluidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        if (tankIndex < 0 || tankIndex >= this.tanks.size()) {
            return null;
        }
        StandardTank tank = this.tanks.get(tankIndex);
        if (!tank.canBeDrainedExternally()) {
            return null;
        }
        return tank.drain(maxDrain, doDrain);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        for (StandardTank tank : this.tanks) {
            if (!TankManager.tankCanDrainFluid(tank, resource)) continue;
            return this.drain(tank.getTankIndex(), resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.drain(resource, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection direction) {
        FluidTankInfo[] info = new FluidTankInfo[this.tanks.size()];
        for (int i = 0; i < this.tanks.size(); ++i) {
            info[i] = this.tanks.get(i).getInfo();
        }
        return info;
    }

    public FluidTankInfo[] getTankInfo() {
        return this.getTankInfo(ForgeDirection.UNKNOWN);
    }

    public FluidTankInfo getTankInfo(int tankIndex) {
        return this.tanks.get(tankIndex).getInfo();
    }

    public FluidStack getFluid(int tankIndex) {
        return this.tanks.get(tankIndex).getFluid();
    }

    public int getFluidAmount(int tankIndex) {
        return this.tanks.get(tankIndex).getFluidAmount();
    }

    public boolean accepts(Fluid fluid) {
        if (fluid == null) {
            return false;
        }
        for (StandardTank tank : this.tanks) {
            if (!tank.accepts(fluid)) continue;
            return true;
        }
        return false;
    }

    private static boolean tankAcceptsFluid(StandardTank tank, FluidStack fluidStack) {
        if (fluidStack == null) {
            return false;
        }
        if (!tank.canBeFilledExternally()) {
            return false;
        }
        return tank.fill(fluidStack, false) > 0;
    }

    private static boolean tankCanDrain(StandardTank tank) {
        if (!tank.canBeDrainedExternally()) {
            return false;
        }
        FluidStack drained = tank.drain(1, false);
        return drained != null && drained.amount > 0;
    }

    private static boolean tankCanDrainFluid(StandardTank tank, FluidStack fluidStack) {
        if (fluidStack == null) {
            return false;
        }
        if (!Fluids.areEqual(tank.getFluidType(), fluidStack)) {
            return false;
        }
        return TankManager.tankCanDrain(tank);
    }
}

