/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.fluids;

import forestry.core.config.ForestryItem;
import forestry.core.fluids.Fluids;
import forestry.core.items.ItemLiquidContainer;
import forestry.core.utils.Log;
import java.util.EnumMap;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class LiquidRegistryHelper {
    private static final EnumMap<ItemLiquidContainer.EnumContainerType, ForestryItem> emptyContainers = new EnumMap(ItemLiquidContainer.EnumContainerType.class);

    public static void registerLiquidContainer(Fluids fluid, ItemStack filled) {
        Item item = filled.func_77973_b();
        ItemStack empty = null;
        if (item.func_77668_q() instanceof ItemBucket) {
            empty = new ItemStack(Items.field_151133_ar);
        } else if (item instanceof ItemLiquidContainer) {
            ItemLiquidContainer liquidContainer = (ItemLiquidContainer)item;
            ItemLiquidContainer.EnumContainerType containerType = liquidContainer.getType();
            ForestryItem emptyContainer = emptyContainers.get((Object)containerType);
            empty = emptyContainer.getItemStack();
        }
        if (empty == null) {
            Log.warning("Unable to inject liquid container: " + filled);
        } else {
            LiquidRegistryHelper.registerLiquidContainer(fluid, 1000, filled, empty);
        }
    }

    public static void registerLiquidContainer(Fluids fluid, int volume, ItemStack filled, ItemStack empty) {
        FluidStack contained = fluid.getFluid(volume);
        if (contained == null) {
            throw new IllegalArgumentException(String.format("Attempted to inject a liquid container for the non-existent liquid '%s'.", new Object[]{fluid}));
        }
        FluidContainerRegistry.FluidContainerData container = new FluidContainerRegistry.FluidContainerData(contained, filled, empty);
        FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)container);
    }

    static {
        emptyContainers.put(ItemLiquidContainer.EnumContainerType.CAN, ForestryItem.canEmpty);
        emptyContainers.put(ItemLiquidContainer.EnumContainerType.CAPSULE, ForestryItem.waxCapsule);
        emptyContainers.put(ItemLiquidContainer.EnumContainerType.REFRACTORY, ForestryItem.refractoryEmpty);
    }
}

