/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.circuits;

import com.google.common.collect.ImmutableSet;
import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.circuits.ISolderManager;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorSource;
import forestry.api.core.IErrorState;
import forestry.core.circuits.CircuitRegistry;
import forestry.core.circuits.EnumCircuitBoardType;
import forestry.core.circuits.ISolderingIron;
import forestry.core.circuits.ItemCircuitBoard;
import forestry.core.errors.EnumErrorCode;
import forestry.core.inventory.ItemInventory;
import forestry.core.items.ItemForestry;
import forestry.core.network.GuiId;
import forestry.core.utils.datastructures.RevolvingList;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemSolderingIron
extends ItemForestry
implements ISolderingIron {
    public ItemSolderingIron() {
        this.func_77625_d(1);
        this.func_77656_e(5);
    }

    public boolean func_77662_d() {
        return true;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (!world.field_72995_K) {
            entityplayer.openGui(ForestryAPI.instance, GuiId.SolderingIronGUI.ordinal(), world, (int)entityplayer.field_70165_t, (int)entityplayer.field_70163_u, (int)entityplayer.field_70161_v);
        }
        return itemstack;
    }

    public static class SolderingInventory
    extends ItemInventory
    implements IErrorSource {
        private final RevolvingList<ICircuitLayout> layouts = new RevolvingList<ICircuitLayout>(ChipsetManager.circuitRegistry.getRegisteredLayouts().values());
        private static final short blankSlot = 0;
        private static final short finishedSlot = 1;
        private static final short ingredientSlot1 = 2;
        private static final short ingredientSlotCount = 4;

        public SolderingInventory(EntityPlayer player, ItemStack itemStack) {
            super(player, 6, itemStack);
            this.layouts.setCurrent(ChipsetManager.circuitRegistry.getDefaultLayout());
        }

        @Override
        public int func_70297_j_() {
            return 1;
        }

        public ICircuitLayout getLayout() {
            return this.layouts.getCurrent();
        }

        public void setLayout(String uid) {
            this.layouts.setCurrent(ChipsetManager.circuitRegistry.getLayout(uid));
        }

        public void advanceLayout() {
            this.layouts.rotateRight();
        }

        public void regressLayout() {
            this.layouts.rotateLeft();
        }

        private ICircuit[] getCircuits(boolean doConsume) {
            ICircuit[] circuits = new ICircuit[4];
            for (int i = 0; i < 4; i = (int)((short)(i + 1))) {
                CircuitRecipe recipe;
                ItemStack ingredient = this.func_70301_a(2 + i);
                if (ingredient == null || (recipe = SolderManager.getMatchingRecipe(this.layouts.getCurrent(), ingredient)) == null || SolderingInventory.getCount(recipe.circuit, circuits) >= recipe.circuit.getLimit()) continue;
                if (doConsume) {
                    this.func_70298_a(2 + i, ((CircuitRecipe)recipe).resource.field_77994_a);
                }
                circuits[i] = recipe.circuit;
            }
            return circuits;
        }

        @Override
        public void onSlotClick(EntityPlayer player) {
            if (this.layouts.getCurrent() == CircuitRegistry.DUMMY_LAYOUT) {
                return;
            }
            ItemStack blank = this.func_70301_a(0);
            if (blank == null) {
                return;
            }
            if (blank.field_77994_a > 1) {
                return;
            }
            if (this.func_70301_a(1) != null) {
                return;
            }
            if (!ChipsetManager.circuitRegistry.isChipset(blank)) {
                return;
            }
            if (blank.func_77960_j() < 0 || blank.func_77960_j() >= EnumCircuitBoardType.values().length) {
                return;
            }
            EnumCircuitBoardType type = EnumCircuitBoardType.values()[blank.func_77960_j()];
            if (this.getCircuitCount() != type.sockets) {
                return;
            }
            ICircuit[] circuits = this.getCircuits(true);
            ItemStack circuitBoard = ItemCircuitBoard.createCircuitboard(type, this.layouts.getCurrent(), circuits);
            this.func_70299_a(1, circuitBoard);
            this.func_70299_a(0, null);
        }

        private int getCircuitCount() {
            ICircuit[] circuits = this.getCircuits(false);
            int count = 0;
            for (ICircuit circuit : circuits) {
                if (circuit == null) continue;
                ++count;
            }
            return count;
        }

        public static int getCount(ICircuit circuit, ICircuit[] circuits) {
            int count = 0;
            for (ICircuit other : circuits) {
                if (other == null || !other.getUID().equals(circuit.getUID())) continue;
                ++count;
            }
            return count;
        }

        @Override
        public ImmutableSet<IErrorState> getErrorStates() {
            ItemStack blankCircuitBoard;
            ImmutableSet.Builder errorStates = ImmutableSet.builder();
            if (this.layouts.getCurrent() == CircuitRegistry.DUMMY_LAYOUT) {
                errorStates.add((Object)EnumErrorCode.NOCIRCUITLAYOUT);
            }
            if ((blankCircuitBoard = this.func_70301_a(0)) == null) {
                errorStates.add((Object)EnumErrorCode.NOCIRCUITBOARD);
            } else {
                EnumCircuitBoardType type = EnumCircuitBoardType.values()[blankCircuitBoard.func_77960_j()];
                int circuitCount = 0;
                for (short i = 0; i < type.sockets; i = (short)(i + 1)) {
                    if (this.func_70301_a(2 + i) == null) continue;
                    ++circuitCount;
                }
                if (circuitCount != type.sockets) {
                    errorStates.add((Object)EnumErrorCode.CIRCUITMISMATCH);
                } else {
                    int count = this.getCircuitCount();
                    if (count != type.sockets) {
                        errorStates.add((Object)EnumErrorCode.NOCIRCUITLAYOUT);
                    }
                }
            }
            return errorStates.build();
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (itemStack == null) {
                return false;
            }
            Item item = itemStack.func_77973_b();
            if (slotIndex == 0) {
                return item instanceof ItemCircuitBoard;
            }
            if (slotIndex >= 2 && slotIndex < 6) {
                CircuitRecipe recipe = SolderManager.getMatchingRecipe(this.layouts.getCurrent(), itemStack);
                return recipe != null;
            }
            return false;
        }
    }

    public static class SolderManager
    implements ISolderManager {
        public static final ArrayList<CircuitRecipe> recipes = new ArrayList();

        @Override
        public void addRecipe(ICircuitLayout layout, ItemStack resource, ICircuit circuit) {
            if (layout == null) {
                throw new IllegalArgumentException("layout may not be null");
            }
            if (resource == null) {
                throw new IllegalArgumentException("resource may not be null");
            }
            if (circuit == null) {
                throw new IllegalArgumentException("circuit may not be null");
            }
            recipes.add(new CircuitRecipe(layout, resource, circuit));
        }

        public static ICircuit getCircuit(ICircuitLayout layout, ItemStack resource) {
            CircuitRecipe circuitRecipe = SolderManager.getMatchingRecipe(layout, resource);
            if (circuitRecipe == null) {
                return null;
            }
            return circuitRecipe.circuit;
        }

        public static CircuitRecipe getMatchingRecipe(ICircuitLayout layout, ItemStack resource) {
            if (layout == null || resource == null) {
                return null;
            }
            for (CircuitRecipe recipe : recipes) {
                if (!recipe.matches(layout, resource)) continue;
                return recipe;
            }
            return null;
        }
    }

    public static class CircuitRecipe {
        private final ICircuitLayout layout;
        private final ItemStack resource;
        public final ICircuit circuit;

        public CircuitRecipe(ICircuitLayout layout, ItemStack resource, ICircuit circuit) {
            this.resource = resource;
            this.layout = layout;
            this.circuit = circuit;
        }

        public boolean matches(ICircuitLayout layout, ItemStack itemstack) {
            if (!this.layout.getUID().equals(layout.getUID())) {
                return false;
            }
            return itemstack.func_77969_a(this.resource);
        }
    }
}

