/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.circuits;

import forestry.api.circuits.CircuitSocketType;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.circuits.ICircuitSocketType;
import forestry.api.farming.FarmDirection;
import forestry.core.circuits.ContainerSolderingIron;
import forestry.core.circuits.ItemSolderingIron;
import forestry.core.gui.GuiForestry;
import forestry.core.utils.StringUtil;
import java.util.Locale;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class GuiSolderingIron
extends GuiForestry<ContainerSolderingIron, ItemSolderingIron.SolderingInventory> {
    public GuiSolderingIron(EntityPlayer player, ItemSolderingIron.SolderingInventory inventory) {
        super("textures/gui/solder.png", new ContainerSolderingIron(player, inventory), inventory);
        this.field_146999_f = 176;
        this.field_147000_g = 205;
    }

    @Override
    protected void func_146976_a(float var1, int mouseX, int mouseY) {
        super.func_146976_a(var1, mouseX, mouseY);
        ICircuitLayout layout = ((ContainerSolderingIron)this.field_147002_h).getLayout();
        String title = layout.getName();
        this.field_146289_q.func_78276_b(title, this.field_147003_i + 8 + this.getCenteredOffset(title, 138), this.field_147009_r + 16, this.fontColor.get("gui.screen"));
        for (int i = 0; i < 4; ++i) {
            ItemStack tube = ((ItemSolderingIron.SolderingInventory)this.inventory).func_70301_a(i + 2);
            ItemSolderingIron.CircuitRecipe recipe = ItemSolderingIron.SolderManager.getMatchingRecipe(layout, tube);
            String description = recipe == null ? "(" + StringUtil.localize("gui.noeffect") + ")" : StringUtil.localize(recipe.circuit.getName()) + " (" + recipe.circuit.getLimit() + ")";
            int row = i * 20;
            this.field_146289_q.func_78276_b(description, this.field_147003_i + 32, this.field_147009_r + 36 + row, this.fontColor.get("gui.screen"));
            if (tube != null) continue;
            try {
                ICircuitSocketType socketType = layout.getSocketType();
                if (!CircuitSocketType.FARM.equals(socketType)) continue;
                FarmDirection farmDirection = FarmDirection.values()[i];
                String farmDirectionString = farmDirection.toString().toLowerCase(Locale.ENGLISH);
                String localizedDirection = StringUtil.localize("gui.solder." + farmDirectionString);
                this.field_146289_q.func_78276_b(localizedDirection, this.field_147003_i + 17, this.field_147009_r + 36 + row, this.fontColor.get("gui.screen"));
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new GuiButton(1, this.field_147003_i + 12, this.field_147009_r + 10, 12, 18, "<"));
        this.field_146292_n.add(new GuiButton(2, this.field_147003_i + 130, this.field_147009_r + 10, 12, 18, ">"));
    }

    protected void func_146284_a(GuiButton guibutton) {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == 1) {
            ContainerSolderingIron.regressSelection(0);
        } else if (guibutton.field_146127_k == 2) {
            ContainerSolderingIron.advanceSelection(0);
        }
    }
}

