/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.blocks;

import forestry.core.blocks.BlockForestry;
import forestry.core.circuits.ISocketable;
import forestry.core.multiblock.MultiblockControllerBase;
import forestry.core.multiblock.MultiblockTileEntityBase;
import forestry.core.multiblock.MultiblockValidationException;
import forestry.core.utils.InventoryUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public abstract class BlockStructure
extends BlockForestry {
    private long previousMessageTick = 0L;

    protected BlockStructure(Material material) {
        super(material);
        this.func_149711_c(1.0f);
    }

    public boolean func_149700_E() {
        return false;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (player.func_70093_af()) {
            return false;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof MultiblockTileEntityBase)) {
            return false;
        }
        MultiblockTileEntityBase part = (MultiblockTileEntityBase)tile;
        MultiblockControllerBase controller = part.getMultiblockController();
        if (player.func_71045_bC() == null && !controller.isAssembled()) {
            if (controller != null) {
                MultiblockValidationException e = controller.getLastValidationException();
                if (e != null) {
                    long tick = world.func_82737_E();
                    if (tick > this.previousMessageTick + 20L) {
                        player.func_145747_a((IChatComponent)new ChatComponentText(e.getMessage()));
                        this.previousMessageTick = tick;
                    }
                    return true;
                }
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"for.multiblock.error.notConnected")));
                return true;
            }
        }
        if (controller == null || !controller.isAssembled()) {
            return false;
        }
        if (!world.field_72995_K) {
            part.openGui(player);
        }
        return true;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        MultiblockTileEntityBase part;
        if (world.field_72995_K) {
            return;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof MultiblockTileEntityBase && (part = (MultiblockTileEntityBase)tile).getNeighboringParts().length == 0) {
            InventoryUtil.dropInventory((IInventory)part, world, x, y, z);
            if (tile instanceof ISocketable) {
                InventoryUtil.dropSockets((ISocketable)tile, tile.func_145831_w(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
            }
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }
}

