/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.tiles;

import forestry.api.arboriculture.EnumWoodType;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketTileStream;
import forestry.core.tiles.TileUtil;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileWood
extends TileEntity
implements IStreamable {
    private EnumWoodType woodType = EnumWoodType.LARCH;

    public void setWoodType(EnumWoodType woodType) {
        this.woodType = woodType;
        this.func_70296_d();
    }

    public EnumWoodType getWoodType() {
        return this.woodType;
    }

    public boolean canUpdate() {
        return false;
    }

    public Packet func_145844_m() {
        return new PacketTileStream(this).getPacket();
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        data.writeVarInt(this.woodType.ordinal());
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        int ordinal = data.readVarInt();
        this.woodType = EnumWoodType.VALUES[ordinal];
        this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.woodType != null) {
            nbt.func_74768_a("WT", this.woodType.ordinal());
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("WT")) {
            int ordinal = nbt.func_74762_e("WT");
            this.woodType = EnumWoodType.VALUES[ordinal];
        }
    }

    public static NBTTagCompound getTagCompound(IBlockAccess world, int x, int y, int z) {
        TileWood wood = TileWood.getWoodTile(world, x, y, z);
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        if (wood == null) {
            return nbttagcompound;
        }
        EnumWoodType woodType = wood.getWoodType();
        woodType.saveToCompound(nbttagcompound);
        return nbttagcompound;
    }

    public static TileWood getWoodTile(IBlockAccess world, int x, int y, int z) {
        return TileUtil.getTile(world, x, y, z, TileWood.class);
    }

    public static <T extends Block> ArrayList<ItemStack> getDrops(T block, World world, int x, int y, int z) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        TileWood wood = TileWood.getWoodTile((IBlockAccess)world, x, y, z);
        if (wood != null) {
            ItemStack stack = new ItemStack(block);
            NBTTagCompound compound = new NBTTagCompound();
            wood.getWoodType().saveToCompound(compound);
            stack.func_77982_d(compound);
            drops.add(stack);
        }
        return drops;
    }
}

