/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.arboriculture.EnumWoodType;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.blocks.BlockLog;
import forestry.arboriculture.render.IconProviderWood;
import forestry.arboriculture.tiles.TileWood;
import forestry.core.items.ItemBlockForestry;
import forestry.core.utils.StringUtil;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemBlockWood
extends ItemBlockForestry {
    public ItemBlockWood(Block block) {
        super(block);
    }

    public static boolean placeWood(ItemStack stack, @Nullable EntityPlayer player, World world, int x, int y, int z, int metadata) {
        EnumWoodType woodType = EnumWoodType.getFromCompound(stack.func_77978_p());
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        boolean placed = world.func_147465_d(x, y, z, block, metadata, 3);
        if (!placed) {
            return false;
        }
        Block worldBlock = world.func_147439_a(x, y, z);
        if (!Block.func_149680_a((Block)block, (Block)worldBlock)) {
            return false;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof TileWood)) {
            world.func_147468_f(x, y, z);
            return false;
        }
        if (player != null) {
            worldBlock.func_149689_a(world, x, y, z, (EntityLivingBase)player, stack);
            worldBlock.func_149714_e(world, x, y, z, metadata);
        }
        ((TileWood)tile).setWoodType(woodType);
        return true;
    }

    @Override
    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        return ItemBlockWood.placeWood(stack, player, world, x, y, z, metadata);
    }

    public String func_77653_i(ItemStack itemstack) {
        String displayName;
        Block block = this.getBlock();
        if (!(block instanceof IWoodTyped)) {
            return super.func_77653_i(itemstack);
        }
        EnumWoodType woodType = EnumWoodType.getFromCompound(itemstack.func_77978_p());
        if (woodType == null) {
            return super.func_77653_i(itemstack);
        }
        IWoodTyped wood = (IWoodTyped)block;
        String blockKind = wood.getBlockKind();
        String customUnlocalizedName = blockKind + "." + woodType.ordinal() + ".name";
        if (StringUtil.canTranslateTile(customUnlocalizedName)) {
            displayName = StringUtil.localizeTile(customUnlocalizedName);
        } else {
            String woodGrammar = StringUtil.localize(blockKind + ".grammar");
            String woodTypeName = StringUtil.localize("trees.woodType." + (Object)((Object)woodType));
            displayName = woodGrammar.replaceAll("%TYPE", woodTypeName);
        }
        if (wood.isFireproof()) {
            displayName = StringUtil.localizeAndFormatRaw("tile.for.fireproof", displayName);
        }
        return displayName;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        EnumWoodType woodType = EnumWoodType.getFromCompound(stack.func_77978_p());
        if (woodType == null) {
            return super.getIcon(stack, pass);
        }
        if (this.getBlock() instanceof BlockLog) {
            return IconProviderWood.getBarkIcon(woodType);
        }
        return IconProviderWood.getPlankIcon(woodType);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        return this.getIcon(stack, 0);
    }
}

