/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.arboriculture.EnumWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.Tabs;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.render.IconProviderWood;
import forestry.arboriculture.tiles.TileWood;
import forestry.core.render.ParticleHelper;
import forestry.plugins.PluginArboriculture;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockArbFence
extends BlockFence
implements IWoodTyped,
ITileEntityProvider {
    private final ParticleHelper.Callback particleCallback;
    private final boolean fireproof;
    private final ThreadLocal<ArrayList<ItemStack>> drops = new ThreadLocal();

    public BlockArbFence(boolean fireproof) {
        super("", Material.field_151575_d);
        this.fireproof = fireproof;
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.setHarvestLevel("axe", 0);
        this.func_149672_a(field_149766_f);
        this.func_149647_a(Tabs.tabArboriculture);
        this.particleCallback = new ParticleHelper.DefaultCallback((Block)this);
    }

    public void func_149666_a(Item item, CreativeTabs par2CreativeTabs, List list) {
        for (EnumWoodType woodType : EnumWoodType.VALUES) {
            list.add(TreeManager.woodItemAccess.getFence(woodType, this.fireproof));
        }
    }

    public boolean canPlaceTorchOnTop(World world, int x, int y, int z) {
        return true;
    }

    public boolean func_149826_e(IBlockAccess world, int x, int y, int z) {
        if (!BlockArbFence.isFence(world, x, y, z)) {
            Block block = world.func_147439_a(x, y, z);
            if (block == this || block instanceof BlockFenceGate) {
                return true;
            }
            return block.func_149688_o().func_76218_k() && block.func_149686_d() && block.func_149688_o() != Material.field_151572_C;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        IconProviderWood.registerIcons(register);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return IconProviderWood.getPlankIcon(EnumWoodType.LARCH);
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileWood wood = TileWood.getWoodTile(world, x, y, z);
        EnumWoodType woodType = wood.getWoodType();
        return IconProviderWood.getPlankIcon(woodType);
    }

    private static boolean isFence(IBlockAccess world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return PluginArboriculture.validFences.contains(block);
    }

    public final TileEntity func_149915_a(World world, int meta) {
        return new TileWood();
    }

    public final ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        ItemStack itemStack = new ItemStack((Block)this);
        NBTTagCompound nbt = TileWood.getTagCompound((IBlockAccess)world, x, y, z);
        itemStack.func_77982_d(nbt);
        return itemStack;
    }

    public void func_149681_a(World world, int x, int y, int z, int meta, EntityPlayer playerProfile) {
        this.drops.set(TileWood.getDrops(this, world, x, y, z));
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = this.drops.get();
        this.drops.remove();
        if (ret == null) {
            ret = TileWood.getDrops(this, world, x, y, z);
        }
        return ret;
    }

    public final float func_149712_f(World world, int x, int y, int z) {
        TileWood wood = TileWood.getWoodTile((IBlockAccess)world, x, y, z);
        if (wood == null) {
            return 2.0f;
        }
        return wood.getWoodType().getHardness();
    }

    public final boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return !this.isFireproof();
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.isFireproof() ? 0 : 20;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.isFireproof() ? 0 : 5;
    }

    @Override
    public String getBlockKind() {
        return "fences";
    }

    @Override
    public boolean isFireproof() {
        return this.fireproof;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        return ParticleHelper.addHitEffects(worldObj, (Block)this, target, effectRenderer, this.particleCallback);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World worldObj, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        return ParticleHelper.addDestroyEffects(worldObj, (Block)this, x, y, z, meta, effectRenderer, this.particleCallback);
    }
}

