/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.alleles;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.alleles.AlleleEffectThrottled;
import forestry.core.utils.EntityUtil;
import forestry.core.utils.ItemStackUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;

public class AlleleEffectResurrection
extends AlleleEffectThrottled {
    private final List<Resurrectable> resurrectables;

    public static List<Resurrectable> getReanimationList() {
        ArrayList<Resurrectable> list = new ArrayList<Resurrectable>();
        list.add(new Resurrectable(new ItemStack(Items.field_151103_aS), EntitySkeleton.class));
        list.add(new Resurrectable(new ItemStack(Items.field_151032_g), EntitySkeleton.class));
        list.add(new Resurrectable(new ItemStack(Items.field_151078_bh), EntityZombie.class));
        list.add(new Resurrectable(new ItemStack(Items.field_151072_bj), EntityBlaze.class));
        return list;
    }

    public static List<Resurrectable> getResurrectionList() {
        ArrayList<Resurrectable> list = new ArrayList<Resurrectable>();
        list.add(new Resurrectable(new ItemStack(Items.field_151016_H), EntityCreeper.class));
        list.add(new Resurrectable(new ItemStack(Items.field_151079_bi), EntityEnderman.class));
        list.add(new Resurrectable(new ItemStack(Items.field_151007_F), EntitySpider.class));
        list.add(new Resurrectable(new ItemStack(Items.field_151070_bp), EntitySpider.class));
        list.add(new Resurrectable(new ItemStack(Items.field_151007_F), EntityCaveSpider.class));
        list.add(new Resurrectable(new ItemStack(Items.field_151070_bp), EntityCaveSpider.class));
        list.add(new Resurrectable(new ItemStack(Items.field_151073_bk), EntityGhast.class));
        list.add(new Resurrectable(new ItemStack(Blocks.field_150380_bt), EntityDragon.class));
        return list;
    }

    public AlleleEffectResurrection(String name, List<Resurrectable> resurrectables) {
        super(name, true, 40, true, true);
        this.resurrectables = resurrectables;
    }

    @Override
    public IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        AxisAlignedBB bounding = this.getBounding(genome, housing);
        List list = housing.getWorld().func_72872_a(EntityItem.class, bounding);
        if (list.size() > 0) {
            Collections.shuffle(this.resurrectables);
        }
        block0: for (Object obj : list) {
            EntityItem item = (EntityItem)obj;
            if (item.field_70128_L) continue;
            ItemStack contained = item.func_92059_d();
            for (Resurrectable entry : this.resurrectables) {
                if (!ItemStackUtil.isIdenticalItem(entry.res, contained)) continue;
                EntityUtil.spawnEntity(housing.getWorld(), entry.risen, item.field_70165_t, item.field_70163_u, item.field_70161_v);
                --contained.field_77994_a;
                if (contained.field_77994_a > 0) continue block0;
                item.func_70106_y();
                continue block0;
            }
        }
        return storedData;
    }

    public static class Resurrectable {
        public final ItemStack res;
        public final Class<? extends EntityLiving> risen;

        public Resurrectable(ItemStack res, Class<? extends EntityLiving> risen) {
            this.res = res;
            this.risen = risen;
        }
    }
}

