/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.renderer;

import com.carpentersblocks.data.Ladder;
import com.carpentersblocks.renderer.BlockHandlerBase;
import com.carpentersblocks.tileentity.TEBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@SideOnly(value=Side.CLIENT)
public class BlockHandlerCarpentersLadder
extends BlockHandlerBase {
    private Ladder data = new Ladder();
    private ItemStack iron = new ItemStack(Blocks.field_150339_S);
    private ForgeDirection dir;

    @Override
    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderBlocks) {
        renderBlocks.func_147782_a(0.0, 0.0, 0.375, 0.125, 1.0, 0.625);
        super.renderInventoryBlock(block, metadata, modelID, renderBlocks);
        renderBlocks.func_147782_a(0.875, 0.0, 0.375, 1.0, 1.0, 0.625);
        super.renderInventoryBlock(block, metadata, modelID, renderBlocks);
        renderBlocks.func_147782_a(0.125, 0.125, 0.4375, 0.875, 0.1875, 0.5625);
        super.renderInventoryBlock(block, metadata, modelID, renderBlocks);
        renderBlocks.func_147782_a(0.125, 0.375, 0.4375, 0.875, 0.4375, 0.5625);
        super.renderInventoryBlock(block, metadata, modelID, renderBlocks);
        renderBlocks.func_147782_a(0.125, 0.625, 0.4375, 0.875, 0.6875, 0.5625);
        super.renderInventoryBlock(block, metadata, modelID, renderBlocks);
        renderBlocks.func_147782_a(0.125, 0.875, 0.4375, 0.875, 0.9375, 0.5625);
        super.renderInventoryBlock(block, metadata, modelID, renderBlocks);
    }

    @Override
    protected void renderCarpentersBlock(int x, int y, int z) {
        this.renderBlocks.field_147837_f = true;
        ItemStack itemStack = this.getCoverForRendering(new TEBase[0]);
        this.dir = this.data.getDirection(this.TE);
        switch (this.data.getType(this.TE)) {
            case 0: {
                this.renderTypeDefaultClassic(itemStack, x, y, z);
                break;
            }
            case 1: {
                this.renderTypeRail(itemStack, x, y, z);
                break;
            }
            case 2: {
                this.renderTypePole(itemStack, x, y, z);
            }
        }
        this.renderBlocks.field_147837_f = false;
    }

    public void renderTypeDefaultClassic(ItemStack itemStack, int x, int y, int z) {
        double xLow = 0.0;
        double xHigh = 1.0;
        double zLow = 0.0;
        double zHigh = 1.0;
        World world = this.TE.func_145831_w();
        boolean connects_XN = world.func_147439_a(x - 1, y, z).equals(this.srcBlock) && this.data.getDirection((TEBase)world.func_147438_o(x - 1, y, z)).equals((Object)this.dir);
        boolean connects_XP = world.func_147439_a(x + 1, y, z).equals(this.srcBlock) && this.data.getDirection((TEBase)world.func_147438_o(x + 1, y, z)).equals((Object)this.dir);
        boolean connects_ZN = world.func_147439_a(x, y, z - 1).equals(this.srcBlock) && this.data.getDirection((TEBase)world.func_147438_o(x, y, z - 1)).equals((Object)this.dir);
        boolean connects_ZP = world.func_147439_a(x, y, z + 1).equals(this.srcBlock) && this.data.getDirection((TEBase)world.func_147438_o(x, y, z + 1)).equals((Object)this.dir);
        switch (this.dir) {
            case DOWN: {
                if (!connects_XN) {
                    this.renderBlocks.func_147782_a(0.0, 0.0, 0.375, 0.125, 1.0, 0.625);
                    this.renderBlock(itemStack, x, y, z);
                }
                if (!connects_XP) {
                    this.renderBlocks.func_147782_a(0.875, 0.0, 0.375, 1.0, 1.0, 0.625);
                    this.renderBlock(itemStack, x, y, z);
                }
                xLow = connects_XN ? 0.0 : 0.125;
                xHigh = connects_XP ? 1.0 : 0.875;
                this.renderBlocks.func_147782_a(xLow, 0.125, 0.4375, xHigh, 0.1875, 0.5625);
                this.renderBlock(itemStack, x, y, z);
                this.renderBlocks.func_147782_a(xLow, 0.375, 0.4375, xHigh, 0.4375, 0.5625);
                this.renderBlock(itemStack, x, y, z);
                this.renderBlocks.func_147782_a(xLow, 0.625, 0.4375, xHigh, 0.6875, 0.5625);
                this.renderBlock(itemStack, x, y, z);
                this.renderBlocks.func_147782_a(xLow, 0.875, 0.4375, xHigh, 0.9375, 0.5625);
                this.renderBlock(itemStack, x, y, z);
                break;
            }
            case UP: {
                if (!connects_ZN) {
                    this.renderBlocks.func_147782_a(0.375, 0.0, 0.0, 0.625, 1.0, 0.125);
                    this.renderBlock(itemStack, x, y, z);
                }
                if (!connects_ZP) {
                    this.renderBlocks.func_147782_a(0.375, 0.0, 0.875, 0.625, 1.0, 1.0);
                    this.renderBlock(itemStack, x, y, z);
                }
                zLow = connects_ZN ? 0.0 : 0.125;
                zHigh = connects_ZP ? 1.0 : 0.875;
                this.renderBlocks.func_147782_a(0.4375, 0.125, zLow, 0.5625, 0.1875, zHigh);
                this.renderBlock(itemStack, x, y, z);
                this.renderBlocks.func_147782_a(0.4375, 0.375, zLow, 0.5625, 0.4375, zHigh);
                this.renderBlock(itemStack, x, y, z);
                this.renderBlocks.func_147782_a(0.4375, 0.625, zLow, 0.5625, 0.6875, zHigh);
                this.renderBlock(itemStack, x, y, z);
                this.renderBlocks.func_147782_a(0.4375, 0.875, zLow, 0.5625, 0.9375, zHigh);
                this.renderBlock(itemStack, x, y, z);
                break;
            }
            case NORTH: {
                if (!connects_XN) {
                    this.renderBlocks.func_147782_a(0.0, 0.0, 0.8125, 0.125, 1.0, 1.0);
                    this.renderBlock(itemStack, x, y, z);
                }
                if (!connects_XP) {
                    this.renderBlocks.func_147782_a(0.875, 0.0, 0.8125, 1.0, 1.0, 1.0);
                    this.renderBlock(itemStack, x, y, z);
                }
                xLow = connects_XN ? 0.0 : 0.125;
                xHigh = connects_XP ? 1.0 : 0.875;
                this.renderBlocks.func_147782_a(xLow, 0.125, 0.875, xHigh, 0.1875, 1.0);
                this.renderBlock(itemStack, x, y, z);
                this.renderBlocks.func_147782_a(xLow, 0.375, 0.875, xHigh, 0.4375, 1.0);
                this.renderBlock(itemStack, x, y, z);
                this.renderBlocks.func_147782_a(xLow, 0.625, 0.875, xHigh, 0.6875, 1.0);
                this.renderBlock(itemStack, x, y, z);
                this.renderBlocks.func_147782_a(xLow, 0.875, 0.875, xHigh, 0.9375, 1.0);
                this.renderBlock(itemStack, x, y, z);
                break;
            }
            case SOUTH: {
                if (!connects_XN) {
                    this.renderBlocks.func_147782_a(0.0, 0.0, 0.0, 0.125, 1.0, 0.1875);
                    this.renderBlock(itemStack, x, y, z);
                }
                if (!connects_XP) {
                    this.renderBlocks.func_147782_a(0.875, 0.0, 0.0, 1.0, 1.0, 0.1875);
                    this.renderBlock(itemStack, x, y, z);
                }
                xLow = connects_XN ? 0.0 : 0.125;
                xHigh = connects_XP ? 1.0 : 0.875;
                this.renderBlocks.func_147782_a(xLow, 0.125, 0.0, xHigh, 0.1875, 0.1875);
                this.renderBlock(itemStack, x, y, z);
                this.renderBlocks.func_147782_a(xLow, 0.375, 0.0, xHigh, 0.4375, 0.1875);
                this.renderBlock(itemStack, x, y, z);
                this.renderBlocks.func_147782_a(xLow, 0.625, 0.0, xHigh, 0.6875, 0.1875);
                this.renderBlock(itemStack, x, y, z);
                this.renderBlocks.func_147782_a(xLow, 0.875, 0.0, xHigh, 0.9375, 0.1875);
                this.renderBlock(itemStack, x, y, z);
                break;
            }
            case WEST: {
                if (!connects_ZN) {
                    this.renderBlocks.func_147782_a(0.8125, 0.0, 0.0, 1.0, 1.0, 0.125);
                    this.renderBlock(itemStack, x, y, z);
                }
                if (!connects_ZP) {
                    this.renderBlocks.func_147782_a(0.8125, 0.0, 0.875, 1.0, 1.0, 1.0);
                    this.renderBlock(itemStack, x, y, z);
                }
                zLow = connects_ZN ? 0.0 : 0.125;
                zHigh = connects_ZP ? 1.0 : 0.875;
                this.renderBlocks.func_147782_a(0.875, 0.125, zLow, 1.0, 0.1875, zHigh);
                this.renderBlock(itemStack, x, y, z);
                this.renderBlocks.func_147782_a(0.875, 0.375, zLow, 1.0, 0.4375, zHigh);
                this.renderBlock(itemStack, x, y, z);
                this.renderBlocks.func_147782_a(0.875, 0.625, zLow, 1.0, 0.6875, zHigh);
                this.renderBlock(itemStack, x, y, z);
                this.renderBlocks.func_147782_a(0.875, 0.875, zLow, 1.0, 0.9375, zHigh);
                this.renderBlock(itemStack, x, y, z);
                break;
            }
            case EAST: {
                if (!connects_ZN) {
                    this.renderBlocks.func_147782_a(0.0, 0.0, 0.0, 0.1875, 1.0, 0.125);
                    this.renderBlock(itemStack, x, y, z);
                }
                if (!connects_ZP) {
                    this.renderBlocks.func_147782_a(0.0, 0.0, 0.875, 0.1875, 1.0, 1.0);
                    this.renderBlock(itemStack, x, y, z);
                }
                zLow = connects_ZN ? 0.0 : 0.125;
                zHigh = connects_ZP ? 1.0 : 0.875;
                this.renderBlocks.func_147782_a(0.0, 0.125, zLow, 0.1875, 0.1875, zHigh);
                this.renderBlock(itemStack, x, y, z);
                this.renderBlocks.func_147782_a(0.0, 0.375, zLow, 0.1875, 0.4375, zHigh);
                this.renderBlock(itemStack, x, y, z);
                this.renderBlocks.func_147782_a(0.0, 0.625, zLow, 0.1875, 0.6875, zHigh);
                this.renderBlock(itemStack, x, y, z);
                this.renderBlocks.func_147782_a(0.0, 0.875, zLow, 0.1875, 0.9375, zHigh);
                this.renderBlock(itemStack, x, y, z);
                break;
            }
        }
    }

    public void renderTypeDefault(ItemStack itemStack, int x, int y, int z) {
        ForgeDirection axisDir = ForgeDirection.SOUTH;
        switch (this.dir) {
            case DOWN: {
                axisDir = ForgeDirection.WEST;
            }
            case UP: {
                this.renderBlockWithRotation(itemStack, x, y, z, 0.375, 0.0, 0.0, 0.625, 1.0, 0.125, axisDir);
                this.renderBlockWithRotation(itemStack, x, y, z, 0.375, 0.0, 0.875, 0.625, 1.0, 1.0, axisDir);
                this.renderBlockWithRotation(itemStack, x, y, z, 0.4375, 0.125, 0.125, 0.5625, 0.1875, 0.875, axisDir);
                this.renderBlockWithRotation(itemStack, x, y, z, 0.4375, 0.375, 0.125, 0.5625, 0.4375, 0.875, axisDir);
                this.renderBlockWithRotation(itemStack, x, y, z, 0.4375, 0.625, 0.125, 0.5625, 0.6875, 0.875, axisDir);
                this.renderBlockWithRotation(itemStack, x, y, z, 0.4375, 0.875, 0.125, 0.5625, 0.9375, 0.875, axisDir);
                break;
            }
            default: {
                this.renderBlockWithRotation(itemStack, x, y, z, 0.0, 0.0, 0.0, 0.125, 1.0, 0.1875, this.dir);
                this.renderBlockWithRotation(itemStack, x, y, z, 0.875, 0.0, 0.0, 1.0, 1.0, 0.1875, this.dir);
                this.renderBlockWithRotation(itemStack, x, y, z, 0.125, 0.125, 0.0, 0.875, 0.1875, 0.1875, this.dir);
                this.renderBlockWithRotation(itemStack, x, y, z, 0.125, 0.375, 0.0, 0.875, 0.4375, 0.1875, this.dir);
                this.renderBlockWithRotation(itemStack, x, y, z, 0.125, 0.625, 0.0, 0.875, 0.6875, 0.1875, this.dir);
                this.renderBlockWithRotation(itemStack, x, y, z, 0.125, 0.875, 0.0, 0.875, 0.9375, 0.1875, this.dir);
            }
        }
    }

    public void renderTypeRail(ItemStack itemStack, int x, int y, int z) {
        ForgeDirection axisDir = ForgeDirection.SOUTH;
        switch (this.dir) {
            case DOWN: {
                axisDir = ForgeDirection.WEST;
            }
            case UP: {
                this.renderBlockWithRotation(this.iron, x, y, z, 0.3125, 0.0, 0.1875, 0.375, 1.0, 0.25, axisDir);
                this.renderBlockWithRotation(this.iron, x, y, z, 0.3125, 0.0, 0.1875, 0.375, 1.0, 0.25, axisDir.getOpposite());
                this.renderBlockWithRotation(this.iron, x, y, z, 0.375, 0.0, 0.125, 0.4375, 1.0, 0.25, axisDir);
                this.renderBlockWithRotation(this.iron, x, y, z, 0.375, 0.0, 0.125, 0.4375, 1.0, 0.25, axisDir.getOpposite());
                this.renderBlockWithRotation(this.iron, x, y, z, 0.625, 0.0, 0.1875, 0.6875, 1.0, 0.25, axisDir);
                this.renderBlockWithRotation(this.iron, x, y, z, 0.625, 0.0, 0.1875, 0.6875, 1.0, 0.25, axisDir.getOpposite());
                this.renderBlockWithRotation(this.iron, x, y, z, 0.5625, 0.0, 0.125, 0.625, 1.0, 0.25, axisDir);
                this.renderBlockWithRotation(this.iron, x, y, z, 0.5625, 0.0, 0.125, 0.625, 1.0, 0.25, axisDir.getOpposite());
                this.renderBlockWithRotation(itemStack, x, y, z, 0.4375, 0.125, 0.0, 0.5625, 0.1875, 1.0, axisDir);
                this.renderBlockWithRotation(itemStack, x, y, z, 0.4375, 0.375, 0.0, 0.5625, 0.4375, 1.0, axisDir);
                this.renderBlockWithRotation(itemStack, x, y, z, 0.4375, 0.625, 0.0, 0.5625, 0.6875, 1.0, axisDir);
                this.renderBlockWithRotation(itemStack, x, y, z, 0.4375, 0.875, 0.0, 0.5625, 0.9375, 1.0, axisDir);
                break;
            }
            default: {
                this.renderBlockWithRotation(this.iron, x, y, z, 0.125, 0.0, 0.0625, 0.25, 1.0, 0.125, this.dir);
                this.renderBlockWithRotation(this.iron, x, y, z, 0.1875, 0.0, 0.125, 0.25, 1.0, 0.1875, this.dir);
                this.renderBlockWithRotation(this.iron, x, y, z, 0.75, 0.0, 0.0625, 0.875, 1.0, 0.125, this.dir);
                this.renderBlockWithRotation(this.iron, x, y, z, 0.75, 0.0, 0.125, 0.8125, 1.0, 0.1875, this.dir);
                this.renderBlockWithRotation(itemStack, x, y, z, 0.0, 0.0625, 0.0, 1.0, 0.1875, 0.0625, this.dir);
                this.renderBlockWithRotation(itemStack, x, y, z, 0.0, 0.3125, 0.0, 1.0, 0.4375, 0.0625, this.dir);
                this.renderBlockWithRotation(itemStack, x, y, z, 0.0, 0.5625, 0.0, 1.0, 0.6875, 0.0625, this.dir);
                this.renderBlockWithRotation(itemStack, x, y, z, 0.0, 0.8125, 0.0, 1.0, 0.9375, 0.0625, this.dir);
            }
        }
    }

    public void renderTypePole(ItemStack itemStack, int x, int y, int z) {
        ForgeDirection axisDir = ForgeDirection.SOUTH;
        switch (this.dir) {
            case DOWN: {
                axisDir = ForgeDirection.WEST;
            }
            case UP: {
                this.renderBlockWithRotation(itemStack, x, y, z, 0.375, 0.0, 0.375, 0.625, 1.0, 0.625, new ForgeDirection[0]);
                this.renderBlockWithRotation(itemStack, x, y, z, 0.4375, 0.125, 0.625, 0.5625, 0.1875, 0.9375, axisDir);
                this.renderBlockWithRotation(itemStack, x, y, z, 0.4375, 0.1875, 0.875, 0.5625, 0.25, 0.9375, axisDir);
                this.renderBlockWithRotation(itemStack, x, y, z, 0.4375, 0.75, 0.0625, 0.5625, 0.8125, 0.375, axisDir);
                this.renderBlockWithRotation(itemStack, x, y, z, 0.4375, 0.8125, 0.0625, 0.5625, 0.875, 0.125, axisDir);
                break;
            }
            default: {
                for (double yLow = 0.125; yLow < 1.0; yLow += 0.25) {
                    double yHigh = yLow + 0.0625;
                    this.renderBlockWithRotation(itemStack, x, y, z, 0.125, yLow, 0.0, 0.1875, yHigh, 0.125, this.dir);
                    this.renderBlockWithRotation(itemStack, x, y, z, 0.8125, yLow, 0.0, 0.875, yHigh, 0.125, this.dir);
                    this.renderBlockWithRotation(itemStack, x, y, z, 0.125, yLow, 0.125, 0.875, yHigh, 0.1875, this.dir);
                }
            }
        }
    }
}

