/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.renderer;

import com.carpentersblocks.data.Hatch;
import com.carpentersblocks.renderer.BlockHandlerHinged;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.registry.IconRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

@SideOnly(value=Side.CLIENT)
public class BlockHandlerCarpentersHatch
extends BlockHandlerHinged {
    private ForgeDirection baseDir;
    private boolean isHigh;
    private int type;

    @Override
    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderBlocks) {
        renderBlocks.func_147782_a(0.0, 0.4375, 0.0, 1.0, 0.5625, 1.0);
        super.renderInventoryBlock(block, metadata, modelID, renderBlocks);
        renderBlocks.func_147782_a(0.0625, 0.5625, 0.375, 0.125, 0.625, 0.4375);
        super.renderInventoryBlock(Blocks.field_150339_S, metadata, modelID, renderBlocks);
        renderBlocks.func_147782_a(0.0625, 0.5625, 0.5625, 0.125, 0.625, 0.625);
        super.renderInventoryBlock(Blocks.field_150339_S, metadata, modelID, renderBlocks);
        renderBlocks.func_147782_a(0.0625, 0.625, 0.375, 0.125, 0.6875, 0.625);
        super.renderInventoryBlock(Blocks.field_150339_S, metadata, modelID, renderBlocks);
    }

    @Override
    public void renderCarpentersBlock(int x, int y, int z) {
        this.renderBlocks.field_147837_f = true;
        this.setParams();
        ItemStack itemStack = this.getCoverForRendering(new TEBase[0]);
        switch (this.type) {
            case 1: 
            case 2: {
                this.renderTypeFrame(itemStack, x, y, z);
                break;
            }
            case 3: {
                this.renderTypeFrench(itemStack, x, y, z);
                break;
            }
            case 4: {
                this.renderTypePanel(itemStack, x, y, z);
                break;
            }
            case 0: {
                this.renderTypeHidden(itemStack, x, y, z);
            }
        }
        this.renderBlocks.field_147837_f = false;
    }

    private void setParams() {
        this.type = Hatch.getType(this.TE);
        this.isHigh = Hatch.getPos(this.TE) == 1;
        this.isOpen = Hatch.getState(this.TE) == 1;
        switch (Hatch.getDir(this.TE)) {
            case 0: {
                this.side = this.baseDir = ForgeDirection.SOUTH;
                break;
            }
            case 1: {
                this.side = this.baseDir = ForgeDirection.NORTH;
                break;
            }
            case 2: {
                this.side = this.baseDir = ForgeDirection.EAST;
                break;
            }
            case 3: {
                this.side = this.baseDir = ForgeDirection.WEST;
            }
        }
        if (!this.isOpen) {
            this.side = this.isHigh ? ForgeDirection.UP : ForgeDirection.DOWN;
        }
    }

    private void renderTypeHidden(ItemStack itemStack, int x, int y, int z) {
        this.renderBlockWithRotation(itemStack, x, y, z, 0.0, 0.0, 0.875, 1.0, 1.0, 1.0, this.side);
        this.renderPartHandle(new ItemStack(Blocks.field_150339_S), x, y, z, true, false);
    }

    private void renderPartFrame(ItemStack itemStack, int x, int y, int z) {
        this.renderBlockWithRotation(itemStack, x, y, z, 0.0, 0.0, 0.8125, 0.1875, 1.0, 1.0, this.side);
        this.renderBlockWithRotation(itemStack, x, y, z, 0.1875, 0.8125, 0.8125, 0.8125, 1.0, 1.0, this.side);
        this.renderBlockWithRotation(itemStack, x, y, z, 0.1875, 0.0, 0.8125, 0.8125, 0.1875, 1.0, this.side);
        this.renderBlockWithRotation(itemStack, x, y, z, 0.8125, 0.0, 0.8125, 1.0, 1.0, 1.0, this.side);
    }

    private void renderTypeFrame(ItemStack itemStack, int x, int y, int z) {
        this.renderPartFrame(itemStack, x, y, z);
        this.renderPartPane(this.type == 2 ? IconRegistry.icon_hatch_screen : IconRegistry.icon_hatch_glass, x, y, z);
        this.renderPartHandle(new ItemStack(Blocks.field_150339_S), x, y, z, true, true);
    }

    private void renderTypeFrench(ItemStack itemStack, int x, int y, int z) {
        this.renderBlockWithRotation(itemStack, x, y, z, 0.1875, 0.4375, 0.875, 0.8125, 0.5625, 0.9375, this.side);
        this.renderBlockWithRotation(itemStack, x, y, z, 0.4375, 0.1875, 0.875, 0.5625, 0.4375, 0.9375, this.side);
        this.renderBlockWithRotation(itemStack, x, y, z, 0.4375, 0.5625, 0.875, 0.5625, 0.8125, 0.9375, this.side);
        this.renderPartFrame(itemStack, x, y, z);
        this.renderPartPane(IconRegistry.icon_hatch_french_glass, x, y, z);
        this.renderPartHandle(new ItemStack(Blocks.field_150339_S), x, y, z, true, true);
    }

    private void renderTypePanel(ItemStack itemStack, int x, int y, int z) {
        this.renderBlockWithRotation(itemStack, x, y, z, 0.1875, 0.1875, 0.875, 0.8215, 0.8215, 0.9375, this.side);
        this.renderBlockWithRotation(itemStack, x, y, z, 0.3125, 0.3125, 0.8125, 0.6875, 0.6875, 1.0, this.side);
        this.renderPartFrame(itemStack, x, y, z);
        this.renderPartHandle(new ItemStack(Blocks.field_150339_S), x, y, z, true, true);
    }

    private void renderPartHandle(ItemStack itemStack, int x, int y, int z, boolean renderInterior, boolean renderExterior) {
        double yMax;
        if (!renderInterior && !renderExterior) {
            return;
        }
        this.suppressDyeColor = true;
        this.suppressChiselDesign = true;
        this.suppressOverlay = true;
        double zOffset = Hatch.getType(this.TE) == 0 ? 0.125 : 0.1875;
        double yMin = this.isHigh ? 0.0625 : 0.875;
        double d = yMax = this.isHigh ? 0.125 : 0.9375;
        if (renderInterior) {
            ForgeDirection dir;
            if (this.isOpen) {
                dir = this.side.getOpposite();
                int xTemp = x - dir.offsetX;
                int yTemp = y - dir.offsetY;
                int zTemp = z - dir.offsetZ;
                this.renderBlockWithRotation(itemStack, xTemp, yTemp, zTemp, 0.375, yMin, 0.9375, 0.4375, yMax, 1.0, dir);
                this.renderBlockWithRotation(itemStack, xTemp, yTemp, zTemp, 0.5625, yMin, 0.9375, 0.625, yMax, 1.0, dir);
                this.renderBlockWithRotation(itemStack, xTemp, yTemp, zTemp, 0.375, yMin, 0.875, 0.625, yMax, 0.9375, dir);
            } else {
                dir = this.isHigh ? this.baseDir : this.baseDir.getOpposite();
                this.renderBlockWithRotation(itemStack, x, y, z, 0.375, yMin, 0.9375 - zOffset, 0.4375, yMax, 1.0 - zOffset, this.side, dir);
                this.renderBlockWithRotation(itemStack, x, y, z, 0.5625, yMin, 0.9375 - zOffset, 0.625, yMax, 1.0 - zOffset, this.side, dir);
                this.renderBlockWithRotation(itemStack, x, y, z, 0.375, yMin, 0.875 - zOffset, 0.625, yMax, 0.9375 - zOffset, this.side, dir);
            }
        }
        if (renderExterior) {
            if (this.isOpen) {
                this.renderBlockWithRotation(itemStack, x, y, z, 0.375, yMin, 0.9375 - zOffset, 0.4375, yMax, 1.0 - zOffset, this.baseDir);
                this.renderBlockWithRotation(itemStack, x, y, z, 0.5625, yMin, 0.9375 - zOffset, 0.625, yMax, 1.0 - zOffset, this.baseDir);
                this.renderBlockWithRotation(itemStack, x, y, z, 0.375, yMin, 0.875 - zOffset, 0.625, yMax, 0.9375 - zOffset, this.baseDir);
            } else {
                ForgeDirection dir1 = this.side.getOpposite();
                ForgeDirection dir2 = !this.isHigh ? this.baseDir.getOpposite() : this.baseDir;
                int xTemp = x - dir1.offsetX;
                int yTemp = y - dir1.offsetY;
                int zTemp = z - dir1.offsetZ;
                this.renderBlockWithRotation(itemStack, xTemp, yTemp, zTemp, 0.375, yMin, 0.9375, 0.4375, yMax, 1.0, dir1, dir2);
                this.renderBlockWithRotation(itemStack, xTemp, yTemp, zTemp, 0.5625, yMin, 0.9375, 0.625, yMax, 1.0, dir1, dir2);
                this.renderBlockWithRotation(itemStack, xTemp, yTemp, zTemp, 0.375, yMin, 0.875, 0.625, yMax, 0.9375, dir1, dir2);
            }
        }
        this.suppressDyeColor = false;
        this.suppressChiselDesign = false;
        this.suppressOverlay = false;
    }
}

