/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.data.Barrier;
import com.carpentersblocks.data.Gate;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.registry.BlockRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCarpentersGate
extends BlockCoverable {
    public BlockCarpentersGate(Material material) {
        super(material);
    }

    @Override
    protected boolean onHammerRightClick(TEBase TE, EntityPlayer entityPlayer) {
        int type = Gate.getType(TE);
        if (entityPlayer.func_70093_af()) {
            if (type <= 3 && ++type > 3) {
                type = 0;
            }
        } else if (type <= 3) {
            type = 4;
        } else if (++type > 6) {
            type = 0;
        }
        Gate.setType(TE, type);
        return true;
    }

    @Override
    protected void postOnBlockActivated(TEBase TE, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ, BlockCoverable.ActionResult actionResult) {
        if (Gate.getState(TE) == 1) {
            Gate.setState(TE, 0, true);
            this.cycleNeighborGate(TE, TE.func_145831_w(), TE.field_145851_c, TE.field_145848_d, TE.field_145849_e);
        } else {
            int facing = (MathHelper.func_76128_c((double)((double)(entityPlayer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) % 4;
            Gate.setState(TE, 1, true);
            if (Gate.getFacing(TE) == 0) {
                Gate.setDirOpen(TE, facing == 0 ? 0 : 1);
            } else {
                Gate.setDirOpen(TE, facing == 3 ? 0 : 1);
            }
            this.cycleNeighborGate(TE, TE.func_145831_w(), TE.field_145851_c, TE.field_145848_d, TE.field_145849_e);
        }
        actionResult.setAltered().setNoSound();
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return !world.func_147439_a(x, y - 1, z).func_149688_o().func_76220_a() ? false : super.func_149742_c(world, x, y, z);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null) {
            if (Gate.getState(TE) == 1) {
                return null;
            }
            if (Gate.getFacing(TE) == 1) {
                if (Gate.getType(TE) == 0 || Gate.getType(TE) == 6) {
                    return AxisAlignedBB.func_72330_a((double)((float)x + 0.4375f), (double)y, (double)z, (double)((float)x + 0.5625f), (double)((float)y + 1.5f), (double)((float)z + 1.0f));
                }
                return AxisAlignedBB.func_72330_a((double)((float)x + 0.375f), (double)y, (double)z, (double)((float)x + 0.625f), (double)((float)y + 1.5f), (double)((float)z + 1.0f));
            }
            if (Gate.getType(TE) == 0 || Gate.getType(TE) == 6) {
                return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)((float)z + 0.4375f), (double)((float)x + 1.0f), (double)((float)y + 1.5f), (double)((float)z + 0.5625f));
            }
            return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)((float)z + 0.375f), (double)((float)x + 1.0f), (double)((float)y + 1.5f), (double)((float)z + 0.625f));
        }
        return null;
    }

    public void func_149719_a(IBlockAccess blockAccess, int x, int y, int z) {
        TEBase TE = this.getTileEntity(blockAccess, x, y, z);
        if (TE != null) {
            if (Gate.getFacing(TE) == 1) {
                if (Gate.getType(TE) == 0 || Gate.getType(TE) == 6) {
                    this.func_149676_a(0.4375f, 0.0f, 0.0f, 0.5625f, 1.0f, 1.0f);
                } else {
                    this.func_149676_a(0.375f, 0.0f, 0.0f, 0.625f, 1.0f, 1.0f);
                }
            } else if (Gate.getType(TE) == 0 || Gate.getType(TE) == 6) {
                this.func_149676_a(0.0f, 0.0f, 0.4375f, 1.0f, 1.0f, 0.5625f);
            } else {
                this.func_149676_a(0.0f, 0.0f, 0.375f, 1.0f, 1.0f, 0.625f);
            }
        }
    }

    private void cycleNeighborGate(TEBase TE, World world, int x, int y, int z) {
        TEBase TE_YP;
        boolean isGateBelow = world.func_147439_a(x, y - 1, z).equals((Object)this);
        boolean isGateAbove = world.func_147439_a(x, y + 1, z).equals((Object)this);
        if (isGateBelow) {
            TEBase TE_YN = this.getTileEntity((IBlockAccess)world, x, y - 1, z);
            if (Gate.getFacing(TE_YN) == Gate.getFacing(TE)) {
                Gate.setDirOpen(TE_YN, Gate.getDirOpen(TE));
                Gate.setState(TE_YN, Gate.getState(TE), false);
            }
        } else if (isGateAbove && Gate.getFacing(TE_YP = this.getTileEntity((IBlockAccess)world, x, y + 1, z)) == Gate.getFacing(TE)) {
            Gate.setDirOpen(TE_YP, Gate.getDirOpen(TE));
            Gate.setState(TE_YP, Gate.getState(TE), false);
        }
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null) {
            TEBase[] TE_list;
            int facing = (MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) % 4;
            Gate.setFacing(TE, facing == 3 || facing == 1 ? 1 : 0);
            for (TEBase TE_current : TE_list = this.getAdjacentTileEntities(world, x, y, z)) {
                if (TE_current == null) continue;
                Block block = TE_current.func_145838_q();
                if (block.equals((Object)this)) {
                    Gate.setType(TE, Gate.getType(TE_current));
                    continue;
                }
                if (!block.equals(BlockRegistry.blockCarpentersGate)) continue;
                Gate.setType(TE, Barrier.getType(TE_current));
            }
        }
        super.func_149689_a(world, x, y, z, entityLiving, itemStack);
    }

    @Override
    public void func_149695_a(World world, int x, int y, int z, Block block) {
        boolean isPowered;
        TEBase TE;
        if (!world.field_72995_K && (TE = this.getTileEntity((IBlockAccess)world, x, y, z)) != null && ((isPowered = world.func_72864_z(x, y, z)) || block != null && block.func_149744_f())) {
            int state = Gate.getState(TE);
            if (isPowered && state == 0) {
                Gate.setState(TE, 1, true);
                this.cycleNeighborGate(TE, world, x, y, z);
            } else if (!isPowered && state == 1) {
                Gate.setState(TE, 0, true);
                this.cycleNeighborGate(TE, world, x, y, z);
            }
        }
        super.func_149695_a(world, x, y, z, block);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess blockAccess, int x, int y, int z, int side) {
        return true;
    }

    public int func_149645_b() {
        return BlockRegistry.carpentersGateRenderID;
    }

    public ForgeDirection[] getValidRotations(World worldObj, int x, int y, int z) {
        ForgeDirection[] axises = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN};
        return axises;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TEBase) {
            TEBase cbTile = (TEBase)tile;
            int facing = Gate.getFacing(cbTile);
            switch (facing) {
                case 0: {
                    Gate.setFacing(cbTile, 1);
                    break;
                }
                case 1: {
                    Gate.setFacing(cbTile, 0);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

