/*
 * Decompiled with CFR 0.152.
 */
package li.cil.repack.org.luaj.vm2.lib.jse;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import li.cil.repack.org.luaj.vm2.LuaError;
import li.cil.repack.org.luaj.vm2.LuaTable;
import li.cil.repack.org.luaj.vm2.LuaValue;
import li.cil.repack.org.luaj.vm2.Varargs;
import li.cil.repack.org.luaj.vm2.lib.VarArgFunction;
import li.cil.repack.org.luaj.vm2.lib.jse.CoerceJavaToLua;
import li.cil.repack.org.luaj.vm2.lib.jse.CoerceLuaToJava;
import li.cil.repack.org.luaj.vm2.lib.jse.JavaClass;

public class LuajavaLib
extends VarArgFunction {
    static final int INIT = 0;
    static final int BINDCLASS = 1;
    static final int NEWINSTANCE = 2;
    static final int NEW = 3;
    static final int CREATEPROXY = 4;
    static final int LOADLIB = 5;
    static final String[] NAMES = new String[]{"bindClass", "newInstance", "new", "createProxy", "loadLib"};
    static final int METHOD_MODIFIERS_VARARGS = 128;

    @Override
    public Varargs invoke(Varargs args) {
        try {
            switch (this.opcode) {
                case 0: {
                    LuaValue env = args.arg(2);
                    LuaTable t = new LuaTable();
                    this.bind(t, this.getClass(), NAMES, 1);
                    env.set("luajava", (LuaValue)t);
                    env.get("package").get("loaded").set("luajava", (LuaValue)t);
                    return t;
                }
                case 1: {
                    Class clazz = this.classForName(args.checkjstring(1));
                    return JavaClass.forClass(clazz);
                }
                case 2: 
                case 3: {
                    LuaValue c = args.checkvalue(1);
                    Class clazz = this.opcode == 2 ? this.classForName(c.tojstring()) : (Class)c.checkuserdata(Class.class);
                    Varargs consargs = args.subargs(2);
                    return JavaClass.forClass(clazz).getConstructor().invoke(consargs);
                }
                case 4: {
                    int niface = args.narg() - 1;
                    if (niface <= 0) {
                        throw new LuaError("no interfaces");
                    }
                    final LuaTable lobj = args.checktable(niface + 1);
                    Class[] ifaces = new Class[niface];
                    for (int i = 0; i < niface; ++i) {
                        ifaces[i] = this.classForName(args.checkjstring(i + 1));
                    }
                    InvocationHandler handler = new InvocationHandler(){

                        @Override
                        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                            LuaValue[] v;
                            int n;
                            String name = method.getName();
                            LuaValue func = lobj.get(name);
                            if (func.isnil()) {
                                return null;
                            }
                            boolean isvarargs = (method.getModifiers() & 0x80) != 0;
                            int n2 = n = args != null ? args.length : 0;
                            if (isvarargs) {
                                int i;
                                Object o = args[--n];
                                int m = Array.getLength(o);
                                v = new LuaValue[n + m];
                                for (i = 0; i < n; ++i) {
                                    v[i] = CoerceJavaToLua.coerce(args[i]);
                                }
                                for (i = 0; i < m; ++i) {
                                    v[i + n] = CoerceJavaToLua.coerce(Array.get(o, i));
                                }
                            } else {
                                v = new LuaValue[n];
                                for (int i = 0; i < n; ++i) {
                                    v[i] = CoerceJavaToLua.coerce(args[i]);
                                }
                            }
                            LuaValue result2 = func.invoke(v).arg1();
                            return CoerceLuaToJava.coerce(result2, method.getReturnType());
                        }
                    };
                    Object proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), ifaces, handler);
                    return LuaValue.userdataOf(proxy);
                }
                case 5: {
                    String classname = args.checkjstring(1);
                    String methodname = args.checkjstring(2);
                    Class clazz = this.classForName(classname);
                    Method method = clazz.getMethod(methodname, new Class[0]);
                    Object result2 = method.invoke((Object)clazz, new Object[0]);
                    if (result2 instanceof LuaValue) {
                        return (LuaValue)result2;
                    }
                    return NIL;
                }
            }
            throw new LuaError("not yet supported: " + this);
        }
        catch (LuaError e) {
            throw e;
        }
        catch (InvocationTargetException ite) {
            throw new LuaError(ite.getTargetException());
        }
        catch (Exception e) {
            throw new LuaError(e);
        }
    }

    protected Class classForName(String name) throws ClassNotFoundException {
        return Class.forName(name, true, ClassLoader.getSystemClassLoader());
    }
}

