/*
 * Decompiled with CFR 0.152.
 */
package unwrittenfun.minecraft.immersiveintegration.tiles;

import appeng.api.AEApi;
import appeng.api.exceptions.FailedConnection;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridNotification;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import appeng.me.GridNode;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.WireType;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.util.ForgeDirection;
import unwrittenfun.minecraft.immersiveintegration.ImmersiveIntegration;
import unwrittenfun.minecraft.immersiveintegration.blocks.IIBlocks;
import unwrittenfun.minecraft.immersiveintegration.tiles.TileWireConnector;
import unwrittenfun.minecraft.immersiveintegration.wires.IIWires;

public class TileMEWireConnector
extends TileWireConnector
implements IGridHost,
IGridBlock {
    public IGrid theGrid;
    public IGridNode theGridNode;
    public ArrayList<IGridConnection> gridConnections = new ArrayList();
    private boolean loaded = false;

    public void func_145845_h() {
        if (!this.loaded && this.func_145830_o() && !this.field_145850_b.field_72995_K) {
            this.loaded = true;
            this.createAELink();
            Set connections = ImmersiveNetHandler.INSTANCE.getConnections(this.field_145850_b, Utils.toCC((Object)this));
            if (connections == null) {
                return;
            }
            for (ImmersiveNetHandler.Connection connection : connections) {
                GridNode nodeB;
                GridNode nodeA;
                TileEntity teOpposite;
                ChunkCoordinates opposite = connection.end;
                if (connection.end.equals((Object)Utils.toCC((Object)this))) {
                    opposite = connection.start;
                }
                if (!((teOpposite = this.field_145850_b.func_147438_o(opposite.field_71574_a, opposite.field_71572_b, opposite.field_71573_c)) instanceof IGridHost) || (nodeA = (GridNode)((IGridHost)teOpposite).getGridNode(ForgeDirection.UNKNOWN)).hasConnection((IGridNode)(nodeB = (GridNode)this.getGridNode(ForgeDirection.UNKNOWN))) || nodeB.hasConnection((IGridNode)nodeA)) continue;
                try {
                    this.gridConnections.add(AEApi.instance().createGridConnection((IGridNode)nodeA, (IGridNode)nodeB));
                }
                catch (FailedConnection failedConnection) {
                    failedConnection.printStackTrace();
                }
            }
        }
    }

    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (this.theGridNode == null) {
            this.createAELink();
        }
    }

    public void createAELink() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.theGridNode == null) {
                this.theGridNode = AEApi.instance().createGridNode((IGridBlock)this);
            }
            this.theGridNode.updateState();
        }
    }

    public void destroyAELink() {
        if (this.theGridNode != null) {
            this.theGridNode.destroy();
        }
    }

    public WireType getCableLimiter(TargetingInfo target) {
        return IIWires.fluixWire;
    }

    public void removeCable(ImmersiveNetHandler.Connection connection) {
        if (!this.field_145850_b.field_72995_K) {
            ChunkCoordinates opposite = connection.end;
            if (connection.end.equals((Object)Utils.toCC((Object)this))) {
                opposite = connection.start;
            }
            for (IGridConnection gridConnection : this.gridConnections) {
                DimensionalCoord locA = gridConnection.a().getGridBlock().getLocation();
                DimensionalCoord locB = gridConnection.b().getGridBlock().getLocation();
                if ((opposite.field_71574_a != locA.x || opposite.field_71573_c != locA.z || opposite.field_71572_b != locA.y) && (opposite.field_71574_a != locB.x || opposite.field_71573_c != locB.z || opposite.field_71572_b != locB.y)) continue;
                gridConnection.destroy();
                this.gridConnections.remove(gridConnection);
                break;
            }
        }
        super.removeCable(connection);
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.destroyAELink();
        }
    }

    public void onChunkUnload() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.destroyAELink();
        }
    }

    public double getIdlePowerUsage() {
        return ImmersiveIntegration.cfg.meWireConnectorDrain;
    }

    public EnumSet<GridFlags> getFlags() {
        return EnumSet.noneOf(GridFlags.class);
    }

    public boolean isWorldAccessible() {
        return false;
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public AEColor getGridColor() {
        return AEColor.Transparent;
    }

    public void onGridNotification(GridNotification notification) {
    }

    public void setNetworkStatus(IGrid grid, int channelsInUse) {
        this.theGrid = grid;
    }

    public EnumSet<ForgeDirection> getConnectableSides() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    public IGridHost getMachine() {
        return this;
    }

    public void gridChanged() {
    }

    public ItemStack getMachineRepresentation() {
        return new ItemStack(IIBlocks.meWireConnector);
    }

    public IGridNode getGridNode(ForgeDirection dir) {
        if (this.theGridNode == null) {
            this.createAELink();
        }
        return this.theGridNode;
    }

    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.SMART;
    }

    public void securityBreak() {
    }

    @Override
    public void connectTo(int x, int y, int z) {
        TileEntity tileEntity = this.field_145850_b.func_147438_o(x, y, z);
        if (tileEntity instanceof IGridHost) {
            IGridHost gridHost = (IGridHost)tileEntity;
            try {
                this.gridConnections.add(AEApi.instance().createGridConnection(gridHost.getGridNode(ForgeDirection.UNKNOWN), this.getGridNode(ForgeDirection.UNKNOWN)));
            }
            catch (FailedConnection failedConnection) {
                failedConnection.printStackTrace();
                ImmersiveIntegration.log.error("Something went wrong connecting the fluix wire!");
            }
        }
    }

    @Override
    public int getRenderRadiusIncrease() {
        return IIWires.fluixWire.getMaxLength();
    }
}

