/*
 * Decompiled with CFR 0.152.
 */
package unwrittenfun.minecraft.immersiveintegration.blocks;

import cofh.api.energy.IEnergyContainerItem;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import unwrittenfun.minecraft.immersiveintegration.ImmersiveIntegration;
import unwrittenfun.minecraft.immersiveintegration.client.renderers.BlockRenderIIBlocks;
import unwrittenfun.minecraft.immersiveintegration.tiles.TileInductionChargerHV;
import unwrittenfun.minecraft.immersiveintegration.tiles.TileInductionChargerLV;
import unwrittenfun.minecraft.immersiveintegration.tiles.TileInductionChargerMV;

public class BlockInductionCharger
extends BlockContainer {
    public static final String[] KEYS = new String[]{"LV", "MV", "HV"};
    protected IIcon[] icons;
    protected String key;

    protected BlockInductionCharger(String key) {
        super(Material.field_151575_d);
        this.key = key;
        this.func_149658_d(key);
        this.func_149663_c(key);
        this.func_149647_a(ImmersiveIntegration.iiCreativeTab);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.5625f, 1.0f);
        this.func_149711_c(2.0f);
        this.func_149672_a(Block.field_149766_f);
    }

    public TileEntity func_149915_a(World world, int meta) {
        switch (meta) {
            case 0: {
                return new TileInductionChargerLV();
            }
            case 1: {
                return new TileInductionChargerMV();
            }
            case 2: {
                return new TileInductionChargerHV();
            }
        }
        return null;
    }

    public void func_149651_a(IIconRegister register) {
        this.icons = new IIcon[KEYS.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = register.func_94245_a(this.key + KEYS[i]);
        }
    }

    public IIcon func_149691_a(int side, int meta) {
        return this.icons[Math.min(meta, this.icons.length - 1)];
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < KEYS.length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return ForgeDirection.UP != side;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return BlockRenderIIBlocks.RENDER_ID;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            if (tileEntity instanceof TileInductionChargerLV) {
                TileInductionChargerLV charger = (TileInductionChargerLV)tileEntity;
                if (charger.chargingStack == null) {
                    if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof IEnergyContainerItem && !(player.func_70694_bm().func_77973_b() instanceof ItemBlock) && ((IEnergyContainerItem)player.func_70694_bm().func_77973_b()).getMaxEnergyStored(player.func_70694_bm()) > 0) {
                        charger.setChargingStack(player.func_70694_bm());
                        player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                    }
                } else {
                    EntityItem dropItem = new EntityItem(world, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, charger.chargingStack.func_77946_l());
                    dropItem.field_145804_b = 0;
                    dropItem.field_70159_w = 0.0;
                    dropItem.field_70181_x = 0.0;
                    dropItem.field_70179_y = 0.0;
                    world.func_72838_d((Entity)dropItem);
                    charger.setChargingStack(null);
                }
            }
            return true;
        }
        return true;
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (!world.field_72995_K && !entity.field_70128_L && entity instanceof EntityItem) {
            EntityItem itemEntity = (EntityItem)entity;
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            if (tileEntity instanceof TileInductionChargerLV) {
                TileInductionChargerLV charger = (TileInductionChargerLV)tileEntity;
                if (charger.chargingStack == null && itemEntity.func_92059_d().func_77973_b() instanceof IEnergyContainerItem && !(itemEntity.func_92059_d().func_77973_b() instanceof ItemBlock)) {
                    charger.setChargingStack(itemEntity.func_92059_d());
                    --itemEntity.func_92059_d().field_77994_a;
                    if (itemEntity.func_92059_d().field_77994_a < 1) {
                        itemEntity.func_70106_y();
                    }
                }
            }
        }
    }
}

