/*
 * Decompiled with CFR 0.152.
 */
package com.aesireanempire.eplus.utils;

import com.aesireanempire.eplus.lib.ConfigurationSettings;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class Utils {
    public static String keySetToString(Set<String> strings) {
        return Utils.listToString(Arrays.asList(strings.toArray(new String[strings.size()])));
    }

    public static String listToString(List<String> list) {
        String ret = "[ ";
        for (int i = 0; i < list.size(); ++i) {
            ret = ret + list.get(i);
            ret = i + 1 <= list.size() - 1 ? ret + " | " : ret + " ";
        }
        ret = ret + "]";
        return ret;
    }

    public static double round(double value, double inc) {
        return (double)Math.round(value / inc) * inc;
    }

    public static ItemStack removeEnchantFromStack(ItemStack itemStack, Enchantment enchantment) {
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
        if (enchantments.containsKey(enchantment.field_77352_x)) {
            enchantments.remove(enchantment.field_77352_x);
        }
        return Utils.setEnchantments(enchantments, itemStack, null, null);
    }

    public static boolean isNewItemEnchantable(Item item) {
        if (item.equals(Items.field_151134_bR)) {
            return Utils.isEnchantable(new ItemStack(Items.field_151122_aG));
        }
        return Utils.isEnchantable(new ItemStack(item));
    }

    public static ItemStack setEnchantments(Map<?, ?> map, ItemStack itemStack, HashMap<Integer, Integer> levels, EntityPlayer player) {
        NBTTagList nbttaglist = new NBTTagList();
        NBTTagList restrictions = itemStack.func_77942_o() ? itemStack.func_77978_p().func_150295_c("restrictions", 10) : new NBTTagList();
        for (Object o : map.keySet()) {
            int i = (Integer)o;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74777_a("id", (short)i);
            nbttagcompound.func_74777_a("lvl", (short)((Integer)map.get(i)).intValue());
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
            int startLevel = (Integer)map.get(i);
            try {
                startLevel = levels.get(i);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            for (int y = startLevel; y <= (Integer)map.get(i); ++y) {
                if (Utils.containsKey(restrictions, i, y)) continue;
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74777_a("id", (short)i);
                compound.func_74777_a("lvl", (short)y);
                compound.func_74778_a("player", player.getDisplayName());
                restrictions.func_74742_a((NBTBase)compound);
            }
        }
        if (itemStack.func_77973_b() == Items.field_151122_aG) {
            itemStack = new ItemStack((Item)Items.field_151134_bR);
        }
        if (nbttaglist.func_74745_c() > 0) {
            if (itemStack.func_77973_b() != Items.field_151134_bR) {
                itemStack.func_77983_a("ench", (NBTBase)nbttaglist);
            } else {
                itemStack.func_77983_a("StoredEnchantments", (NBTBase)nbttaglist);
            }
            itemStack.func_77983_a("restrictions", (NBTBase)restrictions);
        } else if (itemStack.func_77942_o()) {
            if (itemStack.func_77973_b() != Items.field_151134_bR) {
                itemStack.func_77978_p().func_82580_o("ench");
            } else {
                itemStack.func_77978_p().func_82580_o("StoredEnchantments");
                itemStack.field_77990_d = null;
                itemStack = new ItemStack(Items.field_151122_aG);
            }
        }
        return itemStack;
    }

    public static boolean containsKey(NBTTagList restrictions, int id, int level) {
        for (int k = 0; k < restrictions.func_74745_c(); ++k) {
            NBTTagCompound tag = restrictions.func_150305_b(k);
            if (tag.func_74765_d("lvl") != level || tag.func_74765_d("id") != id) continue;
            return true;
        }
        return false;
    }

    public static boolean isEnchanted(ItemStack itemStack) {
        return itemStack.func_77942_o() && (itemStack.func_77973_b() != Items.field_151134_bR ? itemStack.field_77990_d.func_74764_b("ench") : itemStack.field_77990_d.func_74764_b("StoredEnchantments"));
    }

    public static boolean isEnchantable(ItemStack stack) {
        boolean marked = stack.func_77942_o() ? !stack.func_77978_p().func_74764_b("charge") : true;
        return stack.func_77973_b().func_77619_b() > 0 && (stack.func_77973_b() == Items.field_151122_aG || stack.func_77956_u() && marked);
    }

    public static boolean canEnchantItem(ItemStack stack, Enchantment ench) {
        if (ConfigurationSettings.disregardItemType) {
            return true;
        }
        return stack != null && stack.func_77973_b() == Items.field_151122_aG && ench.isAllowedOnBooks() || ench != null && ench.canApplyAtEnchantingTable(stack);
    }

    public static void addStoredEnchantment(ItemStack stack, EnchantmentData data) {
        NBTTagList storedEnchantments = Utils.getStoredEnchantmentsTag(stack);
        boolean isNew = true;
        for (int i = 0; i < storedEnchantments.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = storedEnchantments.func_150305_b(i);
            if (nbttagcompound.func_74765_d("id") != data.field_76302_b.field_77352_x || nbttagcompound.func_74765_d("lvl") == data.field_76303_c) continue;
            nbttagcompound.func_74777_a("lvl", (short)data.field_76303_c);
            isNew = false;
            break;
        }
        if (isNew) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74777_a("id", (short)data.field_76302_b.field_77352_x);
            nbttagcompound1.func_74777_a("lvl", (short)data.field_76303_c);
            storedEnchantments.func_74742_a((NBTBase)nbttagcompound1);
        }
        stack.func_77978_p().func_74782_a("StoredEnchantments", (NBTBase)storedEnchantments);
    }

    public static NBTTagList getStoredEnchantmentsTag(ItemStack stack) {
        return stack.field_77990_d != null && stack.field_77990_d.func_74764_b("StoredEnchantments") ? (NBTTagList)stack.field_77990_d.func_74781_a("StoredEnchantments") : new NBTTagList();
    }

    public static NBTTagCompound getStackTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }
}

