/*
 * Decompiled with CFR 0.152.
 */
package com.aesireanempire.eplus.network.packets;

import com.aesireanempire.eplus.EnchantingPlus;
import com.aesireanempire.eplus.inventory.ContainerEnchantTable;
import com.aesireanempire.eplus.network.packets.ErrorPacket;
import com.aesireanempire.eplus.network.packets.IPacket;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;

public class RepairPacket
implements IPacket {
    protected int totalCost;
    protected int repairAmount;

    public RepairPacket() {
    }

    public RepairPacket(int totalCost, int repairAmount) {
        this.totalCost = totalCost;
        this.repairAmount = repairAmount;
    }

    @Override
    public void readBytes(ByteBuf bytes) {
        this.totalCost = bytes.readInt();
        this.repairAmount = bytes.readInt();
    }

    @Override
    public void writeBytes(ByteBuf bytes) {
        bytes.writeInt(this.totalCost);
        bytes.writeInt(this.repairAmount);
    }

    @Override
    public void executeClient(EntityPlayer player) {
    }

    @Override
    public void executeServer(EntityPlayer player) {
        if (player.field_71070_bA instanceof ContainerEnchantTable) {
            try {
                ((ContainerEnchantTable)player.field_71070_bA).repair(player, this.totalCost, this.repairAmount);
            }
            catch (Exception e) {
                EnchantingPlus.log.info("Repair failed because: " + e.getLocalizedMessage());
                EnchantingPlus.sendPacketToPlayer(new ErrorPacket(e.getLocalizedMessage()), player);
            }
            player.field_71070_bA.func_75142_b();
        }
    }
}

