/*
 * Decompiled with CFR 0.152.
 */
package com.aesireanempire.eplus.network.packets;

import com.aesireanempire.eplus.EnchantingPlus;
import com.aesireanempire.eplus.lib.ConfigurationSettings;
import com.aesireanempire.eplus.network.packets.IPacket;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;

public class GuiPacket
implements IPacket {
    private int guiId;
    private int xPos;
    private int yPos;
    private int zPos;
    private String username;

    public GuiPacket() {
    }

    public GuiPacket(String displayName, int guidId, int xPos, int yPos, int zPos) {
        this.username = displayName;
        this.guiId = guidId;
        this.xPos = xPos;
        this.yPos = yPos;
        this.zPos = zPos;
    }

    @Override
    public void readBytes(ByteBuf bytes) {
        int length = bytes.readInt();
        this.username = bytes.readBytes(length).toString();
        this.guiId = bytes.readInt();
        this.xPos = bytes.readInt();
        this.yPos = bytes.readInt();
        this.zPos = bytes.readInt();
    }

    @Override
    public void writeBytes(ByteBuf bytes) {
        bytes.writeInt(this.username.length());
        bytes.writeBytes(this.username.getBytes());
        bytes.writeInt(this.guiId);
        bytes.writeInt(this.xPos);
        bytes.writeInt(this.yPos);
        bytes.writeInt(this.zPos);
    }

    @Override
    public void executeClient(EntityPlayer player) {
    }

    @Override
    public void executeServer(EntityPlayer player) {
        switch (this.guiId) {
            case 0: {
                if (!ConfigurationSettings.useMod) break;
                player.openGui((Object)EnchantingPlus.INSTANCE, this.guiId, player.field_70170_p, this.xPos, this.yPos, this.zPos);
                break;
            }
            case 1: {
                player.openGui((Object)EnchantingPlus.INSTANCE, this.guiId, player.field_70170_p, this.xPos, this.yPos, this.zPos);
            }
        }
    }
}

