/*
 * Decompiled with CFR 0.152.
 */
package com.aesireanempire.eplus.handlers;

import com.aesireanempire.eplus.EnchantingPlus;
import com.aesireanempire.eplus.lib.ConfigurationSettings;
import com.aesireanempire.eplus.lib.EnchantmentHelp;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Set;
import net.minecraft.enchantment.Enchantment;
import net.minecraftforge.common.config.Configuration;

public class ConfigurationHandler {
    public static final String CATEGORY_CLIENT = "client";
    public static final String CATEGORY_SERVER = "server";
    public static final String CATEGORY_BOTH = "both";
    public static final String CATEGORY_ENCHANT = "enchantments";
    public static final String CATEGORY_IDS = "ids";
    public static Configuration configuration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(File suggestedConfigurationFile) {
        configuration = new Configuration(suggestedConfigurationFile, false);
        EnchantingPlus.log.info("Initializing Configurations.");
        try {
            configuration.load();
            configuration.addCustomCategoryComment(CATEGORY_CLIENT, "Settings controlled client.\nCan vary from server to server.");
            configuration.addCustomCategoryComment(CATEGORY_SERVER, "Settings controlled by server.");
            configuration.addCustomCategoryComment(CATEGORY_BOTH, "Settings controlled by both.\nClient can be different from server.\nIf client differs from server, server can disable client's setting if false.");
            configuration.addCustomCategoryComment(CATEGORY_ENCHANT, "Enchantments can be disabled to be enchantable in the table.\nControlled on the server side");
            ConfigurationSettings.hasParticles = configuration.get(CATEGORY_CLIENT, "hasParticles", ConfigurationSettings.hasParticles, "Set to true to have the enchanting table emmit particles.").getBoolean(ConfigurationSettings.hasParticles);
            ConfigurationSettings.tableParticles = configuration.get(CATEGORY_CLIENT, "tableParticles", ConfigurationSettings.tableParticles, "The type of particle this table spawns, more info here: http://minecraft.gamepedia.com/Particles").getString();
            ConfigurationSettings.disregardItemType = configuration.get(CATEGORY_SERVER, "Disregard item type?", ConfigurationSettings.disregardItemType, "If true the table will disregard the type of item being used. This means any item can get any enchantment.").getBoolean(ConfigurationSettings.disregardItemType);
            ConfigurationSettings.canDisenUnowned = configuration.get(CATEGORY_SERVER, "Can players disenchant items they have not enchanted?", false, "Allow disenchanting of enchantment levels the player doesn't own.").getBoolean(ConfigurationSettings.canDisenUnowned);
            ConfigurationSettings.needsBookShelves = configuration.get(CATEGORY_SERVER, "Are bookshelves required to do an enchantment?", ConfigurationSettings.needsBookShelves, "Set to true to require book shelves to enchant.").getBoolean(ConfigurationSettings.needsBookShelves);
            ConfigurationSettings.hasLight = configuration.get(CATEGORY_SERVER, "Should the table have light?", ConfigurationSettings.hasLight, "Set to true to have the enchanting table emmit light.").getBoolean(ConfigurationSettings.hasLight);
            ConfigurationSettings.canDisenchant = configuration.get(CATEGORY_SERVER, "Can the table disenchant items?", ConfigurationSettings.canDisenchant, "Set to true to allow disenchanting.").getBoolean(ConfigurationSettings.canDisenchant);
            ConfigurationSettings.canRepair = configuration.get(CATEGORY_SERVER, "Can the table repair items?", ConfigurationSettings.canRepair, "Set to true to allow repairing of items via enchantment table.").getBoolean(ConfigurationSettings.canRepair);
            ConfigurationSettings.canEnchantDamaged = configuration.get(CATEGORY_SERVER, "Can the table enchant damaged items?", ConfigurationSettings.canEnchantDamaged, "Determinds if a player can enchant a damaged item").getBoolean(ConfigurationSettings.canEnchantDamaged);
            ConfigurationSettings.costFactor = configuration.get(CATEGORY_SERVER, "What is the cost factor?", ConfigurationSettings.costFactor, "Determinds the cost factor of enchanting / disenchanting / repair").getInt();
            ConfigurationHandler.clampSetting(CATEGORY_SERVER, "costFactor", 1);
            ConfigurationSettings.repairFactor = configuration.get(CATEGORY_SERVER, "What is the repair factor", ConfigurationSettings.repairFactor, "factor which repair cost is divided by (Default = 5). Higher is Cheaper").getInt();
            ConfigurationHandler.clampSetting(CATEGORY_SERVER, "repairFactor", 1);
            ConfigurationSettings.minimumBeforeBooks = configuration.get(CATEGORY_SERVER, "At when level do players need to have bookshelves?", 5, "Minimum level of enchanting cost before requiring bookcases").getInt();
            ConfigurationHandler.clampSetting(CATEGORY_SERVER, "minimumBeforeBooks", 0);
            ConfigurationSettings.tableHardness = (float)configuration.get(CATEGORY_SERVER, "How long to break the table?", (double)ConfigurationSettings.tableHardness, "Sets the hardness of the table block. This is used to tell how long it takes to break the block.").getDouble();
            ConfigurationSettings.tableResistance = (float)configuration.get(CATEGORY_SERVER, "How blast resistant is the table?", (double)ConfigurationSettings.tableResistance, "Sets the blast resistance for the table.").getDouble();
            ConfigurationSettings.useMod = configuration.get(CATEGORY_BOTH, "Should the mod be used?", ConfigurationSettings.useMod, "Set to true to use custom Enchantment Table in place of Vanilla").getBoolean(ConfigurationSettings.useMod);
        }
        catch (Exception e) {
            EnchantingPlus.log.info("Error Loading configuration");
            EnchantingPlus.log.info("Cause by " + e.getLocalizedMessage());
        }
        finally {
            if (configuration.hasChanged()) {
                configuration.save();
            }
        }
    }

    private static void clampSetting(String category, String setting, int minimum) {
        try {
            Field field = ConfigurationSettings.class.getDeclaredField(setting);
            int value = field.getInt(null);
            if (value < minimum) {
                configuration.getCategory(category).get(setting).set(minimum);
                field.setInt(null, minimum);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void set(String propertyName, String newValue) {
        configuration.load();
        Set categoryNames = configuration.getCategoryNames();
        for (String category : categoryNames) {
            if (!configuration.getCategory(category).containsKey(propertyName)) continue;
            configuration.getCategory(category).get(propertyName).set(newValue);
        }
        try {
            Field field = ReflectionHelper.findField(ConfigurationSettings.class, (String[])new String[]{propertyName});
            try {
                if (field.getType() == Boolean.TYPE) {
                    field.setBoolean(EnchantingPlus.INSTANCE, Boolean.parseBoolean(newValue));
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadEnchantments() {
        try {
            configuration.load();
            for (Enchantment enchant : Enchantment.field_77331_b) {
                if (enchant == null) continue;
                ConfigurationSettings.enchantments.put(enchant.func_77320_a(), configuration.get(CATEGORY_ENCHANT, enchant.func_77320_a(), true).getBoolean(true));
                EnchantmentHelp.putToolTips(enchant, configuration.get(CATEGORY_ENCHANT, enchant.func_77320_a() + "-ToolTip", "").getString());
            }
        }
        catch (Exception e) {
            EnchantingPlus.log.info("Error Loading configuration");
            e.printStackTrace();
        }
        finally {
            if (configuration.hasChanged()) {
                configuration.save();
            }
        }
    }
}

