/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.general.gui;

import net.machinemuse.numina.geometry.Colour;
import net.machinemuse.numina.render.MuseIconUtils;
import net.machinemuse.numina.render.MuseTextureUtils;
import net.machinemuse.numina.render.RenderState;
import net.machinemuse.powersuits.common.Config;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;

public class HeatMeter {
    int xsize = 8;
    int ysize = 32;

    public void draw(double xpos, double ypos, double value) {
        MuseTextureUtils.pushTexture((String)MuseTextureUtils.BLOCK_TEXTURE_QUILT());
        RenderState.blendingOn();
        RenderState.on2D();
        IIcon icon = Blocks.field_150353_l.func_149691_a(0, 0);
        this.drawFluid(xpos, ypos, value, icon);
        this.drawGlass(xpos, ypos);
        RenderState.off2D();
        RenderState.blendingOff();
        MuseTextureUtils.popTexture();
    }

    public void drawFluid(double xpos, double ypos, double value, IIcon icon) {
        double bottomY = ypos + (double)this.ysize;
        double topY = ypos + (double)this.ysize * (1.0 - value);
        GL11.glPushMatrix();
        GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
        while (bottomY - 8.0 > topY) {
            MuseIconUtils.drawIconAt((double)(xpos * 2.0), (double)((bottomY - 8.0) * 2.0), (IIcon)icon, (Colour)Colour.WHITE);
            bottomY -= 8.0;
        }
        MuseIconUtils.drawIconPartial((double)(xpos * 2.0), (double)((bottomY - 8.0) * 2.0), (IIcon)icon, (Colour)Colour.WHITE, (double)0.0, (double)((topY - bottomY + 8.0) * 2.0), (double)16.0, (double)16.0);
        GL11.glPopMatrix();
    }

    public void drawGlass(double xpos, double ypos) {
        MuseTextureUtils.pushTexture((String)Config.GLASS_TEXTURE());
        GL11.glBegin((int)7);
        GL11.glTexCoord2d((double)0.0, (double)0.0);
        GL11.glVertex2d((double)xpos, (double)ypos);
        GL11.glTexCoord2d((double)0.0, (double)1.0);
        GL11.glVertex2d((double)xpos, (double)(ypos + (double)this.ysize));
        GL11.glTexCoord2d((double)1.0, (double)1.0);
        GL11.glVertex2d((double)(xpos + (double)this.xsize), (double)(ypos + (double)this.ysize));
        GL11.glTexCoord2d((double)1.0, (double)0.0);
        GL11.glVertex2d((double)(xpos + (double)this.xsize), (double)ypos);
        GL11.glEnd();
        MuseTextureUtils.popTexture();
    }
}

