/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.IPowerModule;
import net.machinemuse.api.MuseItemTag;
import net.machinemuse.api.moduletrigger.IBlockBreakingModule;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.powersuits.item.ModeChangingModularItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ModuleManager {
    public static final String ONLINE = "Active";
    protected static final Map<String, List<ItemStack>> customInstallCosts = new HashMap<String, List<ItemStack>>();
    protected static final Map<String, IPowerModule> moduleMap = new HashMap<String, IPowerModule>();
    protected static final List<IPowerModule> moduleList = new ArrayList<IPowerModule>();
    protected static final List<IPlayerTickModule> playerTickModules = new ArrayList<IPlayerTickModule>();
    protected static final List<IRightClickModule> rightClickModules = new ArrayList<IRightClickModule>();
    protected static final List<IToggleableModule> toggleableModules = new ArrayList<IToggleableModule>();
    protected static final List<IBlockBreakingModule> blockBreakingModules = new ArrayList<IBlockBreakingModule>();

    public static List<IPowerModule> getAllModules() {
        return moduleList;
    }

    public static List<IPlayerTickModule> getPlayerTickModules() {
        return playerTickModules;
    }

    public static IPowerModule getModule(String key) {
        return moduleMap.get(key);
    }

    public static void addModule(IPowerModule module) {
        moduleMap.put(module.getDataName(), module);
        moduleList.add(module);
        if (module instanceof IPlayerTickModule) {
            playerTickModules.add((IPlayerTickModule)module);
        }
        if (module instanceof IRightClickModule) {
            rightClickModules.add((IRightClickModule)module);
        }
        if (module instanceof IToggleableModule) {
            toggleableModules.add((IToggleableModule)module);
        }
        if (module instanceof IBlockBreakingModule) {
            blockBreakingModules.add((IBlockBreakingModule)module);
        }
    }

    public static double computeModularProperty(ItemStack stack, String propertyName) {
        double propertyValue = 0.0;
        NBTTagCompound itemTag = MuseItemTag.getMuseItemTag(stack);
        for (IPowerModule module : moduleList) {
            if (!ModuleManager.itemHasActiveModule(stack, module.getDataName())) continue;
            propertyValue = module.applyPropertyModifiers(itemTag, propertyName, propertyValue);
        }
        return propertyValue;
    }

    public static List<IRightClickModule> getRightClickModules() {
        return rightClickModules;
    }

    public static List<IToggleableModule> getToggleableModules() {
        return toggleableModules;
    }

    public static List<IBlockBreakingModule> getBlockBreakingModules() {
        return blockBreakingModules;
    }

    public static List<IPowerModule> getValidModulesForItem(EntityPlayer player, ItemStack stack) {
        ArrayList<IPowerModule> validModules = new ArrayList<IPowerModule>();
        for (IPowerModule module : ModuleManager.getAllModules()) {
            if (!module.isValidForItem(stack)) continue;
            validModules.add(module);
        }
        return validModules;
    }

    public static boolean tagHasModule(NBTTagCompound tag, String moduleName) {
        return tag.func_74764_b(moduleName);
    }

    public static boolean isModuleOnline(NBTTagCompound itemTag, String moduleName) {
        if (ModuleManager.tagHasModule(itemTag, moduleName) && !itemTag.func_74775_l(moduleName).func_74764_b(ONLINE)) {
            return true;
        }
        return ModuleManager.tagHasModule(itemTag, moduleName) && itemTag.func_74775_l(moduleName).func_74767_n(ONLINE);
    }

    public static void toggleModule(NBTTagCompound itemTag, String name, boolean toggleval) {
        if (ModuleManager.tagHasModule(itemTag, name)) {
            NBTTagCompound moduleTag = itemTag.func_74775_l(name);
            moduleTag.func_74757_a(ONLINE, toggleval);
        }
    }

    public static boolean itemHasModule(ItemStack stack, String moduleName) {
        return ModuleManager.tagHasModule(MuseItemTag.getMuseItemTag(stack), moduleName);
    }

    public static void tagAddModule(NBTTagCompound tag, IPowerModule module) {
        tag.func_74782_a(module.getDataName(), (NBTBase)module.getNewTag());
    }

    public static void itemAddModule(ItemStack stack, IPowerModule moduleType) {
        ModuleManager.tagAddModule(MuseItemTag.getMuseItemTag(stack), moduleType);
    }

    public static boolean removeModule(NBTTagCompound tag, String moduleName) {
        if (tag.func_74764_b(moduleName)) {
            tag.func_82580_o(moduleName);
            return true;
        }
        return false;
    }

    public static boolean removeModule(ItemStack stack, String moduleName) {
        return ModuleManager.removeModule(MuseItemTag.getMuseItemTag(stack), moduleName);
    }

    public static boolean itemHasActiveModule(ItemStack itemStack, String moduleName) {
        IPowerModule module = ModuleManager.getModule(moduleName);
        if (module == null || itemStack == null || !module.isAllowed() || !(itemStack.func_77973_b() instanceof IModularItem)) {
            return false;
        }
        if (module instanceof IRightClickModule && itemStack.func_77973_b() instanceof ModeChangingModularItem) {
            ModeChangingModularItem item = (ModeChangingModularItem)itemStack.func_77973_b();
            return moduleName.equals(item.getActiveMode(itemStack));
        }
        return ModuleManager.isModuleOnline(MuseItemTag.getMuseItemTag(itemStack), moduleName);
    }

    public static boolean hasCustomInstallCost(String dataName) {
        return customInstallCosts.containsKey(dataName);
    }

    public static List<ItemStack> getCustomInstallCost(String dataName) {
        return customInstallCosts.get(dataName);
    }

    public static void addCustomInstallCost(String moduleName, ItemStack stack) {
        if (customInstallCosts.containsKey(moduleName)) {
            customInstallCosts.get(moduleName).add(stack);
        } else {
            customInstallCosts.put(moduleName, new ArrayList());
            customInstallCosts.get(moduleName).add(stack);
        }
    }
}

