/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.aobd.recipes.modules;

import cpw.mods.fml.common.registry.GameRegistry;
import ganymedes01.aobd.lib.CompatType;
import ganymedes01.aobd.ore.Ore;
import ganymedes01.aobd.recipes.RecipesModule;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputOreDict;
import ic2.api.recipe.Recipes;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class IndustrialCraft
extends RecipesModule {
    public IndustrialCraft() {
        super(CompatType.IC2, "iron", "gold", "copper", "tin", "silver", "lead");
    }

    @Override
    public void initOre(Ore ore) {
        ItemStack stoneDust = IndustrialCraft.getICItem("stoneDust");
        String name = ore.name();
        try {
            Recipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict("ore" + name), null, new ItemStack[]{IndustrialCraft.getOreStack("crushed", ore, 2)});
            Recipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict("ingot" + name), null, new ItemStack[]{IndustrialCraft.getOreStack("dust", ore)});
            IndustrialCraft.addCentrifugeRecipe((IRecipeInput)new RecipeInputOreDict("crushed" + name), (int)ore.energy(1500.0), IndustrialCraft.getOreStack("dust", ore), IndustrialCraft.getOreStackExtra("dustTiny", ore), stoneDust.func_77946_l());
            IndustrialCraft.addOreWashingRecipe((IRecipeInput)new RecipeInputOreDict("crushed" + name), IndustrialCraft.getOreStack("crushedPurified", ore), IndustrialCraft.getOreStack("dustTiny", ore, 2), stoneDust.func_77946_l());
            IndustrialCraft.addCentrifugeRecipe((IRecipeInput)new RecipeInputOreDict("crushedPurified" + name), (int)ore.energy(1500.0), IndustrialCraft.getOreStack("dust", ore, 1), IndustrialCraft.getOreStackExtra("dustTiny", ore));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(IndustrialCraft.getOreStack("dust", ore), new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), "dustTiny" + name}));
            this.addSmeltingNoDupes(IndustrialCraft.getOreStack("crushed", ore), IndustrialCraft.getOreStack("ingot", ore), 0.2f);
            GameRegistry.addSmelting((ItemStack)IndustrialCraft.getOreStack("crushedPurified", ore), (ItemStack)IndustrialCraft.getOreStack("ingot", ore), (float)0.2f);
            if (CompatType.MEKANISM.isEnabled() && ore.isCompatEnabled(CompatType.MEKANISM)) {
                Recipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict("clump" + name), null, new ItemStack[]{IndustrialCraft.getOreStack("dustDirty", ore)});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void addCentrifugeRecipe(IRecipeInput input, int minHeat, ItemStack ... output) {
        NBTTagCompound metadata = new NBTTagCompound();
        metadata.func_74768_a("minHeat", minHeat);
        Recipes.centrifuge.addRecipe(input, metadata, output);
    }

    private static void addOreWashingRecipe(IRecipeInput input, ItemStack ... output) {
        NBTTagCompound metadata = new NBTTagCompound();
        metadata.func_74768_a("amount", 1000);
        Recipes.oreWashing.addRecipe(input, metadata, output);
    }

    private static ItemStack getICItem(String name) {
        try {
            Class<?> itemsClass = Class.forName("ic2.core.Ic2Items");
            return (ItemStack)itemsClass.getField(name).get(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

