/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.aobd.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.aobd.AOBD;
import ganymedes01.aobd.client.ItemOreRenderer;
import ganymedes01.aobd.ore.Ore;
import ganymedes01.aobd.recipes.modules.ExNihilo;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.oredict.OreDictionary;

public class AOBDItem
extends Item {
    public static final Map<String, String[]> ITEMS_EXNIHILO = new HashMap<String, String[]>();
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icon;
    private Boolean hasEffect = null;
    protected final Ore ore;
    protected final String base;

    public AOBDItem(String base, Ore ore) {
        this.ore = ore;
        this.base = base;
        this.func_77637_a(AOBD.tab);
        this.func_111206_d("aobd:" + base);
        this.func_77655_b("aobd." + base + ore);
    }

    protected String getFullName() {
        return "item.aobd." + this.base + this.ore.name() + ".name";
    }

    protected String getShortName() {
        return "item.aobd." + this.base + ".name";
    }

    public String getBaseName() {
        return this.base;
    }

    public Ore getOre() {
        return this.ore;
    }

    public String func_77653_i(ItemStack stack) {
        String fullName = this.getFullName();
        String shortName = this.getShortName();
        return StatCollector.func_94522_b((String)fullName) ? StatCollector.func_74838_a((String)fullName) : String.format(StatCollector.func_74838_a((String)shortName), this.ore.translatedName());
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        return pass == 0 ? this.ore.colour() : super.func_82790_a(stack, pass);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack stack, int pass) {
        if (this.hasEffect == null) {
            this.hasEffect = false;
            for (ItemStack ingot : OreDictionary.getOres((String)("ingot" + this.ore.name()))) {
                if (ingot == null || !ingot.func_77973_b().hasEffect(stack, pass)) continue;
                this.hasEffect = true;
            }
        }
        return pass == 0 ? this.hasEffect : false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int meta, int pass) {
        String[] type = ITEMS_EXNIHILO.get(this.base);
        if (type != null) {
            return this.field_77791_bV;
        }
        return pass == 0 ? this.icon[0] : this.icon[1];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        String[] type = ITEMS_EXNIHILO.get(this.base);
        if (type != null) {
            boolean success;
            TextureMap map = (TextureMap)reg;
            TextureAtlasSprite texture = ExNihilo.createIcon(this, type[0], type[1], map);
            TextureAtlasSprite existing = map.getTextureExtry(texture.func_94215_i());
            if (existing == null && (success = map.setTextureEntry(texture.func_94215_i(), texture))) {
                this.field_77791_bV = map.getTextureExtry(texture.func_94215_i());
            }
        } else {
            this.icon = new IIcon[2];
            this.icon[0] = reg.func_94245_a(this.func_111208_A());
            this.icon[1] = reg.func_94245_a(this.func_111208_A() + "_overlay");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IItemRenderer getSpecialRenderer() {
        if ("ore".equals(this.base)) {
            return ItemOreRenderer.INSTANCE;
        }
        return null;
    }

    static {
        ITEMS_EXNIHILO.put("oreBroken", new String[]{"ItemBrokenBase", "ItemBrokenTemplate"});
        ITEMS_EXNIHILO.put("oreNetherBroken", new String[]{"ItemBrokenBaseNether", "ItemBrokenTemplate"});
        ITEMS_EXNIHILO.put("oreCrushed", new String[]{"ItemCrushedBase", "ItemCrushedTemplate"});
        ITEMS_EXNIHILO.put("orePowdered", new String[]{"ItemPowderedBase", "ItemPowderedTemplate"});
    }
}

