/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.utility;

import buildcraft.api.tools.IToolWrench;
import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import enhancedportals.item.ItemGlasses;
import enhancedportals.network.CommonProxy;
import enhancedportals.utility.DimensionCoordinates;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.util.ForgeDirection;

public class GeneralUtils {
    public static double getPowerMultiplier() {
        return GeneralUtils.hasEnergyCost() ? CommonProxy.CONFIG_POWER_MULTIPLIER : 0.0;
    }

    public static boolean hasEnergyCost() {
        return CommonProxy.CONFIG_REQUIRE_POWER;
    }

    public static boolean isEnergyContainerItem(ItemStack i) {
        return i != null && i.func_77973_b() instanceof IEnergyContainerItem;
    }

    public static boolean isWearingGoggles() {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            if (Minecraft.func_71410_x().field_71439_g == null) {
                return false;
            }
            ItemStack stack = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70440_f(3);
            return stack != null && stack.func_77973_b() == ItemGlasses.instance;
        }
        return false;
    }

    public static boolean isWrench(ItemStack i) {
        return i != null && i.func_77973_b() instanceof IToolWrench;
    }

    public static ChunkCoordinates loadChunkCoord(NBTTagCompound tagCompound, String string) {
        if (tagCompound.func_74781_a(string) == null) {
            return null;
        }
        NBTTagCompound t = (NBTTagCompound)tagCompound.func_74781_a(string);
        return t.func_74762_e("Y") == -1 ? null : new ChunkCoordinates(t.func_74762_e("X"), t.func_74762_e("Y"), t.func_74762_e("Z"));
    }

    public static ArrayList<ChunkCoordinates> loadChunkCoordList(NBTTagCompound tag, String name) {
        ArrayList<ChunkCoordinates> list = new ArrayList<ChunkCoordinates>();
        NBTTagList tagList = tag.func_150295_c(name, 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound t = tagList.func_150305_b(i);
            list.add(new ChunkCoordinates(t.func_74762_e("X"), t.func_74762_e("Y"), t.func_74762_e("Z")));
        }
        return list;
    }

    public static DimensionCoordinates loadWorldCoord(NBTTagCompound tagCompound, String string) {
        if (tagCompound.func_74781_a(string) == null) {
            return null;
        }
        NBTTagCompound t = (NBTTagCompound)tagCompound.func_74781_a(string);
        return t.func_74762_e("Y") == -1 ? null : new DimensionCoordinates(t.func_74762_e("X"), t.func_74762_e("Y"), t.func_74762_e("Z"), t.func_74762_e("D"));
    }

    public static void saveChunkCoord(NBTTagCompound tagCompound, ChunkCoordinates c, String string) {
        if (c == null) {
            return;
        }
        NBTTagCompound t = new NBTTagCompound();
        t.func_74768_a("X", c.field_71574_a);
        t.func_74768_a("Y", c.field_71572_b);
        t.func_74768_a("Z", c.field_71573_c);
        tagCompound.func_74782_a(string, (NBTBase)t);
    }

    public static void saveChunkCoordList(NBTTagCompound tag, List<ChunkCoordinates> list, String name) {
        NBTTagList tagList = new NBTTagList();
        for (ChunkCoordinates c : list) {
            NBTTagCompound t = new NBTTagCompound();
            t.func_74768_a("X", c.field_71574_a);
            t.func_74768_a("Y", c.field_71572_b);
            t.func_74768_a("Z", c.field_71573_c);
            tagList.func_74742_a((NBTBase)t);
        }
        tag.func_74782_a(name, (NBTBase)tagList);
    }

    public static void saveWorldCoord(NBTTagCompound tagCompound, DimensionCoordinates c, String string) {
        if (c == null) {
            return;
        }
        NBTTagCompound t = new NBTTagCompound();
        t.func_74768_a("X", c.field_71574_a);
        t.func_74768_a("Y", c.field_71572_b);
        t.func_74768_a("Z", c.field_71573_c);
        t.func_74768_a("D", c.dimension);
        tagCompound.func_74782_a(string, (NBTBase)t);
    }

    public static ChunkCoordinates offset(ChunkCoordinates c, ForgeDirection f) {
        return new ChunkCoordinates(c.field_71574_a + f.offsetX, c.field_71572_b + f.offsetY, c.field_71573_c + f.offsetZ);
    }
}

