/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.utility;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public class ConnectedTextures {
    protected IIcon[] textures;
    protected Block block;
    protected int blockMeta;
    protected int subMeta = -1;
    protected String textureLoc;
    private static final short[] connectionToIndex = new short[]{0, 15, 13, 11, 12, 5, 3, 9, 14, 4, 2, 10, 8, 7, 6, 1};

    protected ConnectedTextures() {
    }

    public ConnectedTextures(ConnectedTextures ct, Block block, int meta) {
        this(ct.textureLoc, block, meta, -1);
        this.textures = ct.textures;
    }

    public ConnectedTextures(ConnectedTextures ct, Block block, int meta, int meta2) {
        this(ct.textureLoc, block, meta, meta2);
        this.textures = ct.textures;
    }

    public ConnectedTextures(String textureLocation, Block b, int meta) {
        this(textureLocation, b, meta, -1);
    }

    public ConnectedTextures(String textureLocation, Block b, int meta, int meta2) {
        this.textureLoc = textureLocation;
        this.block = b;
        this.blockMeta = meta;
        this.subMeta = meta2;
        this.textures = new IIcon[16];
    }

    protected boolean canConnectTo(IBlockAccess blockAccess, int x, int y, int z) {
        if (this.block == blockAccess.func_147439_a(x, y, z)) {
            if (this.blockMeta == -1) {
                return true;
            }
            int meta = blockAccess.func_72805_g(x, y, z);
            if (this.blockMeta == meta) {
                return true;
            }
            return this.subMeta == -1 ? false : meta == this.subMeta;
        }
        return false;
    }

    public IIcon getBaseIcon() {
        return this.textures[0];
    }

    public IIcon getIconForSide(IBlockAccess blockAccess, int x, int y, int z, int side) {
        boolean[] connectingBlock = new boolean[4];
        boolean index = false;
        if (side == 0 || side == 1) {
            connectingBlock[0] = this.canConnectTo(blockAccess, x - 1, y, z);
            connectingBlock[1] = this.canConnectTo(blockAccess, x + 1, y, z);
            connectingBlock[2] = this.canConnectTo(blockAccess, x, y, z + 1);
            connectingBlock[3] = this.canConnectTo(blockAccess, x, y, z - 1);
        } else if (side == 2) {
            connectingBlock[0] = this.canConnectTo(blockAccess, x + 1, y, z);
            connectingBlock[1] = this.canConnectTo(blockAccess, x - 1, y, z);
            connectingBlock[2] = this.canConnectTo(blockAccess, x, y - 1, z);
            connectingBlock[3] = this.canConnectTo(blockAccess, x, y + 1, z);
        } else if (side == 3) {
            connectingBlock[0] = this.canConnectTo(blockAccess, x - 1, y, z);
            connectingBlock[1] = this.canConnectTo(blockAccess, x + 1, y, z);
            connectingBlock[2] = this.canConnectTo(blockAccess, x, y - 1, z);
            connectingBlock[3] = this.canConnectTo(blockAccess, x, y + 1, z);
        } else if (side == 4) {
            connectingBlock[0] = this.canConnectTo(blockAccess, x, y, z - 1);
            connectingBlock[1] = this.canConnectTo(blockAccess, x, y, z + 1);
            connectingBlock[2] = this.canConnectTo(blockAccess, x, y - 1, z);
            connectingBlock[3] = this.canConnectTo(blockAccess, x, y + 1, z);
        } else {
            connectingBlock[0] = this.canConnectTo(blockAccess, x, y, z + 1);
            connectingBlock[1] = this.canConnectTo(blockAccess, x, y, z - 1);
            connectingBlock[2] = this.canConnectTo(blockAccess, x, y - 1, z);
            connectingBlock[3] = this.canConnectTo(blockAccess, x, y + 1, z);
        }
        return this.textures[connectionToIndex[(connectingBlock[0] ? 8 : 0) | (connectingBlock[1] ? 4 : 0) | (connectingBlock[2] ? 2 : 0) | (connectingBlock[3] ? 1 : 0)]];
    }

    public void registerIcons(IIconRegister register) {
        for (int i = 0; i < this.textures.length; ++i) {
            this.textures[i] = register.func_94245_a(String.format(this.textureLoc, i));
        }
    }
}

