/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.tile;

import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import enhancedportals.block.BlockStabilizer;
import enhancedportals.tile.TileEP;
import enhancedportals.tile.TileStabilizerMain;
import enhancedportals.utility.DimensionCoordinates;
import enhancedportals.utility.GeneralUtils;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.util.ForgeDirection;

public class TileStabilizer
extends TileEP
implements IEnergyHandler {
    ChunkCoordinates mainBlock = null;
    int rows;
    boolean is3x3 = false;
    @SideOnly(value=Side.CLIENT)
    public boolean isFormed;

    public boolean activate(EntityPlayer player) {
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        TileStabilizerMain main = this.getMainBlock();
        if (main != null) {
            return main.activate(player);
        }
        if (GeneralUtils.isWrench(player.field_71071_by.func_70448_g())) {
            DimensionCoordinates topLeft = this.getDimensionCoordinates();
            while (topLeft.offset(ForgeDirection.WEST).getBlock() == BlockStabilizer.instance) {
                topLeft = topLeft.offset(ForgeDirection.WEST);
            }
            while (topLeft.offset(ForgeDirection.NORTH).getBlock() == BlockStabilizer.instance) {
                topLeft = topLeft.offset(ForgeDirection.NORTH);
            }
            while (topLeft.offset(ForgeDirection.UP).getBlock() == BlockStabilizer.instance) {
                topLeft = topLeft.offset(ForgeDirection.UP);
            }
            ArrayList<ChunkCoordinates> blocks = this.checkShapeThreeWide(topLeft);
            if (blocks.isEmpty() && (blocks = this.checkShapeTwoWide(topLeft, true)).isEmpty()) {
                blocks = this.checkShapeTwoWide(topLeft, false);
            }
            if (!blocks.isEmpty()) {
                TileEntity tile;
                for (ChunkCoordinates c : blocks) {
                    tile = this.field_145850_b.func_147438_o(c.field_71574_a, c.field_71572_b, c.field_71573_c);
                    if (tile instanceof TileStabilizer) {
                        if (((TileStabilizer)tile).getMainBlock() == null) continue;
                        TileStabilizerMain m = ((TileStabilizer)tile).getMainBlock();
                        m.deconstruct();
                        continue;
                    }
                    if (!(tile instanceof TileStabilizerMain)) continue;
                    ((TileStabilizerMain)tile).deconstruct();
                }
                for (ChunkCoordinates c : blocks) {
                    this.field_145850_b.func_147465_d(c.field_71574_a, c.field_71572_b, c.field_71573_c, (Block)BlockStabilizer.instance, 0, 2);
                    tile = this.field_145850_b.func_147438_o(c.field_71574_a, c.field_71572_b, c.field_71573_c);
                    if (!(tile instanceof TileStabilizer)) continue;
                    TileStabilizer t = (TileStabilizer)tile;
                    t.mainBlock = topLeft;
                    this.field_145850_b.func_147471_g(t.field_145851_c, t.field_145848_d, t.field_145849_e);
                }
                this.field_145850_b.func_147465_d(topLeft.field_71574_a, topLeft.field_71572_b, topLeft.field_71573_c, (Block)BlockStabilizer.instance, 1, 3);
                TileEntity tile2 = topLeft.getTileEntity();
                if (tile2 instanceof TileStabilizerMain) {
                    ((TileStabilizerMain)tile2).setData(blocks, this.rows, this.is3x3);
                    return true;
                }
            }
        }
        return false;
    }

    public void breakBlock(Block b, int oldMetadata) {
        TileStabilizerMain main = this.getMainBlock();
        if (main == null) {
            return;
        }
        main.deconstruct();
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    ArrayList<ChunkCoordinates> checkShapeThreeWide(DimensionCoordinates topLeft) {
        ArrayList<ChunkCoordinates> blocks = new ArrayList<ChunkCoordinates>();
        ChunkCoordinates heightChecker = new ChunkCoordinates((ChunkCoordinates)topLeft);
        this.rows = 0;
        while (this.field_145850_b.func_147439_a(heightChecker.field_71574_a, heightChecker.field_71572_b, heightChecker.field_71573_c) == BlockStabilizer.instance) {
            --heightChecker.field_71572_b;
            ++this.rows;
        }
        if (this.rows < 2) {
            this.rows = 0;
            return new ArrayList<ChunkCoordinates>();
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < this.rows; ++k) {
                    if (this.field_145850_b.func_147439_a(topLeft.field_71574_a + i, topLeft.field_71572_b - k, topLeft.field_71573_c + j) != BlockStabilizer.instance) {
                        return new ArrayList<ChunkCoordinates>();
                    }
                    blocks.add(new ChunkCoordinates(topLeft.field_71574_a + i, topLeft.field_71572_b - k, topLeft.field_71573_c + j));
                }
            }
        }
        this.is3x3 = true;
        return blocks;
    }

    ArrayList<ChunkCoordinates> checkShapeTwoWide(DimensionCoordinates topLeft, boolean isX) {
        ArrayList<ChunkCoordinates> blocks = new ArrayList<ChunkCoordinates>();
        ChunkCoordinates heightChecker = new ChunkCoordinates((ChunkCoordinates)topLeft);
        this.rows = 0;
        while (this.field_145850_b.func_147439_a(heightChecker.field_71574_a, heightChecker.field_71572_b, heightChecker.field_71573_c) == BlockStabilizer.instance) {
            --heightChecker.field_71572_b;
            ++this.rows;
        }
        if (this.rows < 2) {
            this.rows = 0;
            return new ArrayList<ChunkCoordinates>();
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < this.rows; ++k) {
                    if (this.field_145850_b.func_147439_a(topLeft.field_71574_a + (isX ? i : j), topLeft.field_71572_b - k, topLeft.field_71573_c + (!isX ? i : j)) != BlockStabilizer.instance) {
                        return new ArrayList<ChunkCoordinates>();
                    }
                    blocks.add(new ChunkCoordinates(topLeft.field_71574_a + (isX ? i : j), topLeft.field_71572_b - k, topLeft.field_71573_c + (!isX ? i : j)));
                }
            }
        }
        this.is3x3 = false;
        return blocks;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        TileStabilizerMain main = this.getMainBlock();
        if (main == null) {
            return 0;
        }
        return main.extractEnergy(from, maxExtract, simulate);
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("formed", this.mainBlock != null);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tag);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        TileStabilizerMain main = this.getMainBlock();
        if (main == null) {
            return 0;
        }
        return main.getEnergyStored(from);
    }

    public TileStabilizerMain getMainBlock() {
        TileEntity tile;
        if (this.mainBlock != null && (tile = this.field_145850_b.func_147438_o(this.mainBlock.field_71574_a, this.mainBlock.field_71572_b, this.mainBlock.field_71573_c)) != null && tile instanceof TileStabilizerMain) {
            return (TileStabilizerMain)tile;
        }
        return null;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        TileStabilizerMain main = this.getMainBlock();
        if (main == null) {
            return 0;
        }
        return main.getMaxEnergyStored(from);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.isFormed = tag.func_74767_n("formed");
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.mainBlock = GeneralUtils.loadChunkCoord(tag, "mainBlock");
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        TileStabilizerMain main = this.getMainBlock();
        if (main == null) {
            return 0;
        }
        return main.receiveEnergy(from, maxReceive, simulate);
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        GeneralUtils.saveChunkCoord(tag, this.mainBlock, "mainBlock");
    }
}

