/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.tile;

import enhancedportals.tile.TileController;
import enhancedportals.tile.TileEP;
import enhancedportals.utility.GeneralUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TilePortalPart
extends TileEP {
    ChunkCoordinates portalController;
    TileController cachedController;

    public boolean activate(EntityPlayer player, ItemStack stack) {
        return false;
    }

    public abstract void addDataToPacket(NBTTagCompound var1);

    public void breakBlock(Block b, int oldMeta) {
        TileController controller = this.getPortalController();
        if (controller != null) {
            controller.connectionTerminate();
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        if (this.portalController != null) {
            tag.func_74768_a("PortalControllerX", this.portalController.field_71574_a);
            tag.func_74768_a("PortalControllerY", this.portalController.field_71572_b);
            tag.func_74768_a("PortalControllerZ", this.portalController.field_71573_c);
        }
        this.addDataToPacket(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tag);
    }

    public TileController getPortalController() {
        TileEntity tile;
        if (this.cachedController != null) {
            return this.cachedController;
        }
        TileEntity tileEntity = tile = this.portalController == null ? null : this.field_145850_b.func_147438_o(this.portalController.field_71574_a, this.portalController.field_71572_b, this.portalController.field_71573_c);
        if (tile != null && tile instanceof TileController) {
            this.cachedController = (TileController)tile;
            return this.cachedController;
        }
        return null;
    }

    public void onBlockPlaced(EntityLivingBase entity, ItemStack stack) {
        for (int i = 0; i < 6; ++i) {
            ChunkCoordinates c = GeneralUtils.offset(this.getChunkCoordinates(), ForgeDirection.getOrientation((int)i));
            TileEntity tile = this.field_145850_b.func_147438_o(c.field_71574_a, c.field_71572_b, c.field_71573_c);
            if (tile == null || !(tile instanceof TilePortalPart)) continue;
            ((TilePortalPart)tile).onNeighborPlaced(entity, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public abstract void onDataPacket(NBTTagCompound var1);

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.portalController = null;
        this.cachedController = null;
        if (tag.func_74764_b("PortalControllerX")) {
            this.portalController = new ChunkCoordinates(tag.func_74762_e("PortalControllerX"), tag.func_74762_e("PortalControllerY"), tag.func_74762_e("PortalControllerZ"));
        }
        this.onDataPacket(tag);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void onNeighborPlaced(EntityLivingBase entity, int x, int y, int z) {
        TileController controller = this.getPortalController();
        if (controller != null) {
            controller.deconstruct();
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("Controller")) {
            NBTTagCompound controller = compound.func_74775_l("Controller");
            this.portalController = new ChunkCoordinates(controller.func_74762_e("X"), controller.func_74762_e("Y"), controller.func_74762_e("Z"));
        }
    }

    public void setPortalController(ChunkCoordinates c) {
        this.portalController = c;
        this.cachedController = null;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        if (this.portalController != null) {
            NBTTagCompound controller = new NBTTagCompound();
            controller.func_74768_a("X", this.portalController.field_71574_a);
            controller.func_74768_a("Y", this.portalController.field_71572_b);
            controller.func_74768_a("Z", this.portalController.field_71573_c);
            compound.func_74782_a("Controller", (NBTBase)controller);
        }
    }
}

