/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.tile;

import enhancedportals.EnhancedPortals;
import enhancedportals.block.BlockPortal;
import enhancedportals.item.ItemNanobrush;
import enhancedportals.network.ClientProxy;
import enhancedportals.network.GuiHandler;
import enhancedportals.tile.TileController;
import enhancedportals.tile.TilePortalPart;
import enhancedportals.utility.GeneralUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;

public class TilePortal
extends TilePortalPart {
    @Override
    public boolean activate(EntityPlayer player, ItemStack stack) {
        TileController controller = this.getPortalController();
        if (stack != null && controller != null && controller.isFinalized()) {
            if (GeneralUtils.isWrench(stack)) {
                GuiHandler.openGui(player, controller, 0);
                return true;
            }
            if (stack.func_77973_b() == ItemNanobrush.instance) {
                GuiHandler.openGui(player, controller, player.func_70093_af() ? 10 : 9);
                return true;
            }
        }
        return false;
    }

    @Override
    public void addDataToPacket(NBTTagCompound tag) {
    }

    public IIcon getBlockTexture(int side) {
        TileController controller = this.getPortalController();
        if (controller != null) {
            if (controller.activeTextureData.hasCustomPortalTexture() && ClientProxy.customPortalTextures.size() > controller.activeTextureData.getCustomPortalTexture() && ClientProxy.customPortalTextures.get(controller.activeTextureData.getCustomPortalTexture()) != null) {
                return ClientProxy.customPortalTextures.get(controller.activeTextureData.getCustomPortalTexture());
            }
            if (controller.activeTextureData.getPortalItem() != null && controller.activeTextureData.getPortalItem().func_77973_b() instanceof ItemBlock) {
                return Block.func_149634_a((Item)controller.activeTextureData.getPortalItem().func_77973_b()).func_149691_a(side, controller.activeTextureData.getPortalItem().func_77960_j());
            }
        } else if (this.portalController != null) {
            EnhancedPortals.proxy.waitForController(new ChunkCoordinates(this.portalController.field_71574_a, this.portalController.field_71572_b, this.portalController.field_71573_c), this.getChunkCoordinates());
        }
        return BlockPortal.instance.func_149691_a(side, 0);
    }

    public int getColour() {
        TileController controller = this.getPortalController();
        if (controller != null) {
            return controller.activeTextureData.getPortalColour();
        }
        if (this.portalController != null) {
            EnhancedPortals.proxy.waitForController(new ChunkCoordinates(this.portalController.field_71574_a, this.portalController.field_71572_b, this.portalController.field_71573_c), this.getChunkCoordinates());
        }
        return 0xFFFFFF;
    }

    @Override
    public void onDataPacket(NBTTagCompound tag) {
    }

    public void onEntityCollidedWithBlock(Entity entity) {
        TileController controller = this.getPortalController();
        if (controller != null) {
            controller.onEntityEnterPortal(entity, this);
        }
    }
}

